<?php
/**
 * ファイル管理マネージャー
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
class FileManager
{
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
	}
	
	/**
	 * インストーラを退避
	 *
	 * @return bool				true=成功、false=失敗
	 */
	public function backupInstaller()
	{
		global $gEnvManager;
		
		// システムルート取得
		$sytemRoot = $gEnvManager->getSystemRootPath();
		
		$filename = $sytemRoot . '/admin/install.php';
		$backupFilename = $filename . '_backup';
		return rename($filename, $backupFilename);
	}
	/**
	 * インストーラを回復
	 *
	 * @return bool				true=成功、false=失敗
	 */
	public function recoverInstaller()
	{
		global $gEnvManager;
		
		// システムルート取得
		$sytemRoot = $gEnvManager->getSystemRootPath();
		
		$oldFilename = $sytemRoot . '/admin/install.php_backup';
		$newFilename = $sytemRoot . '/admin/install.php';
		
		// ファイルの存在チェック
		if (file_exists($newFilename)){
			return true;
		} else {
			return rename($oldFilename, $newFilename);
		}
	}
}
?>
