<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');

class admin_mainWidgetContainer extends BaseWidgetContainer
{
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * ディスパッチ処理(メインコンテナのみ実行)
	 *
     * HTTPリクエストの内容を見て処理をコンテナに振り分ける
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return bool 						このクラスの_setTemplate(), _assign()へ処理を継続するかどうかを返す。
	 *                                      true=処理を継続、false=処理を終了
	 */
	function _dispatch($request, &$param)
	{
		global $gEnvManager;
		global $gPageManager;
		global $gLaunchManager;
		
		// システム制御画面を表示するかどうか
		if ($gPageManager->getSystemHandleMode() > 0){
			$this->SetMsg(0, "ただいまサイトのメンテナンス中です");
			$param = 'message';			// メッセージ画面表示
			return true;
		}
		
		// ログイン、ログアウト処理を行う
		// 処理を行った場合は現在の画面へリダイレクト
		// ログイン失敗時あるいは、ログインログアウト以外の場合返ってくる
		$retValue = $gPageManager->standardLoginLogoutRedirect($request, $success);
		if ($retValue == 0){
			if ($gEnvManager->isCurrentUserLogined()){	// ログインしている場合
				if ($gEnvManager->isSystemAdmin()){	// システム管理者の場合
					// 表示画面を決定
					$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);
					if (empty($task)){
						$task = 'top';
					} else if ($task == 'userlist_detail'){		// ユーザ詳細
						$task = 'userlist';
					} else if ($task == 'pagedef_detail' ||		// ページ定義詳細
								$task == 'pagedef_mobile'){		// 携帯用ページ定義詳細
						$task = 'pagedef';
					} else if ($task == 'edittable' ||		// テーブルデータ編集一覧
								$task == 'edittable_detail'){		// テーブルデータ編集詳細
						$task = 'edittable';
					}
					
					// $taskが「configwidget_xxxx」タイプの場合の処理
					if (strncmp($task, 'configwidget_', strlen('configwidget_')) == 0){
						$task = 'configwidget';
					}
		
					// コンテナを起動
					switch ($task){
						case 'top';			// トップ画面
						case 'userlist':	// ユーザリスト
						case 'loginstatus':	// ログイン状況
						case 'widgetlist':	// ウィジェットリスト
						case 'templist':	// テンプレートリスト
						case 'pagedef':		// 画面定義
						case 'pageother':		// 画面定義その他
						case 'initsystem':	// システム初期化
						case 'configsys':	// システム設定
						case 'configsite':	// サイト情報
						case 'configwidget':	// ウィジェット定義
						case 'editsource':	// ソース編集
						case 'usercustom':	// ユーザ定義値管理
						case 'phpinfo':		// phpinfoを出力
						case 'createtable':		// テーブル作成
						case 'edittable':		// テーブル編集
							$gLaunchManager->goSubWidget($task);
							return false;
						case 'logout':		// ログアウト処理
							$logoutPage = $gEnvManager->createCurrentPageUrl() . '&cmd=logout';
							$gPageManager->redirect($logoutPage);
						default:
							$this->SetMsg(0, "アクセスできません");
							$param = 'message';			// メッセージ画面表示
							break;
					}
				} else {		// システム管理者以外の場合
					$this->SetMsg(0, "ログインに失敗しました");
				}
			} else {		// ログインしていないとき
				// メッセージは何も表示しないでログイン画面へ
			}
		} else if ($retValue == 1 && $success == false){	// ログイン失敗の場合
			$this->SetMsg(0, "ログインに失敗しました");
		}
		return true;
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		if ($param == 'message'){		// メッセージ表示のとき
			return 'message.tmpl.html';
		} else {
			return 'index.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		
		// POST先URLを設定
		$this->tmpl->addVar("_widget", "POST_URL", $gEnvManager->getRootUrl() . '/admin/index.php');
		
		// ディレクトリを設定
		$this->tmpl->addVar("_widget", "script_url", $gEnvManager->getScriptsUrl());
	}
}
?>
