<?php
/**
 * ヘルプマネージャー
 *
 * ヘルプ機能を管理する
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
class HelpManager
{
	private $db;						// DBオブジェクト
	private $currentWidgetId;			// 現在処理中のウィジェットID
	const INFO_ICON_FILE = '/images/system/info.gif';			// ヘルプに付加されるアイコンファイル
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// システムDBオブジェクト取得
		$this->db = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * ヘルプ用データを読み込み、取得用のキー文字列を取得
	 *
	 * ヘルプ用データは、[ウィジェットID]/include/help/index.phpファイルに格納されている
	 *
	 * @param string $widgetId		ウィジェットID
	 * @return array 				ヘルプデータ取得用キー
	 */
	function loadHelp($widgetId)
	{
		global $HELP;
		global $gEnvManager;
		
		// ウィジェットIDが異なるとき1度だけ読み込む
		if ($widgetId != $this->currentWidgetId){
			$HELP = array();		// データ初期化
			$widgetHelpFile = $gEnvManager->getWidgetsPath() . '/' . $widgetId . '/include/help/index.php';
			if (file_exists($widgetHelpFile)) {
				require($widgetHelpFile);
			} else {
				//echo 'widget help not found error: ' . $widgetId;
			}
			$this->currentWidgetId = $widgetId;
		}
		return array_keys($HELP);
	}
	/**
	 * ヘルプ用データを取得
	 *
	 * ヘルプ用データは、[ウィジェットID]/include/help/index.phpファイルに格納されている
	 *
	 * @param string $helpKey		ヘルプ取得用キー(メッセージID)
	 * @return string 				ヘルプ用データ文字列
	 */
	function getHelpText($helpKey)
	{
		global $HELP;
		global $gEnvManager;
		
		$icon = $gEnvManager->getRootUrl() . self::INFO_ICON_FILE;
		$title = $HELP[$helpKey]['title'];// ヘルプタイトル
		$body = $HELP[$helpKey]['body'];	// ヘルプ本文
		//$data = 'title="cssheader=[help_head] cssbody=[help_body] header=[<img src=\'' . $icon . '\' style=\'vertical-align:middle\'>&nbsp;&nbsp;' . 
		//			$title . '] body=[' . $body .' ] fixedrelx=[20] fixedrely=[15] delay=[1000]" style="cursor:pointer"';
		$data = 'title="cssheader=[help_head] cssbody=[help_body] header=[<img src=\'' . $icon . '\' style=\'vertical-align:middle\'>&nbsp;&nbsp;' . 
					$title . '] body=[' . $body .' ] offsetx=[20] fixedrely=[15] delay=[1000]" style="cursor:pointer"';
		return $data;
	}
	/**
	 * ヘルプ用データを作成
	 *
	 * @param string $title			ヘルプタイトル
	 * @param string $body			ヘルプ本文
	 * @return string 				ヘルプ用データ文字列
	 */
	function createHelpText($title, $body)
	{
		global $gEnvManager;
		
		$icon = $gEnvManager->getRootUrl() . self::INFO_ICON_FILE;
		//$data = 'title="cssheader=[help_head] cssbody=[help_body] header=[<img src=\'' . $icon . '\' style=\'vertical-align:middle\'>&nbsp;&nbsp;' . 
		//			$title . '] body=[' . $body .' ] fixedrelx=[20] fixedrely=[15] delay=[1000]" style="cursor:pointer"';
		//$data = 'title="cssheader=[help_head] cssbody=[help_body] header=[<img src=\'' . $icon . '\' style=\'vertical-align:middle\'>&nbsp;&nbsp;' . 
		//			$title . '] body=[' . $body .' ] offsetx=[20] fixedrely=[15] delay=[1000]" style="cursor:pointer"';
		$data = 'title="cssheader=[help_head] cssbody=[help_body] header=[<img src=\'' . $icon . '\' style=\'vertical-align:middle\'>&nbsp;&nbsp;' . 
					$title . '] body=[' . $body .' ] offsetx=[20] offsety=[15] delay=[1000]" style="cursor:pointer"';
		return $data;
	}
	/**
	 * 説明用データを作成
	 *
	 * createHelpText()との違いは、表示までの時間が短い、表示位置はデフォルト表示。
	 *
	 * @param string $title			タイトル
	 * @param string $body			本文
	 * @return string 				用データ文字列
	 */
	function createTipText($title, $body)
	{
		global $gEnvManager;
		
		$icon = $gEnvManager->getRootUrl() . self::INFO_ICON_FILE;
		$data = 'title="cssheader=[help_head] cssbody=[help_body] header=[<img src=\'' . $icon . '\' style=\'vertical-align:middle\'>&nbsp;&nbsp;' . 
					$title . '] body=[' . $body .' ] delay=[500]" style="cursor:pointer"';
		return $data;
	}
}
?>
