<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() .			'/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/reserve_mainDb.php');
require_once($gEnvManager->getLibPath()			. '/Calendar-0.5.3/Month/Weekdays.php');

class reserve_mainReserveWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	private $langId;	// 表示言語
	private $state;		// 都道府県
	const CONTACTUS_FORM = 'contact_us';		// お問い合わせフォーム
	const DEFAULT_SEND_MESSAGE = 1;		// メール送信機能を使用するかどうか(デフォルト使用)
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
			
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new reserve_mainDb();
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'reserve.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gMailManager;
		global $gErrorManager;
		global $gAccessManager;
		global $gPageManager;
		
		$now = date("Y/m/d H:i:s");	// 現在日時
		$this->langId	= $gEnvManager->getCurrentLanguage();		// 表示言語を取得
		
		// 年月を取得
		$year = $request->trimValueOf('year');		// 年指定
		if (!(is_numeric($year) && 1 <= $year)){			// エラー値のとき
			$year = date('Y');
		}
		$month = $request->trimValueOf('month');	// 月指定
		if (!(is_numeric($month) && 1 <= $month && $month <= 12)){			// エラー値のとき
			$month = date('n');
		}
		
		// 入力値を取得
		$act = $request->trimValueOf('act');
		$this->state = $request->trimValueOf('item_state');		// 都道府県
		$name = $request->trimValueOf('item_name');		// 名前
		$nameKana = $request->trimValueOf('item_name_kana');		// 名前(カナ)
		$email = $request->trimValueOf('item_email');		// Eメール
		$email2 = $request->trimValueOf('item_email2');		// Eメール確認用
		$companyName = $request->trimValueOf('item_company_name');		// 会社名
		$zipcode = $request->trimValueOf('item_zipcode');		// 郵便番号
		$address = $request->trimValueOf('item_address');		// 住所
		$phone = $request->trimValueOf('item_phone');		// 電話番号
		$body = $request->trimValueOf('item_body');		// 問い合わせ内容
		if ($act == 'send'){		// お問い合わせメール送信
			// 入力チェック
			$this->checkInput($name, 'お名前');
			$this->checkInput($nameKana, 'お名前(カナ)');
			$this->checkMailAddress($email, 'Eメール');
			$this->checkInput($body, 'お問い合わせ内容');
			if ($companyVisible){	// 会社名入力フィールドの表示
				$this->checkInput($companyName, '会社名');
			}
			if ($addressVisible){	// 住所入力フィールドの表示
				$this->checkInput($zipcode, '郵便番号');
				$this->checkInput($this->state, '都道府県');
				$this->checkInput($address, '住所');
			}					
			if ($telVisible){		// 電話番号入力フィールドの表示
				$this->checkInput($phone, '電話番号');
			}
			if ($this->getMsgCount() == 0){			// メールアドレスのチェック
				if ($email != $email2){
					$this->setAppErrorMsg('Eメールアドレスに誤りがあります');
				}
			}
			// エラーなしの場合はメール送信
			if ($this->getMsgCount() == 0){
				$this->setGuidanceMsg('送信完了しました');

				$this->tmpl->addVar("_widget", "name_disabled", 'disabled');
				$this->tmpl->addVar("_widget", "name_kana_disabled", 'disabled');
				$this->tmpl->addVar("_widget", "email_disabled", 'disabled');
				$this->tmpl->addVar("_widget", "email2_disabled", 'disabled');
				$this->tmpl->addVar("_widget", "body_disabled", 'disabled');
				
				$this->tmpl->addVar("show_company_name", "company_name_disabled", 'disabled');
				$this->tmpl->addVar("show_address", "zipcode_disabled", 'disabled');
				$this->tmpl->addVar("show_address", "state_disabled", 'disabled');
				$this->tmpl->addVar("show_address", "address_disabled", 'disabled');
				$this->tmpl->addVar("show_tel", "phone_disabled", 'disabled');
				
				$this->tmpl->addVar("_widget", "send_button_disabled", 'disabled');// 送信ボタン
			}
			$this->tmpl->addVar("_widget", "name", $name);
			$this->tmpl->addVar("_widget", "name_kana", $nameKana);
			$this->tmpl->addVar("_widget", "email", $email);
			$this->tmpl->addVar("_widget", "email2", $email2);
			$this->tmpl->addVar("_widget", "body", $body);
			$this->tmpl->addVar("show_company_name", "company_name", $companyName);
			$this->tmpl->addVar("show_address", "zipcode", $zipcode);
			$this->tmpl->addVar("show_address", "address", $address);
			$this->tmpl->addVar("show_tel", "phone", $phone);
			$this->tmpl->addVar("_widget", "send_button_label", '送信する');// 送信ボタンラベル
		} else if ($act == 'logout'){			// ログアウトのとき
			$gAccessManager->userLogout();
			
			// 画面を全体を再表示する
			$gPageManager->redirect($gEnvManager->createCurrentPageUrl());
			return;
		} else {
			// メール送信不可の場合はボタンを使用不可にする
			if ($sendMessage){
				$this->tmpl->addVar("_widget", "send_button_label", '送信する');// 送信ボタンラベル
			} else {
				$this->tmpl->addVar("_widget", "send_button_label", '送信停止中');// 送信ボタンラベル
				$this->tmpl->addVar("_widget", "send_button_disabled", 'disabled');// 送信ボタン
			}
		}
		// 入力フィールドの表示制御
		if ($companyVisible) $this->tmpl->setAttribute('show_company_name', 'visibility', 'visible');// 会社名入力フィールドの表示
		if ($addressVisible){	// 住所入力フィールドの表示
			// 都道府県メニュー
			$this->db->getAllState('JPN', $this->langId, array($this, 'stateLoop'));
			$this->tmpl->setAttribute('show_address', 'visibility', 'visible');// 住所入力フィールドの表示
		}					
		if ($telVisible) $this->tmpl->setAttribute('show_tel', 'visibility', 'visible');// 住所入力フィールドの表示
		
		// カレンダーを作成
		$calendarData = $this->createCalendar($year, $month);
		$this->tmpl->addVar("_widget", "calendar", $calendarData);
		
		// ログインユーザの表示
		$userName = $gEnvManager->getCurrentUserName();
		$this->tmpl->addVar("_widget", "login_status", 'ログイン&nbsp;&nbsp;' . $userName . ' 様');
	}
	/**
	 * カレンダーを作成
	 *
	 * @param int         $year			年
	 * @param int         $month		月
	 * @param string					生成したカレンダー
	 */
	function createCalendar($year, $month)
	{	
		global $gPageManager;
		global $gEnvManager;
		
		$calendar = new Calendar_Month_Weekdays($year, $month, 0);		// 日曜日を先頭にする
		$calendar->build();
		$prevMonth = $calendar->prevMonth();
		$nextMonth = $calendar->nextMonth();
		if ($prevMonth == 12){
			$prevYear = $year -1;
		} else {
			$prevYear = $year;
		}
		if ($nextMonth == 1){
			$nextYear = $year +1;
		} else {
			$nextYear = $year;
		}
		// データの存在する日を取得
		$startDt = $this->convertToProperDate($year . '/' . $month . '/1');
		$endDt = $this->convertToProperDate($nextYear . '/' . $nextMonth . '/1');
//		$this->db->getEntryItems($startDt, $endDt, $gEnvManager->getCurrentLanguage(), array($this, 'itemLoop'));

		// 前月、次月リンク作成
		$prevUrl = $gEnvManager->createCurrentPageUrl() . '&task=reserve&year=' . $prevYear . '&month=' . $prevMonth;
		$nextUrl = $gEnvManager->createCurrentPageUrl() . '&task=reserve&year=' . $nextYear . '&month=' . $nextMonth;

		$calendarData = '';
		$calendarData .= '<table class="blog_calendar">' . M3_NL;
		$calendarData .= '<div align="center">' . M3_NL;
		$calendarData .= '<a href="' . $prevUrl . '">' . $prevMonth. '</a>' . M3_NL;
		$calendarData .= ' | ' . $year . '/' . $month . ' | ' . M3_NL;
		$calendarData .= '<a href="' . $nextUrl . '">' . $nextMonth . '</a>' . M3_NL;
		$calendarData .= '</div>' . M3_NL;
		$calendarData .= '<tr>' . M3_NL;
		$calendarData .= '<th class="sun">日</th>' . M3_NL;
		$calendarData .= '<th class="*">月</th>' . M3_NL;
		$calendarData .= '<th>火</th>' . M3_NL;
		$calendarData .= '<th>水</th>' . M3_NL;
		$calendarData .= '<th>木</th>' . M3_NL;
		$calendarData .= '<th>金</th>' . M3_NL;
		$calendarData .= '<th class="sat">土</th>' . M3_NL;
		$calendarData .= '</tr>' . M3_NL;
		
		$week = 0;		// 曜日
		while ($Day = $calendar->fetch()) {
		    if ($Day->isFirst()) {
		        $calendarData .= '<tr>' . M3_NL;
				$week = 0;		// 曜日を初期化
		    }

		    if ($Day->isEmpty()) {
		        $calendarData .= '<td>&nbsp;</td>' . M3_NL;
		    } else {
				//if (in_array($Day->thisDay(), $this->entryDays)){			// 投稿記事あり
				if (false){					// 予約ありのとき
//					$dayUrl = $gPageManager->createWidgetCmdUrl('', self::TARGET_WIDGET, self::THIS_WIDGET_ID, 'act=view&year=' . $year . '&month=' . $month . '&day=' . $Day->thisDay());
					$dayLink = '<a href="' . $dayUrl . '">' . $Day->thisDay(). '</a>';
					$calendarData .= '<td>'. $dayLink . '</td>' . M3_NL;
											//$weekStr = ' class="select"';
				} else {
					$weekStr = '';
					if ($week == 0){		// 日曜日のとき
						$weekStr = ' class="sun"';
					} else if ($week == 6){		// 土曜日のとき
						$weekStr = ' class="sat"';
					}
		        	$calendarData .= '<td' . $weekStr . '>' . $Day->thisDay() . '</td>' . M3_NL;
				}
		    }
			$week++;		// 曜日を更新
			
		    if ($Day->isLast()) {
		        $calendarData .= '</tr>' . M3_NL;
		    }
		}
		$calendarData .= '</table></div>' . M3_NL;
		return $calendarData;
	}
}
?>
