<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');

class admin_mainTopWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $outputHtml;			// HTML出力
	const COLUMN_COUNT = 2;		// 横表示項目数
	const BUTTON_CLASS_NAME = 'toppage-button';		// CSSクラス名
	const TOPPAGE_IMAGE_PATH = 'toppage_image_path';				// トップページ画像
	const DEFAULT_ROW_COUNT = 3;			// 大項目表示数
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new admin_mainDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'top.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gHelpManager;
		
		// トップレベル項目を取得
		$menuInner = '';
		$menuInner .= '<tr valign="top"><td>';
		if ($this->db->getNavItems('admin_menu', 0, $rows)){
			$topMenuCount = count($rows);
			for ($i = 0; $i < $topMenuCount; $i++){
				$isSelected = false;		// 現在選択中の項目かどうか
				$topId = $rows[$i]['ni_id'];
				
				// サブレベル取得
				$this->db->getNavItems('admin_menu', $topId, $subRows);
				// 初期表示画面
				if (count($subRows) > 0) $firstTask = $gEnvManager->getDefaultAdminUrl() . '?task=' . $subRows[0]['ni_task_id'];
				
				// 「li」タグ
				$menuInner .= '<li class="toppage-menu">';
				
				// 「a」タグ
				// リンク先を作成。「_」で始まるタスクはリンクを作成しない
				$topLink = '#';
				$linkTask = $rows[$i]['ni_task_id'];
				if (strncmp($linkTask, '_', strlen('_')) != 0) $topLink = $gEnvManager->getDefaultAdminUrl() . '?task=' . $linkTask;	// 起動タスクパラメータを設定
				
				// ヘルプの作成
				$helpText = '';
				$title = $rows[$i]['ni_help_title'];
				if (!empty($title)){
					$helpText = $gHelpManager->createHelpText($title, $rows[$i]['ni_help_body']);
				}
				
				$menuInner .= str_repeat(' ', 4);
				//$menuInner .= '<a class="top" href="' . $firstTask . '" onclick="return false;">' . $this->convertToDispString($rows[$i]['ni_name']) . '</a>' . M3_NL;
				//$menuInner .= '<a href="' . $firstTask . '" >' . $this->convertToDispString($rows[$i]['ni_name']) . '</a>' . M3_NL;
				$menuInner .= '<a href="' . $topLink . '">' . '<span ' . $helpText . '>' . $this->convertToDispString($rows[$i]['ni_name']) . '</span></a>' . M3_NL;

				// 「ul」タグ
				$menuInner .= str_repeat(' ', 4);
				$menuInner .= '<ul>' . M3_NL;
				
				// 「li」タグ
				if (count($subRows) > 0){
					for ($l = 0; $l < count($subRows); $l++){
						// ヘルプの作成
						$helpText = '';
						$title = $subRows[$l]['ni_help_title'];
						if (!empty($title)){
							$helpText = $gHelpManager->createHelpText($title, $subRows[$l]['ni_help_body']);
						}
				
						$menuInner .= str_repeat(' ', 8);
						$menuInner .= '<li ';
						$menuInner .= '><a href="';
						$menuInner .= $gEnvManager->getDefaultAdminUrl() . '?task=' . $subRows[$l]['ni_task_id'];	// 起動タスクパラメータを設定
						if (!empty($subRows[$l]['ni_param'])){		// パラメータが存在するときはパラメータを追加
							$menuInner .= '&' . M3_REQUEST_PARAM_OPERATION_TODO . '=' . urlencode($subRows[$l]['ni_param']);
						}
						//$menuInner .= '" >' . $this->convertToDispString($subRows[$l]['ni_name']) . '</a></li>' . M3_NL;
						$menuInner .= '" ><span ' . $helpText . '>' . $this->convertToDispString($subRows[$l]['ni_name']) . '</span></a></li>' . M3_NL;
					}
				}
				$menuInner .= str_repeat(' ', 4);
				$menuInner .= '</ul>' . M3_NL;
				$menuInner .= '</li>' . M3_NL;
				if (($i + 1) % self::DEFAULT_ROW_COUNT == 0){
					$menuInner .= '</td><td>';
				}
			}
		}
		/*
		// ログアウトメニュー項目
		$menuInner .= '<li class="toppage-menu">';
		$menuInner .= '<a href="#" onclick="menuLogout();">ログアウト</a>' . M3_NL;
		$menuInner .= str_repeat(' ', 4);
		$menuInner .= '</li>' . M3_NL;*/
		
		$menuInner .= '</td></tr>';
		$this->tmpl->addVar("_widget", "items", $menuInner);
		
		// トップページ用画像
		$toppageImg = $this->db->getSystemConfig(self::TOPPAGE_IMAGE_PATH);
		if (!empty($toppageImg)){
			$toppageImg	= $gEnvManager->getRootUrl() . $toppageImg;
			$this->tmpl->addVar("showimage", "toppage_img", $toppageImg);
			$this->tmpl->setAttribute('showimage', 'visibility', 'visible');
		}
	}
}
?>
