<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/blog_mainDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/blog_commentDb.php');
require_once($gEnvManager->getCommonPath() . '/valueCheck.php');

class blog_mainWidgetContainer extends BaseWidgetContainer
{
	private $db;			// DB接続オブジェクト
	private $commentDb;			// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	private $currentDay;		// 現在日
	private $currentHour;		// 現在時間
	private $currentPageUrl;			// 現在のページURL
	private $langId;		// 言語
	private $isOutputComment;		// コメントを出力するかどうか
	private $isExistsViewData;				// 表示データがあるかどうか
	const CONTENT_TYPE = 'bg';
	const DEFAULT_LIST_COUNT = 5;			// 最大リスト表示数
	const DEFAULT_SEARCH_LIST_COUNT = 5;			// 最大リスト表示数
	const VIEW_STR_LENGTH = 200;			// 検索結果表示文字数
	const RECEIVE_COMMENT		= 'receive_comment';		// コメントを受け付けるかどうか
	const RECEIVE_TRACKBACK		= 'receive_trackback';		// トラックバックを受け付けるかどうか
	const ENTRY_VIEW_COUNT		= 'entry_view_count';			// 記事表示数
	const ENTRY_VIEW_ORDER		= 'entry_view_order';			// 記事表示方向
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new blog_mainDb();
		$this->commentDb = new blog_commentDb();
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$act = $request->trimValueOf('act');
		if ($act == 'search'){
			return 'search.tmpl.html';
		} else {
			return 'main.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gAccessManager;
				
		// 初期設定値
		$this->currentDay = date("Y/m/d");		// 日
		$this->currentHour = (int)date("H");		// 時間
		$this->currentPageUrl = $gEnvManager->createCurrentPageUrl();// 現在のページURL
		$this->langId = $gEnvManager->getDefaultLanguage();
		$sendButtonLabel = 'コメントを投稿';		// 送信ボタンラベル
		$sendStatus = 0;		// 送信状況
		$regUserId		= $gEnvManager->getCurrentUserId();			// 記事投稿ユーザ
		$regDt			= date("Y/m/d H:i:s");						// 投稿日時
		$this->isOutputComment = false;// コメントを出力するかどうか
		
		// 定義値取得
		$entryViewCount	= $this->db->getConfig(self::ENTRY_VIEW_COUNT);// 記事表示数
		$entryViewOrder	= $this->db->getConfig(self::ENTRY_VIEW_ORDER);// 記事表示順
		$receiveComment = $this->db->getConfig(self::RECEIVE_COMMENT);		// コメントを受け付けるかどうか
		
		$act = $request->trimValueOf('act');
		$entryId = $request->trimValueOf('entryid');
		$startDt = $request->trimValueOf('start');
		$endDt = $request->trimValueOf('end');
		$year = $request->trimValueOf('year');		// 年指定
		$month = $request->trimValueOf('month');		// 月指定
		$day = $request->trimValueOf('day');		// 日指定
		$keyword = $request->trimValueOf('keyword');// 検索キーワード
		// コメントの入力
		$title = $request->trimValueOf('title');
		$name = $request->trimValueOf('name');
		$email = $request->trimValueOf('email');
		$url = $request->trimValueOf('url');
		$body = $request->trimValueOf('body');
		
		$showDefault = false;			// デフォルト状態での表示
		if ($act == 'search'){			// 検索
			$itemCount = self::DEFAULT_SEARCH_LIST_COUNT;		// 取得数
			
			// キーワード検索のとき
			if (empty($keyword)){
				$keyword = '検索キーワードが入力されていません';
			} else {
				$this->db->searchEntryItemsByKeyword($itemCount, 1, $keyword, $gEnvManager->getCurrentLanguage(), array($this, 'searchItemsLoop'));
			}
		} else if ($act == 'view'){			// 記事を表示のとき
			if (!empty($year) && !empty($month)){
				// コメントを受け付けるときは、コメント入力欄を表示
				if (!empty($receiveComment)){
					$this->tmpl->setAttribute('entry_footer', 'visibility', 'visible');		// コメントへのリンク
				}
				if (empty($day)){		// 月指定のとき
					$startDt = $year . '/' . $month . '/1';
					$endDt = $this->getNextMonth($year . '/' . $month) . '/1';
					$this->db->getEntryItems($entryId, $startDt/*期間開始*/, $endDt/*期間終了*/, $entryViewCount, $gEnvManager->getCurrentLanguage(), $entryViewOrder, array($this, 'itemsLoop'));

					// 年月の表示
					$yearMonth = $year . '年 ' . $month . '月';
					// 投稿データがないときはデータなしメッセージ追加
					if (!$this->isExistsViewData) $yearMonth .= '&nbsp;&nbsp;投稿データなし';
					$this->tmpl->addVar("_widget", "year_month", '<caption>' . $yearMonth . '</caption>');
				} else {
					$startDt = $year . '/' . $month . '/' . $day;
					$endDt = $this->getNextDay($year . '/' . $month . '/' . $day);
					$this->db->getEntryItems($entryId, $startDt/*期間開始*/, $endDt/*期間終了*/, $entryViewCount, $gEnvManager->getCurrentLanguage(), $entryViewOrder, array($this, 'itemsLoop'));
				}
			}
		} else if ($act == 'checkcomment'){		// コメント確認のとき
			// 入力チェック
			$this->checkInput($body, 'コメント内容');
			$this->checkMailAddress($email, 'Eメール', true);

			// エラーなしの場合は確認画面表示
			if ($this->getMsgCount() == 0){
				// ハッシュキー作成
				$postTicket = md5(time() . $gAccessManager->getAccessLogSerialNo());
				$request->setSessionValue(M3_SESSION_POST_TICKET, $postTicket);		// セッションに保存
				$this->tmpl->addVar("_widget", "ticket", $postTicket);				// 画面に書き出し
				
				$this->setGuidanceMsg('この内容でコメントを投稿しますか?');
				
				// 入力の変更不可
				$sendButtonLabel = 'コメントを投稿';		// 送信ボタンラベル
				$sendStatus = 1;// 送信状況を「確定」に変更
				$this->tmpl->addVar("add_comment", "title_disabled", 'readonly');
				$this->tmpl->addVar("add_comment", "name_disabled", 'readonly');
				$this->tmpl->addVar("add_comment", "email_disabled", 'readonly');
				$this->tmpl->addVar("add_comment", "url_disabled", 'readonly');
				$this->tmpl->addVar("add_comment", "body_disabled", 'readonly');
				$this->tmpl->setAttribute('cancel_button', 'visibility', 'visible');		// キャンセルボタン表示
				
				// ### コメント入力欄の表示 ###
				$this->tmpl->setAttribute('add_comment', 'visibility', 'visible');// コメント入力欄表示
				$this->tmpl->addVar("add_comment", "send_button_label", $sendButtonLabel);// 送信ボタンラベル
				$this->tmpl->addVar("add_comment", "send_status", $sendStatus);// 送信状況
				$this->tmpl->setAttribute('entrylist', 'visibility', 'hidden');// 記事表示停止
			} else {
				$showDefault = true;			// デフォルト状態での表示
			}
			
			// 入力値を戻す
			$this->tmpl->addVar("add_comment", "title", $title);
			$this->tmpl->addVar("add_comment", "name", $name);
			$this->tmpl->addVar("add_comment", "email", $email);
			$this->tmpl->addVar("add_comment", "url", $url);
			$this->tmpl->addVar("add_comment", "body", $body);
			$this->tmpl->addVar("_widget", "entry_id", $entryId);		// 記事ID
		} else if ($act == 'sendcomment'){	// コメント受信のとき
			$postTicket = $request->trimValueOf('ticket');		// POST確認用
			$ret = false;
			if (!empty($entryId) && !empty($body) &&
				!empty($postTicket) && $postTicket == $request->getSessionValue(M3_SESSION_POST_TICKET)){		// 正常なPOST値のとき
				// コメントを保存
				$ret = $this->commentDb->addCommentItem($entryId, $this->langId, $title, $body, $url, $name, $email, $regUserId, $regDt, $newSerial);
			}
			if ($ret){
				$this->setGuidanceMsg('コメントを投稿しました');
			} else {
				$this->setUserErrorMsg('コメントの投稿に失敗しました');
			}
			$showDefault = true;			// デフォルト状態での表示
			$request->unsetSessionValue(M3_SESSION_POST_TICKET);		// セッション値をクリア
		} else if ($act == 'sendcancel'){	// コメントキャンセルのとき
			$showDefault = true;			// デフォルト状態での表示
		} else {
			$showDefault = true;			// デフォルト状態での表示
		}
		// ##### デフォルトの表示では、最新のn件の記事を表示または、記事ID指定で1つの記事を表示
		if ($showDefault){
			// コメントを受け付けるときは、コメント入力欄を表示
			if (!empty($receiveComment)){
				if (empty($entryId)){		
					$this->tmpl->setAttribute('entry_footer', 'visibility', 'visible');		// コメントへのリンク
				} else {		// 記事ID指定の場合のみコメント入力可能
					$this->isOutputComment = true;// コメントを出力するかどうか
					$this->tmpl->setAttribute('show_comment', 'visibility', 'visible');		// 既存コメントを表示
					$this->tmpl->addVar("_widget", "entry_id", $entryId);		// 記事を指定
					
					// ### コメント入力欄の表示 ###
					$this->tmpl->setAttribute('add_comment', 'visibility', 'visible');
					$this->tmpl->addVar("add_comment", "send_button_label", $sendButtonLabel);// 送信ボタンラベル
					$this->tmpl->addVar("add_comment", "send_status", $sendStatus);// 送信状況
				}
			}
			$this->db->getEntryItems($entryId, $startDt/*期間開始*/, $endDt/*期間終了*/, $entryViewCount, $gEnvManager->getCurrentLanguage(), $entryViewOrder, array($this, 'itemsLoop'));
		}
		$this->tmpl->addVar("_widget", "keyword", $keyword);
	}
	/**
	 * 取得したコンテンツ項目をテンプレートに設定する
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function itemsLoop($index, $fetchedRow)
	{
		global $gEnvManager;
		global $gAnalyzeManager;
			
		// 参照ビューカウントを更新
		if (!$gEnvManager->isSystemAdmin()){		// システム管理者の場合はカウントしない
			$gAnalyzeManager->updateContentViewCount(self::CONTENT_TYPE, $fetchedRow['be_serial'], $this->currentDay, $this->currentHour);
		}

		$entryId = $fetchedRow['be_id'];// 記事ID
		$title = $fetchedRow['be_name'];// タイトル
		$date = $fetchedRow['be_regist_dt'];// 日付

		// コメントを取得
		$commentCount = $this->commentDb->getCommentCountByEntryId($entryId, $this->langId);	// コメント総数
		if ($this->isOutputComment){// コメントを出力のとき
			// コメントの内容を取得
			$ret = $this->commentDb->getCommentByEntryId($entryId, $this->langId, $row);
			if ($ret){
				$this->tmpl->clearTemplate('commentlist');
				for ($i = 0; $i < count($row); $i++){
					$userName = $row[$i]['bo_user_name'];	// 投稿ユーザは入力値を使用
					$url = $row[$i]['bo_url'];
					$commentInfo = $row[$i]['bo_regist_dt'] . '&nbsp;&nbsp;' . $userName;
					if (!empty($url)) $commentInfo .= '<br>' . $url;
					$comment = $this->convertToPreviewText($row[$i]['bo_html']);		// 改行コードをbrタグに変換
					$commentRow = array(
						'comment_title'		=> $row[$i]['bo_name'],			// コメントタイトル
						'comment'		=> $comment,			// コメント内容
						'user_name'		=> $userName,			// 投稿ユーザ名
						'comment_info'	=> $commentInfo						// コメント情報
					);
					$this->tmpl->addVars('commentlist', $commentRow);
					$this->tmpl->parseTemplate('commentlist', 'a');
				}
			} else {	// コメントなしのとき
				$this->tmpl->clearTemplate('commentlist');
				$commentRow = array(
					'comment'		=> 'コメントはありません',			// コメント内容
					'comment_info'	=> ''						// コメント情報
				);
				$this->tmpl->addVars('commentlist', $commentRow);
				$this->tmpl->parseTemplate('commentlist', 'a');
			}
		}
		
		// 記事へのリンクを生成
		$linkUrl = $this->currentPageUrl . '&entryid=' . $entryId;
		$link = '<a href="' . $linkUrl . '" >コメント(' . $commentCount . ')</a>';
		
		// HTMLを出力
		// 出力内容は特にエラーチェックしない
		$entryText = $fetchedRow['be_html'];
		$entryText = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $entryText);// アプリケーションルートを変換
		
		// 記事のフッター部
		$this->tmpl->clearTemplate('entry_footer');
		$row = array(
			'link' => $link		// コメントへのリンク
		);
		$this->tmpl->addVars('entry_footer', $row);
		$this->tmpl->parseTemplate('entry_footer', 'a');
		
		$row = array(
			'title' => $title,
			'date' => $date,			// 日付
			'entry' => $entryText	// 投稿記事
		);
		$this->tmpl->addVars('entrylist', $row);
		$this->tmpl->parseTemplate('entrylist', 'a');
		$this->isExistsViewData = true;				// 表示データがあるかどうか
		return true;
	}
	/**
	 * 取得したコンテンツ項目をテンプレートに設定する
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function searchItemsLoop($index, $fetchedRow)
	{
		global $gEnvManager;

		// タイトルを設定
		$title = $fetchedRow['be_name'];
		
		// 記事へのリンクを生成
		$linkUrl = $this->currentPageUrl . '&entryid=' . $fetchedRow['be_id'];
		$link = '<a href="' . $linkUrl . '" >' . $title . '</a>';
		
		// 日付
		$date = $fetchedRow['be_regist_dt'];

		// HTMLを出力
		// 出力内容は特にエラーチェックしない
		if (function_exists('mb_substr')){
			$entryText = mb_substr(strip_tags($fetchedRow['be_html']), 0, self::VIEW_STR_LENGTH);
		} else {
			$entryText = substr(strip_tags($fetchedRow['be_html']), 0, self::VIEW_STR_LENGTH);
		}
		$row = array(
			'title' => $link,			// リンク付きタイトル
			'date' => $date,			// 日付
			'entry' => $entryText	// 投稿記事
		);
		$this->tmpl->addVars('entrylist', $row);
		$this->tmpl->parseTemplate('entrylist', 'a');
		$this->isExistsViewData = true;				// 表示データがあるかどうか
		return true;
	}
}
?>
