<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() . '/admin_ec_mainBaseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/ec_mainDb.php');

class admin_ec_mainMailinfoWidgetContainer extends admin_ec_mainBaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	
	const USE_EMAIL_TO_BACKOFFICE	= 'use_email_to_backoffice';		// EMAIL連携機能が使用可能かどうか
//	const MAIL_SUB_MEMBER_REGIST	= 'mail_sub_member_regist';		// メール件名(会員登録)
	const MAIL_TO_MEMBER_REGIST		= 'mail_to_member_regist';		// メール送信先(会員登録)
	const MAIL_FROM_MEMBER_REGIST	= 'mail_from_member_regist';	// メール送信元(会員登録)
//	const MAIL_SUB_ORDER_REGIST		= 'mail_sub_order_regist';		// メール件名(受注登録)
	const MAIL_TO_ORDER_PRODUCT		= 'mail_to_order_product';		// メール送信先(受注登録)
	const MAIL_FROM_ORDER_PRODUCT	= 'mail_from_order_product';		// メール送信元(受注登録)
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new ec_mainDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'admin_mailinfo.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		
		$defaultLang	= $gEnvManager->getDefaultLanguage();
		
		$act = $request->trimValueOf('act');
		$useEmailToBackoffice = ($request->trimValueOf(self::USE_EMAIL_TO_BACKOFFICE) == 'on') ? 1 : 0;		// EMAIL連携機能が使用可能かどうか
		//$mailSubMemberRegist	= $request->trimValueOf(self::MAIL_SUB_MEMBER_REGIST);					// メール件名(会員登録)
		$mailToMemberRegist		= $request->trimValueOf(self::MAIL_TO_MEMBER_REGIST);						// メール送信先(会員登録)
		$mailFromMemberRegist	= $request->trimValueOf(self::MAIL_FROM_MEMBER_REGIST);					// メール送信元(会員登録)
		//$mailSubOrderRegist		= $request->trimValueOf(self::MAIL_SUB_ORDER_REGIST);						// メール件名(受注登録)
		$mailToOrderRegist		= $request->trimValueOf(self::MAIL_TO_ORDER_PRODUCT);						// メール送信先(受注登録)
		$mailFromOrderRegist	= $request->trimValueOf(self::MAIL_FROM_ORDER_PRODUCT);					// メール送信元(受注登録)
		if ($act == 'update'){		// 設定更新のとき
			// 入力値のエラーチェック
//			$this->checkInput($mailSubMemberRegist, 'メール件名(会員登録)');
//			$this->checkInput($mailSubOrderRegist, 'メール件名(受注登録)');
			$this->checkMailAddress($mailToMemberRegist,	'メール送信先(会員登録)');
			$this->checkMailAddress($mailFromMemberRegist,	'メール送信元(会員登録)');
			$this->checkMailAddress($mailToOrderRegist,	'メール送信先(受注登録)');
			$this->checkMailAddress($mailFromOrderRegist,	'メール送信元(受注登録)');
			if ($this->getMsgCount() == 0){			// エラーのないとき
				$isErr = false;
				if (!$isErr){
					if (!$this->db->updateConfig(self::USE_EMAIL_TO_BACKOFFICE, $useEmailToBackoffice)) $isErr = true;
				}
			//	if (!$isErr){
			//		if (!$this->db->updateConfig(self::MAIL_SUB_MEMBER_REGIST, $mailSubMemberRegist)) $isErr = true;// メール件名(会員登録)
			//	}
				if (!$isErr){
					if (!$this->db->updateConfig(self::MAIL_TO_MEMBER_REGIST, $mailToMemberRegist)) $isErr = true;// メール送信先(会員登録)
				}
				if (!$isErr){
					if (!$this->db->updateConfig(self::MAIL_FROM_MEMBER_REGIST, $mailFromMemberRegist)) $isErr = true;// メール送信元(会員登録)
				}
			//	if (!$isErr){
		//			if (!$this->db->updateConfig(self::MAIL_SUB_ORDER_REGIST, $mailSubOrderRegist)) $isErr = true;// メール件名(受注登録)
		//		}												
				if (!$isErr){
					if (!$this->db->updateConfig(self::MAIL_TO_ORDER_PRODUCT, $mailToOrderRegist)) $isErr = true;// メール送信先(受注登録)
				}	
				if (!$isErr){
					if (!$this->db->updateConfig(self::MAIL_FROM_ORDER_PRODUCT, $mailFromOrderRegist)) $isErr = true;// メール送信元(受注登録)
				}
				if ($isErr){
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				} else {
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				}
			
				// 値を再取得
				$useEmailToBackoffice	= $this->db->getConfig(self::USE_EMAIL_TO_BACKOFFICE);					// EMAIL連携機能が使用可能かどうか
			//	$mailSubMemberRegist	= $this->db->getConfig(self::MAIL_SUB_MEMBER_REGIST);					// メール件名(会員登録)
				$mailToMemberRegist		= $this->db->getConfig(self::MAIL_TO_MEMBER_REGIST);						// メール送信先(会員登録)
				$mailFromMemberRegist	= $this->db->getConfig(self::MAIL_FROM_MEMBER_REGIST);					// メール送信元(会員登録)
		//		$mailSubOrderRegist		= $this->db->getConfig(self::MAIL_SUB_ORDER_REGIST);						// メール件名(受注登録)
				$mailToOrderRegist		= $this->db->getConfig(self::MAIL_TO_ORDER_PRODUCT);						// メール送信先(受注登録)
				$mailFromOrderRegist	= $this->db->getConfig(self::MAIL_FROM_ORDER_PRODUCT);					// メール送信元(受注登録)
			}
		} else {		// 初期表示の場合
			$useEmailToBackoffice	= $this->db->getConfig(self::USE_EMAIL_TO_BACKOFFICE);					// EMAIL連携機能が使用可能かどうか
	//		$mailSubMemberRegist	= $this->db->getConfig(self::MAIL_SUB_MEMBER_REGIST);					// メール件名(会員登録)
			$mailToMemberRegist		= $this->db->getConfig(self::MAIL_TO_MEMBER_REGIST);						// メール送信先(会員登録)
			$mailFromMemberRegist	= $this->db->getConfig(self::MAIL_FROM_MEMBER_REGIST);					// メール送信元(会員登録)
	//		$mailSubOrderRegist		= $this->db->getConfig(self::MAIL_SUB_ORDER_REGIST);						// メール件名(受注登録)
			$mailToOrderRegist		= $this->db->getConfig(self::MAIL_TO_ORDER_PRODUCT);						// メール送信先(受注登録)
			$mailFromOrderRegist	= $this->db->getConfig(self::MAIL_FROM_ORDER_PRODUCT);					// メール送信元(受注登録)
		}
		// 画面に書き戻す
		$checked = '';
		if ($useEmailToBackoffice) $checked = 'checked';
		$this->tmpl->addVar("_widget", "use_email_to_backoffice_checked", $checked);
		$this->tmpl->addVar("_widget", self::USE_EMAIL_TO_BACKOFFICE, $useEmailToBackoffice);		// EMAIL連携機能が使用可能かどうか
//		$this->tmpl->addVar("_widget", self::MAIL_SUB_MEMBER_REGIST, $mailSubMemberRegist);		// メール件名(会員登録)
		$this->tmpl->addVar("_widget", self::MAIL_TO_MEMBER_REGIST, $mailToMemberRegist);		// メール送信先(会員登録)
		$this->tmpl->addVar("_widget", self::MAIL_FROM_MEMBER_REGIST, $mailFromMemberRegist);	// メール送信元(会員登録)
//		$this->tmpl->addVar("_widget", self::MAIL_SUB_ORDER_REGIST, $mailSubOrderRegist);		// メール件名(受注登録)
		$this->tmpl->addVar("_widget", self::MAIL_TO_ORDER_PRODUCT, $mailToOrderRegist);			// メール送信先(受注登録)
		$this->tmpl->addVar("_widget", self::MAIL_FROM_ORDER_PRODUCT, $mailFromOrderRegist);		// メール送信元(受注登録)
	}
}
?>
