<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() . '/admin_ec_mainBaseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/ec_stockDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/ec_customerDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/productDb.php');

class admin_ec_mainStockplanWidgetContainer extends admin_ec_mainBaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $customerDb;		// DB接続オブジェクト
	private $productDb;		// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	private $productId;			// 商品ID
	private $planType;			// 区分
	private $customerId;		// 取引先
	private $serialNo;		// 選択中の項目のシリアル番号
	private $serialArray = array();		// 表示されている項目シリアル番号

	const VIEW_STR_LENGTH = 30;			// 表示文字数
	const ADD_STR = '...';				// 文字列を省略する場合の記号
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->productDb = new productDb();
		$this->customerDb = new ec_customerDb();
		$this->db = new ec_stockDb();
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'stockplan_detail'){		// 詳細画面
			return 'admin_stockplan_detail.tmpl.html';
		} else {			// 一覧画面
			return 'admin_stockplan.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$task = $request->trimValueOf('task');
		if ($task == 'stockplan_detail'){	// 詳細画面
			return $this->createDetail($request);
		} else {			// 一覧画面
			return $this->createList($request);
		}
	}
	/**
	 * 一覧画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createList($request)
	{
		global $gEnvManager;
		
		// ユーザ情報、表示言語
		$userId		= $gEnvManager->getCurrentUserId();
		$defaultLang	= $gEnvManager->getDefaultLanguage();
		
		$this->productId = $request->trimValueOf('productid');	// 商品ID
		if (empty($this->productId)) $this->productId = 0;

		if ($act == 'selproduct'){		// 商品の選択のとき
		}
		// 先頭の日付を求める
		$date = date("Y/m/d");	// 現在日付
		$ret = $this->db->getStockStartDate($this->productId, $date, $startDate);
		if ($ret){
			// 在庫予定を表示
			$this->db->getStockRecordByDate($this->productId, $startDate, ''/*終了日付*/, 0/*すべての区分*/, array($this, 'stockPlanListLoop'));
		}
		
		// 商品コードメニューを作成
		$this->productDb->getAllProductByLang($defaultLang, array($this, 'productListLoop'));// 商品リスト取得
		
		$this->tmpl->addVar("_widget", "serial_list", implode($this->serialArray, ','));// 表示項目のシリアル番号を設定
	}
	/**
	 * 詳細画面作成
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param								なし
	 */
	function createDetail($request)
	{
		global $gEnvManager;

		// ユーザ情報、表示言語
		$userId		= $gEnvManager->getCurrentUserId();
		$defaultLang	= $gEnvManager->getDefaultLanguage();
		
		$act = $request->trimValueOf('act');
		$this->serialNo = $request->trimValueOf('serial');		// 選択項目のシリアル番号
		if (empty($this->serialNo)) $this->serialNo = 0;
		$this->productId = $request->trimValueOf('productid');	// 商品ID
		if (empty($this->productId)) $this->productId = 0;
		
		$date = $request->trimValueOf('item_date');
		if (!empty($date)) $date = $this->convertToProperDate($date);			// 日付
		$this->planType = $request->valueOf('item_plan_type');		// 区分
		$this->customerId = $request->valueOf('item_customer');		// 取引先
		if (empty($this->customerId)) $this->customerId = 0;
		$quantity = $request->valueOf('item_quantity');		// 数量
		$note = $request->valueOf('item_note');		// 備考
		
		$replaceNew = false;		// データを再取得するかどうか
		if ($act == 'add'){		// 新規追加のとき
			// 入力チェック
			if (empty($this->productId)) $this->setUserErrorMsg('商品が選択されていません');
			$this->checkDate($date, '日付');
			if (empty($this->planType)) $this->setUserErrorMsg('区分が選択されていません');
			$this->checkNumeric($quantity, '数量');
			
			// エラーなしの場合は、データを更新
			if ($this->getMsgCount() == 0){
				$ret = $this->db->addStockPlan($this->productId, $date, $this->planType, $this->customerId, $quantity, $note, $newSerial);
				if ($ret){		// データ追加成功のとき
					$this->setMsg(self::MSG_GUIDANCE, 'データを追加しました');
					
					$this->serialNo = $newSerial;
					$replaceNew = true;			// データを再取得
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ追加に失敗しました');
				}
			}
		} else if ($act == 'update'){		// 行更新のとき
			// 入力チェック
			if (empty($this->planType)) $this->setUserErrorMsg('区分が選択されていません');
			$this->checkNumeric($quantity, '数量');
			
			// エラーなしの場合は、データを更新
			if ($this->getMsgCount() == 0){
				$ret = $this->db->updateStockPlan($this->serialNo, $this->planType, $this->customerId, $quantity, $note, $newSerial);
				if ($ret){		// データ更新成功のとき
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				
					$this->serialNo = $newSerial;
					$replaceNew = true;			// データを再取得
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}
			}
		} else if ($act == 'delete'){		// 削除のとき
			$ret = $this->db->deleteStockPlanBySerial(array($this->serialNo));
			if ($ret){		// データ更新成功のとき
				$this->setMsg(self::MSG_GUIDANCE, '項目を削除しました');
			} else {
				$this->setMsg(self::MSG_APP_ERR, '項目削除に失敗しました');
			}
		} else {		// 初期状態
			$replaceNew = true;			// データを再取得
		}
		// 表示データ再取得
		if ($replaceNew){
			$ret = $this->db->getStockPlanBySerial($this->serialNo, $row);
			if ($ret){
				$date = $this->convertToDispDate($row['sp_scheduled_dt']);// 日付
				$this->planType = $row['sp_plan_type'];		// 区分
				$this->customerId = $row['sp_customer_id'];		// 取引先
				$quantity = $row['sp_quantity'];		// 数量
				$note = $row['sp_note'];		// 備考
			}
		}
		
		// 商品情報を取得
		$ret = $this->productDb->getProductByProductId($this->productId, $defaultLang, $row, $row2, $row3, $row4, $row5);
		if ($ret){
			// 取得値を設定
			$name = $row['pt_name'];		// 名前
			$code = $row['pt_code'];		// 商品コード
		}
		
		// 区分メニュー作成
		$this->createPlanTypeMenu();

		// 取引先メニュー作成
		$this->customerDb->getStockCustomer(array($this, 'customerListLoop'));
		
		// 表示データの設定
		$this->tmpl->addVar("_widget", "name", $name);		// 名前
		$this->tmpl->addVar("_widget", "code", $code);		// 商品コード
		$this->tmpl->addVar("_widget", "date", $date);		// 日付
		$this->tmpl->addVar("_widget", "quantity", $quantity);		// 数量
		$this->tmpl->addVar("_widget", "note", $note);		// 備考
		
		// 非表示項目の設定
		$this->tmpl->addVar("_widget", "product_id", $this->productId);		// 商品ID
		
		if (empty($this->serialNo)){		// シリアル番号が空のときは新規とする
			$this->tmpl->setAttribute('add_button', 'visibility', 'visible');// 新規登録ボタン表示
		} else {
			$this->tmpl->addVar("_widget", "date_disabled", 'disabled');		// 日付
			$this->tmpl->addVar("_widget", "calender_disabled", 'disabled');		// カレンダー
			
			$this->tmpl->setAttribute('update_button', 'visibility', 'visible');// 更新ボタン表示
		}
		// 選択中のシリアル番号を設定
		$this->tmpl->addVar("_widget", "serial", $this->serialNo);
		
		// ディレクトリを設定
		$this->tmpl->addVar("_widget", "script_url", $gEnvManager->getScriptsUrl());
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function stockPlanListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;
		static $date = '';		// 日付
		static $total = 0;		// 合計
		static $findStart = false;		// 先頭を検出したかどうか
		
		// 日付を設定
		$viewDate = '';
		if ($date != $this->convertToDispDate($fetchedRow['sp_scheduled_dt'])){
			$viewDate = $this->convertToDispDate($fetchedRow['sp_scheduled_dt']);
		}
		$date = $this->convertToDispDate($fetchedRow['sp_scheduled_dt']);
		
		$quantity = intval($fetchedRow['sp_quantity']);// 数量
		$stockPlan = '未設定';
		switch ($fetchedRow['sp_plan_type']){
			case 1:
				$stockPlan = '入庫';
				$total += $quantity;
				break;
			case 2:
				$stockPlan = '出庫';
				$total -= $quantity;
				break;
			case 3:
				$stockPlan = '棚卸';
				$total = $quantity;
				$findStart = true;		// 先頭を検出したかどうか
				break;
		}
		if ($findStart){		// 先頭を検出したとき
			if ($total < 0){		// 在庫数がマイナスのとき
				$totalStr = '<font color="red">' . $total . '</font>';
			} else {
				if ($fetchedRow['sp_plan_type'] == 3){	// 棚卸のとき
					$totalStr = '<b>' . $total . '</b>';
				} else {
					$totalStr = $total;
				}
			}
		} else {		// 不確定データのとき
			$totalStr = '-';
		}
		$row = array(
			'view_index'			=> $index,											// 項目番号
			'index'			=> $fetchedRow['sp_index'],									// 項目インデックス番号
			'date'			=> $viewDate,			// 日付
			'type'			=> $stockPlan,
			'custmer_name'	=> $this->convertToDispString($fetchedRow['cc_name']),		// 取引先名
			'note'			=> $this->convertToDispString($fetchedRow['sp_note']),			// 備考
			'quantity'		=> $quantity,		// 数量
			'total'			=> $totalStr														// 計
		);
		$this->tmpl->addVars('stock_plan_list', $row);
		$this->tmpl->parseTemplate('stock_plan_list', 'a');
		
		// 表示中項目のシリアル番号を保存
		$this->serialArray[] = $fetchedRow['sp_serial'];
		return true;
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function productListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$selected = '';
		if ($fetchedRow['pt_id'] == $this->productId){
			$selected = 'selected';
		}
		$name = $this->convertToDispString($fetchedRow['pt_code']) . '&nbsp;&nbsp;' . $this->convertToDispString($fetchedRow['pt_name']);
		
		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['pt_id']),			// 商品ID
			'name'     => $name,			// 言語名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('product_list', $row);
		$this->tmpl->parseTemplate('product_list', 'a');
		return true;
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function customerListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$selected = '';
		if ($fetchedRow['cc_id'] == $this->customerId){
			$selected = 'selected';
		}
		
		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['cc_id']),			// ID
			'name'     => $this->convertToDispString($fetchedRow['cc_name']),		// 名前
			'selected' => $selected													// 選択中かどうか
		);
		$this->tmpl->addVars('customer_list', $row);
		$this->tmpl->parseTemplate('customer_list', 'a');
		return true;
	}
	/**
	 * 区分メニュー作成
	 *
	 * @return なし
	 */
	function createPlanTypeMenu()
	{
		$typeData = array(array('value' => 0, 'name'	=> '-- 未選択 --'), array('value' => 1, 'name'	=> '入庫'), array('value' => 2, 'name'	=> '出庫'), array('value' => 3, 'name'	=> '棚卸'));
		
		for ($i = 0; $i < count($typeData); $i++){
			$value = $typeData[$i]['value'];
			$name = $typeData[$i]['name'];
			$selected = '';
			if ($value == $this->planType) $selected = 'selected';
			$row = array(
				'value'    => $value,			// 値
				'name'     => $name,			// 表示名
				'selected' => $selected		// 選択中かどうか
			);
			$this->tmpl->addVars('plan_type_list', $row);
			$this->tmpl->parseTemplate('plan_type_list', 'a');
		}
	}
}
?>
