<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath()	. '/ec_mainOrderDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath()	. '/ec_mainCartDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/productDb.php');

class ec_mainDelivAddressWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $cartDb;		// カートアクセス用ＤＢオブジェクト
	private $productDb;	// DB接続オブジェクト
	private $state;	// 都道府県
	private $deliveryMethod;		// 配送方法
	private $langId;		// 現在の言語
	private $productTotal;			// 商品合計額
	const PRICE_OBJ_ID = "eclib";		// 価格計算オブジェクトID
	const DEFAULT_COUNTRY_ID = 'JPN';	// デフォルト国ID
	const STANDARD_PRICE = 'selling';		// 通常価格
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new ec_mainOrderDb();
		$this->cartDb = new ec_mainCartDb();
		$this->productDb = new productDb();
		
		// 価格計算用オブジェクト取得
		$this->ecObj = $gInstanceManager->getObject(self::PRICE_OBJ_ID);
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'delivaddress.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gPageManager;
		
		$now = date("Y/m/d H:i:s");	// 現在日時
		$countryId = self::DEFAULT_COUNTRY_ID;			// デフォルト国ID
		$this->langId	= $gEnvManager->getCurrentLanguage();		// 表示言語を取得
		$userId = $gEnvManager->getCurrentUserId();
		$defaultCurrency = $this->ecObj->getDefaultCurrency();		// 通貨
		
		/*
		$firstname = $request->trimValueOf('item_firstname');			// 名前(名)
		$familyname = $request->trimValueOf('item_familyname');			// 名前(姓)
		$firstnameKana = $request->trimValueOf('item_firstname_kana');		// 名前カナ(名)
		$familynameKana = $request->trimValueOf('item_familyname_kana');	// 名前カナ(姓)
		*/
		$name = $request->trimValueOf('item_name');			// 名前
		$nameKana = $request->trimValueOf('item_name_kana');			// 名前カナ
		$zipcode = $request->trimValueOf('item_zipcode');	// 郵便番号
		$this->state = $request->trimValueOf('item_state');	// 都道府県
		$address = $request->trimValueOf('item_address');	// 住所
		$address2 = $request->trimValueOf('item_address2');	// 住所
		$phone = $request->trimValueOf('item_phone');	// 電話番号
		$fax = $request->trimValueOf('item_fax');	// FAX
		$email = $request->trimValueOf('item_email');	// Email
		$email2 = $request->trimValueOf('item_email2');	// Email確認用
		$this->deliveryMethod = $request->trimValueOf('item_delivery_method');	// 配送方法
		
		$act = $request->trimValueOf('act');
		if ($act == 'regist'){			// 配送先仮登録
			$this->checkInput($name, '名前');		
			$this->checkInput($nameKana, '名前カナ');
			$this->checkSingleByte($zipcode, '郵便番号');
			$this->checkNumeric($this->state, '都道府県');
			$this->checkInput($address, '住所');	
			$this->checkSingleByte($phone, '電話番号');
			$this->checkInput($this->deliveryMethod, '配送方法');
			// エラーなしの場合
			if ($this->getMsgCount() == 0){
				// 購入者の情報を取得
				$ret = $this->db->getMemberInfo($userId, $memberInfo, $personInfo, $companyInfo, $addressRow);
				if ($ret){
					// 現在のログインユーザを購入者とする。購入者のID(会員ID)を取得
					$custm_id = 0;
					$ret = $this->db->getMember($this->userId, $memberRow);
					if ($ret) $custm_id = $memberRow['sm_id'] * (-1);		// 会員IDに「-」を付けて格納
					
					// 顧客は購入者の情報
					$custm_name = $personInfo['pi_family_name'] . $personInfo['pi_first_name'];
					$custm_name_kana = $personInfo['pi_family_name_kana'] . $personInfo['pi_first_name_kana'];
					$custm_person = '';
					$custm_person_kana = '';
					$custm_zipcode = $addressRow['ad_zipcode'];
					$custm_state_id = $addressRow['ad_state_id'];
					$custm_address = $addressRow['ad_address1'];
					$custm_address2 = $addressRow['ad_address2'];
					$custm_phone = $addressRow['ad_phone'];
					$custm_fax = $addressRow['ad_fax'];
					$custm_country_id = $addressRow['ad_country_id'];
				
					// 配送先は入力値
					$deliv_id = 0;
					$deliv_name = $name;
					$deliv_name_kana = $nameKana;
					$deliv_person = '';
					$deliv_person_kana = '';
					$deliv_zipcode = $zipcode;
					$deliv_state_id = $this->state;
					$deliv_address = $address;
					$deliv_address2 = $address2;
					$deliv_phone = $phone;
					$deliv_fax = '';
					$deliv_country_id = '';
				
					// 請求先は購入者
					$bill_id = $custm_id;
					$bill_name = $custm_name;
					$bill_name_kana = $custm_name_kana;
					$bill_person = $custm_person;
					$bill_person_kana = $custm_person_kana;
					$bill_zipcode = $custm_zipcode;
					$bill_state_id = $custm_state_id;
					$bill_address = $custm_address;
					$bill_address2 = $custm_address2;
					$bill_phone = $custm_phone;
					$bill_fax = $custm_fax;
					$bill_country_id = $custm_country_id;
				
					$deliv_method_id = $this->deliveryMethod;			// 配送方法
					$pay_method_id = '';
					$card_type = '';
					$card_owner = '';
					$card_number = '';
					$card_expires = '';
					$demand_dt = $gEnvManager->getInitValueOfTimestamp();
					$appoint_dt = $gEnvManager->getInitValueOfTimestamp();
					
					// クッキー読み込み、カートIDを取得
					$cartId = $request->getCookieValue(M3_COOKIE_CART_ID);
					$this->productTotal = 0;					// 合計価格
					if (!empty($cartId)){	// カートIDが設定されているとき
						// カートの商品を取得
						$this->cartDb->getCartItemList($cartId, $this->langId, array($this, 'cartLoop'));
					}
					$currency_id = $defaultCurrency;
					$subtotal = $this->productTotal;		// 商品合計

					// 配送料金を求める
					$deliv_fee = 0;		// 配送料
					$demand_time = '';	// 希望時間帯
					$demand_dt = $gEnvManager->getInitValueOfTimestamp();		// 希望日
					if ($this->db->getDelivMethod($this->deliveryMethod, $this->langId, 0/*デフォルトのセットID*/, $delivMethodRow)){
						$iWidgetId	= $delivMethodRow['do_iwidget_id'];	// インナーウィジェットID
						if (!empty($iWidgetId)){
							// パラメータをインナーウィジェットに設定し、計算結果を取得
							$optionParam->userId = $userId;					// ログインユーザID
							$optionParam->languageId = $this->langId;		// 言語ID
							$optionParam->cartId = $cartId;					// 商品のカート
							if ($this->calcIWidgetParam($iWidgetId, $delivMethodRow['do_id'], $delivMethodRow['do_param'], $optionParam, $resultObj)){
								if (isset($resultObj->price)) $deliv_fee = $resultObj->price;		// 配送料金
								if (isset($resultObj->date)) $demand_dt = $resultObj->date;	// 希望日
								if (isset($resultObj->time)) $demand_time = $resultObj->time;	// 希望時間帯
							}
						}
					}
					
					$charge = 0;		// 手数料
					$discount = 0;		// 値引き額
					$total = $subtotal - $discount + $deliv_fee + $charge;		// 総支払額を求める
					$ret = $this->db->updateOrderSheet($userId, $this->langId, 
						$custm_id, $custm_name, $custm_name_kana, $custm_person, $custm_person_kana, $custm_zipcode, $custm_state_id, $custm_address, $custm_address2, $custm_phone, $custm_fax, $custm_country_id, 
						$deliv_id, $deliv_name, $deliv_name_kana, $deliv_person, $deliv_person_kana, $deliv_zipcode, $deliv_state_id, $deliv_address, $deliv_address2, $deliv_phone, $deliv_fax, $deliv_country_id,
						$bill_id,  $bill_name,  $bill_name_kana,  $bill_person,  $bill_person_kana,  $bill_zipcode,  $bill_state_id,  $bill_address, $bill_address2,  $bill_phone,  $bill_fax,  $bill_country_id,
						$deliv_method_id, $pay_method_id, $card_type, $card_owner, $card_number, $card_expires, $demand_dt, $demand_time, $appoint_dt, $currency_id, $subtotal, $discount, $deliv_fee, $charge, $total,
						$userId);
					// エラーがなければお支払い画面へ
					if ($ret){
						$deliveryPage = $gEnvManager->createCurrentPageUrl() . '&task=payment';
						$gPageManager->redirect($deliveryPage);
						return;
					} else {
						$this->setAppErrorMsg('登録処理に失敗しました。');
					}
				} else {
					$this->setAppErrorMsg('ログイン中のユーザは会員登録されていません。会員登録が必要です。');
				}
			}
		} else if ($act == 'reload'){			// データリロードのとき(戻るボタン)
			$ret = $this->db->getOrderSheet($userId, $this->langId, $row);
			if ($ret){
				$name = $row['oe_deliv_name'];
				$nameKana = $row['oe_deliv_name_kana'];
				$zipcode = $row['oe_deliv_zipcode'];
				$address = $row['oe_deliv_address1'];
				$address2 = $row['oe_deliv_address2'];
				$phone = $row['oe_deliv_phone'];
				$this->state = $row['oe_deliv_state_id'];
				$this->deliveryMethod = $row['oe_deliv_method_id'];		// 配送方法
			}
		} else {		// 初期表示
			// デフォルトの配送先を取得
			// 会員情報を取得
			$ret = $this->db->getMember($userId, $memberRow);
			if ($ret){
				if ($memberRow['sm_type'] == 1){		// 個人メンバーのとき
					// 個人情報取得
					$ret = $this->db->getPersonInfo($memberRow['sm_person_info_id'], $personRow);
					if ($ret){
						$ret = $this->db->getAddress($personRow['pi_address_id'], $addressRow);
						if ($ret){
							/*$firstname = $personRow['pi_first_name'];
							$familyname = $personRow['pi_family_name'];
							$firstnameKana = $personRow['pi_first_name_kana'];
							$familynameKana = $personRow['pi_family_name_kana'];
							*/
							$name = $personRow['pi_family_name'] . $personRow['pi_first_name'];
							$nameKana = $personRow['pi_family_name_kana'] . $personRow['pi_first_name_kana'];
							$zipcode = $addressRow['ad_zipcode'];
							$address = $addressRow['ad_address1'];
							$address2 = $addressRow['ad_address2'];
							$phone = $addressRow['ad_phone'];
							$this->state = $addressRow['ad_state_id'];
						}
					}
				}
			}
		}
		
		// 入力値を戻す
		$this->tmpl->addVar("_widget", "name", $name);
		$this->tmpl->addVar("_widget", "name_kana", $nameKana);
		$this->tmpl->addVar("_widget", "zipcode", $zipcode);
		$this->tmpl->addVar("_widget", "address", $address);
		$this->tmpl->addVar("_widget", "address2", $address2);
		$this->tmpl->addVar("_widget", "phone", $phone);
		
		// 都道府県を設定
		$this->db->getAllState('JPN', $this->langId, array($this, 'stateLoop'));
		
		// 配送方法メニューを作成
		$this->db->getAllDelivMethod($this->langId, 0/*デフォルトのセットID*/, array($this, 'delivMethodLoop'));
		
		// 遷移先を設定
		$this->tmpl->addVar("_widget", "cart_url", $gEnvManager->createCurrentPageUrl() . '&task=cart');		// カート画面
		//$this->tmpl->addVar("_widget", "payment_url", $gEnvManager->createCurrentPageUrl() . '&task=payment');		// 支払い画面
		$this->tmpl->addVar("_widget", "delivery_url", $gEnvManager->createCurrentPageUrl() . '&task=delivery');		// 配送先画面
	}
	/**
	 * 取得した都道府県をテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function stateLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$selected = '';
		if ($fetchedRow['gz_id'] == $this->state){		// 選択中の都道府県
			$selected = 'selected';
		}

		$row = array(
			'value'    => $this->convertToDispString($fetchedRow['gz_id']),			// ID
			'name'     => $this->convertToDispString($fetchedRow['gz_name']),			// 表示名
			'selected' => $selected														// 選択中かどうか
		);
		$this->tmpl->addVars('state_list', $row);
		$this->tmpl->parseTemplate('state_list', 'a');
		return true;
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function cartLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$priceStatus = 1;	// 価格が有効であるかどうか
		$id = $fetchedRow['si_product_id'];	// 商品ID
		
		// 商品を取得
		$ret = $this->productDb->getProductByProductId($id, $this->langId, $row, $row2, $row3, $row4, $row5);
		if ($ret){
			$name = $this->convertToDispString($row['pt_name']);		// 名前
			$code = $this->convertToDispString($row['pt_code']);		// 商品コード
			
			// 商品の現在価格を取得
			// 価格を取得
			$priceArray = $this->getPrice($row2, self::STANDARD_PRICE);
			$price = $priceArray['pp_price'];	// 価格
			$currency = $priceArray['pp_currency_id'];	// 通貨
			$taxType = $row['pt_tax_type_id'];					// 税種別
					
			// 価格作成
			$this->ecObj->setCurrencyType($currency, $this->langId);		// 通貨設定
			$this->ecObj->setTaxType($taxType, $this->langId);		// 税種別設定
			$unitPrice = $this->ecObj->getPriceWithTax($price, $dispUnitPrice);	// 税込み価格取得
			
			// 商品が表示不可のときは価格を無効とする
			if (!$row['pt_visible']) $priceStatus = 0;
		} else {
			// 商品情報が取得できないときは価格無効
			$priceStatus = 0;
		}
		
		// 価格が変更のときは、価格を無効にする
		$quantity = $fetchedRow['si_quantity'];
		$subtotal = $fetchedRow['si_subtotal'];
		$oldCurrency = $fetchedRow['si_currency_id'];
		if ($unitPrice * $quantity != $subtotal) $priceStatus = 0;
		if ($oldCurrency != $currency) $priceStatus = 0;
		
		// 通貨情報を取得
		$ret = $this->cartDb->getCurrency($oldCurrency, $this->langId, $row);
		if ($ret){
			$prePrice = $this->convertToDispString($row['cu_symbol']);
			$postPrice = $this->convertToDispString($row['cu_post_symbol']);
		}
		
		// 価格作成
		$this->ecObj->setCurrencyType($oldCurrency, $this->langId);		// 通貨設定
		$this->ecObj->getPriceWithoutTax($subtotal, $dispPrice);				// 税込み価格取得
					
		// 価格の有効判断
		if (!$fetchedRow['si_available']) $priceStatus = 0;
		
		// 小計価格
		$available = '';
		if ($priceStatus == 0) $available = '(無効)';
		$price = $prePrice . $dispPrice . $available;
		
		$this->productTotal += $subtotal;					// 合計価格
		return true;
	}
	/**
	 * 価格取得
	 *
	 * @param array  	$srcRows			価格リスト
	 * @param string	$priceType			価格のタイプ
	 * @return array						取得した価格行
	 */
	function getPrice($srcRows, $priceType)
	{
		for ($i = 0; $i < count($srcRows); $i++){
			if ($srcRows[$i]['pp_price_type_id'] == $priceType){
				return $srcRows[$i];
			}
		}
		return array();
	}
	/**
	 * 取得した配送方法をテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function delivMethodLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;

		$checked = '';
		if ($fetchedRow['do_id'] == $this->deliveryMethod){		// 選択中の配送方法
			$checked = 'checked';
		}

		// 配送料金を求める
		$iWidgetId	= $fetchedRow['do_iwidget_id'];	// インナーウィジェットID
		if (!empty($iWidgetId)){
			// パラメータをインナーウィジェットに設定し、計算結果を取得
			if ($this->calcIWidgetParam($iWidgetId, $fetchedRow['do_id'], $fetchedRow['do_param'], $optionParam, $resultObj)){
				$price = $resultObj->price;		// 配送料金
			}
			$content = $this->getIWidgetContent($iWidgetId, $fetchedRow['do_id']);	// 通常画面を取得
		}
					
		$row = array(
			'value'		=> $this->convertToDispString($fetchedRow['do_id']),			// ID
			'name'		=> $this->convertToDispString($fetchedRow['do_name']),		// 表示名
			'desc'		=> $fetchedRow['do_description'],							// 説明
			'price'		=> $price,							// 配送料金
			'def_content'		=> $content,		// ユーザ選択用コンテンツ
			'checked'	=> $checked														// 選択中かどうか
		);
		$this->tmpl->addVars('deliv_method_list', $row);
		$this->tmpl->parseTemplate('deliv_method_list', 'a');
		return true;
	}
}
?>
