<?php
/**
 * DBクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getDbPath() . '/baseDb.php');

class ec_mainCartDb extends BaseDb
{
	/**
	 * カート内容を取得を取得
	 *
	 * @param string	$cartId				カートID
	 * @param string	$lang				言語
	 * @param function	$callback			コールバック関数
	 * @return 			なし
	 */
	function getCartItemList($cartId, $lang, $callback)
	{
		$queryStr = 'SELECT * FROM shop_cart ';
		$queryStr .=  'WHERE sh_id = ? AND sh_language_id = ? ';
		$ret = $this->selectRecord($queryStr, array($cartId, $lang), $row);
		if ($ret){
			$queryStr = 'select * from shop_cart_item LEFT JOIN currency ON si_currency_id = cu_id AND cu_language_id = ? ';
			$queryStr .=  'WHERE si_head_serial = ? ';
			$queryStr .=  'ORDER BY cu_index,si_serial';
			$this->selectLoop($queryStr, array($lang, $row['sh_serial']), $callback, null);
		}
	}
	/**
	 * 通貨情報を取得
	 *
	 * @param string	$type				単位タイプ
	 * @param string	$lang				言語
	 * @param array     $row				レコード
	 * @return bool							取得 = true, 取得なし= false
	 */
	function getCurrency($type, $lang, &$row)
	{
		$queryStr = 'SELECT * FROM currency ';
		$queryStr .=  'WHERE cu_id = ? AND cu_language_id = ? ';
		$ret = $this->selectRecord($queryStr, array($type, $lang), $row);
		return $ret;
	}
	/**
	 * カートヘッダ情報を取得
	 *
	 * @param string	$cartId				カートID
	 * @param string	$lang				言語
	 * @param array     $row				レコード
	 * @return bool							取得 = true, 取得なし= false
	 */
	function getCartHead($cartId, $lang, &$row)
	{
		$queryStr = 'SELECT * FROM shop_cart ';
		$queryStr .=  'WHERE sh_id = ? AND sh_language_id = ? ';
		$ret = $this->selectRecord($queryStr, array($cartId, $lang), $row);
		return $ret;
	}
	/**
	 * カート商品情報を取得
	 *
	 * @param int		$serial				カートシリアル番号
	 * @param string	$productId			商品ID
	 * @param array     $row				レコード
	 * @return bool							取得 = true, 取得なし= false
	 */
	function getCartItem($serial, $productId, &$row)
	{
		$queryStr = 'SELECT * FROM shop_cart_item ';
		$queryStr .=  'WHERE si_head_serial = ? AND si_product_id = ? ';
		$ret = $this->selectRecord($queryStr, array($serial, $productId), $row);
		return $ret;
	}
	/**
	 * カート内の商品を削除
	 *
	 * @param int		$serial				カートシリアル番号
	 * @param int		$item_serial		カート商品シリアル番号
	 * @return bool							取得 = true, 取得なし= false
	 */
	function deleteProductInCart($serial, $item_serial)
	{
		if ($serial == 0) return true;		// カートがまだ存在しないとき
			
		$now = date("Y/m/d H:i:s");	// 現在日時
				
		// トランザクション開始
		$this->startTransaction();
		
		// カートヘッダの日付を更新
		$queryStr  = 'UPDATE shop_cart ';
		$queryStr .=   'SET sh_dt = ? ';
		$queryStr .=   'WHERE sh_serial = ? ';
		$this->execStatement($queryStr, array($now, $serial));
		
		if ($item_serial == 0){			// カート内の商品をすべて削除
			// 全商品を削除
			$queryStr  = 'DELETE FROM shop_cart_item ';
			$queryStr .=   'WHERE si_head_serial = ? ';
			$this->execStatement($queryStr, array($serial));
		} else {
			// カート商品を削除
			$queryStr  = 'DELETE FROM shop_cart_item ';
			$queryStr .=   'WHERE si_serial = ? ';
			$this->execStatement($queryStr, array($item_serial));
		}
		
		// トランザクション確定
		$ret = $this->endTransaction();
		return $ret;
	}
	/**
	 * カート商品を更新
	 *
	 * @param int		$serial				カート商品シリアル番号
	 * @param string	$currency			通貨
	 * @param int		$quantity			数量
	 * @param float	    $subtotal			小計
	 * @param int		$available			利用可能かどうか
	 * @return bool							取得 = true, 取得なし= false
	 */
	function updateProductInCart($serial, $currency, $quantity, $subtotal, $available)
	{
		// トランザクション開始
		$this->startTransaction();
	
		// カート商品を更新
		$queryStr  = 'UPDATE shop_cart_item ';
		$queryStr .=   'SET si_currency_id = ?, ';
		$queryStr .=   'si_quantity = ?, ';
		$queryStr .=   'si_subtotal = ?, ';
		$queryStr .=   'si_available = ? ';
		$queryStr .=   'WHERE si_serial = ? ';
		$this->execStatement($queryStr, array($currency, $quantity, $subtotal, $available, $serial));
		
		// トランザクション確定
		$ret = $this->endTransaction();
		return $ret;
	}
	/**
	 * カートヘッダを更新
	 *
	 * @param int		$serial				カートシリアル番号
	 * @return bool							取得 = true, 取得なし= false
	 */
	function updateCartDt($serial)
	{
		if ($serial == 0) return true;		// カートがまだ存在しないとき
			
		$now = date("Y/m/d H:i:s");	// 現在日時
		
		// トランザクション開始
		$this->startTransaction();
		
		// カートヘッダの日付を更新
		$queryStr  = 'UPDATE shop_cart ';
		$queryStr .=   'SET sh_dt = ? ';
		$queryStr .=   'WHERE sh_serial = ? ';
		$this->execStatement($queryStr, array($now, $serial));
		
		// トランザクション確定
		$ret = $this->endTransaction();
		return true;
	}
}
?>
