<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: blog_new_boxWidgetContainer.php 1439 2009-01-14 04:00:01Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath()		. '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath()	. '/blog_new_boxDb.php');
require_once($gEnvManager->getCommonPath()			. '/htmlEdit.php');

class blog_new_boxWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	private $isEntry;	// 記事の投稿があるかどうか
	private $scriptUrl;
	const TARGET_WIDGET = 'blog_main';		// 呼び出しウィジェットID
	const THIS_WIDGET_ID = 'blog_new_box';		// ウィジェットID
	const DEFAULT_LIST_COUNT = 20;			// 最大リスト表示数
	const MAX_TITLE_LENGTH = 20;			// タイトルの最大文字列長
		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
			
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new blog_new_boxDb();
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'index.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		// DBの保存設定値を取得
		$itemCount = self::DEFAULT_LIST_COUNT;				// 表示項目数
		$serializedParam = $this->sysDb->getWidgetParam(self::THIS_WIDGET_ID);
		if (!empty($serializedParam)){
			$dispInfo = unserialize($serializedParam);
			$itemCount = $dispInfo->viewCount;		// 一覧表示数
		}
		// 新規ブログタイトルを取得
		$this->scriptUrl = $this->gEnv->getCurrentScriptUrl();			// 現在実行されているスクリプトURL
		$this->db->getEntryItems($itemCount, $this->gEnv->getCurrentLanguage(), array($this, 'itemLoop'));
			
		if (!$this->isEntry){	// 記事の投稿がないときはメッセージを出力
			$this->tmpl->addVar("_widget", "message", '投稿記事はありません');
		}
		// メニューテーブルのパラメータ
		$this->tmpl->addVar("_widget", "default_menu_param", $this->gDesign->getDefaultWidgetTableParam());
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function itemLoop($index, $fetchedRow, $param)
	{
		// タイトルを設定
		$title = $fetchedRow['be_name'];
		// タイトルの長さは制限
		if (function_exists('mb_substr')){
			$title = mb_substr($title, 0, self::MAX_TITLE_LENGTH);
		} else {
			$title = substr($title, 0, self::MAX_TITLE_LENGTH);
		}
		
		// 記事へのリンク
		$url  = $this->scriptUrl;
		$url .= '?' . M3_REQUEST_PARAM_OPERATION_COMMAND . '=' . M3_REQUEST_CMD_FIND_WIDGET;
		$url .= '&' . M3_REQUEST_PARAM_WIDGET_ID . '=' . self::TARGET_WIDGET;
		$url .= '&' . M3_REQUEST_PARAM_FROM . '=' . self::THIS_WIDGET_ID;		// 送信元
		$url .= '&' . M3_REQUEST_PARAM_OPERATION_TODO . '=' . urlencode('entryid=' . $fetchedRow['be_id']);
		$nameLink = '<a href="' . $this->convertUrlToHtmlEntity($url) . '">' . $title . '</a>';

		$row = array(
			'new_item' => $nameLink
		);
		$this->tmpl->addVars('itemlist', $row);
		$this->tmpl->parseTemplate('itemlist', 'a');
		
		$this->isEntry = true;	// 記事の投稿があるかどうか
		return true;
	}
}
?>
