<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: ec_mainWidgetContainer.php 1670 2009-03-30 07:21:56Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/ec_mainDb.php');

class ec_mainWidgetContainer extends BaseWidgetContainer
{
	private $mainDb;	// DB接続オブジェクト
	const SES_KEY_AGREE_MEMBER = 'agree_member';		// 会員規約に同意したかどうかのセッションキー
	const CF_PERMIT_NON_MEMBER_ORDER = 'permit_non_member_order';			// 非会員の購入許可
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		$this->mainDb = new ec_mainDb();
	}
	/**
	 * ディスパッチ処理(メインコンテナのみ実行)
	 *
     * HTTPリクエストの内容を見て処理をコンテナに振り分ける
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return bool 						このクラスの_setTemplate(), _assign()へ処理を継続するかどうかを返す。
	 *                                      true=処理を継続、false=処理を終了
	 */
	function _dispatch($request, &$param)
	{
		// 実行処理を決定
		$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);
		if (empty($task)) $task = 'product';

		// ##### アクセス制御 #####
		$canNonMemberOrder = $this->mainDb->getConfig(self::CF_PERMIT_NON_MEMBER_ORDER);
		if (empty($canNonMemberOrder)){			// 会員のみ注文が可能なとき
			// ログインが必要な処理の場合は、ログイン状況をチェックする
			switch ($task){
				case 'order';			// 注文開始
				case 'regcustomer';			// 購入者情報入力
				case 'delivery';		// 配送先入力
				case 'delivmethod';		// 配送方法選択
				case 'payment';			// 支払い
				case 'confirm';			// 確認
				case 'complete';		// 手続き完了
				case 'member';			// 会員情報変更
				case 'changepwd';			// パスワード変更
				case 'orderhistory';			// 注文履歴
					// ログイン状態を取得
					if (!$this->gEnv->isCurrentUserLogined()){		// ログインされていない場合
						$this->SetMsg(0, "ログインが必要です");
						return true;
					}
			}
		} else {
			// ログインが必要な処理の場合は、ログイン状況をチェックする
			switch ($task){
				case 'member';			// 会員情報変更
				case 'changepwd';		// パスワード変更
				case 'orderhistory';	// 注文履歴
					// ログイン状態を取得
					if (!$this->gEnv->isCurrentUserLogined()){		// ログインされていない場合
						$this->SetMsg(0, "ログインが必要です");
						return true;
					}
			}
		}
		
		// ##### 遷移先を決定 #####
		if ($task == 'order'){
			if ($this->gEnv->isCurrentUserLogined()){		// ユーザがログインしている場合(会員の場合)
				// 注文の画面遷移(配送先入力→配送方法選択→支払い方法入力→確認)
				$orderPage = $this->gEnv->createCurrentPageUrl() . '&task=delivery';// 配送先入力
				$this->gPage->redirect($orderPage);
				return true;
			} else {			// 非会員の購入の場合
				// 注文の画面遷移(購入者情報入力→配送先入力→配送方法選択→支払い方法入力→確認)
				$orderPage = $this->gEnv->createCurrentPageUrl() . '&task=regcustomer';// 購入者情報入力
				$this->gPage->redirect($orderPage);
				return true;
			}
		}
		
		// 会員規約を承認していない場合は、規約ページへ遷移
		if ($task == 'regmember' && $this->getWidgetSession(self::SES_KEY_AGREE_MEMBER, 0) == 0){
			$task = 'agreemember';		// 会員規約
		}
		
		// ##### コンテナを起動 #####
		switch ($task){
			case 'product':			// 商品表示機能
			case 'cart';			// カート機能
			case 'login';			// 会員ログイン
			case 'regmember';			// 会員登録
			case 'regcustomer';			// 購入者情報入力
			case 'delivery';		// 配送
			case 'delivmethod';		// 配送方法選択
			case 'payment';			// 支払い
			case 'confirm';			// 確認
			case 'complete';		// 手続き完了
			case 'sendpwd';			// パスワード送信
			case 'member';			// 会員情報変更
			case 'agreemember';		// 会員規約表示
			case 'changepwd';			// パスワード変更
			case 'orderhistory';			// 注文履歴
				$this->gLaunch->goSubWidget($task);
				return false;
			default:
				$this->SetMsg(0, "画面が見つかりません");
				return true;
		}
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);

		// 要求画面によってテンプレートを変更
		switch ($task){
			case 'order';			// 注文開始
			case 'regcustomer';			// 購入者情報入力
			case 'delivery';		// 配送
			case 'delivmethod';		// 配送方法選択
			case 'payment';			// 支払い
			case 'confirm';			// 確認
			case 'complete';		// 手続き完了
			case 'member';			// 会員情報変更
			case 'changepwd';			// パスワード変更
			case 'orderhistory';			// 注文履歴
				// ログインが必要であるメッセージを表示
				return 'message_login.tmpl.html';
			default:
				return 'message.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @return								なし
	 */
	function _assign($request, &$param)
	{
		$task = $request->trimValueOf(M3_REQUEST_PARAM_OPERATION_TASK);

		// 要求画面によってテンプレートを変更
		switch ($task){
			case 'order';			// 注文開始
			case 'regcustomer';			// 購入者情報入力
			case 'delivery';		// 配送
			case 'delivmethod';		// 配送方法選択
			case 'payment';			// 支払い
			case 'confirm';			// 確認
			case 'complete';		// 手続き完了
			case 'member';			// 会員情報変更
			case 'changepwd';			// パスワード変更
			case 'orderhistory';			// 注文履歴
				// ログインが必要であるメッセージを表示
				$this->tmpl->addVar("_widget", "login_url", $this->gEnv->createCurrentPageUrl() . '&task=login');		// ログイン用URL
			default:
		}
	}
}
?>
