<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: static_contentWidgetContainer.php 1343 2008-12-12 07:12:34Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/static_contentDb.php');

class static_contentWidgetContainer extends BaseWidgetContainer
{
	private $db;			// DB接続オブジェクト
	private $langId;		// 現在の言語
	const DEFAULT_CONFIG_ID = 0;
	const CONTENT_TYPE = '';			// コンテンツタイプ
		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new static_contentDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'main.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$this->langId = $this->gEnv->getCurrentLanguage();
		
		// 定義ID取得
		$configId = $this->gEnv->getCurrentWidgetConfigId();
		if (empty($configId)) $configId = self::DEFAULT_CONFIG_ID;
		
		// パラメータオブジェクトを取得
		$paramObj = $this->getWidgetParamObj();
		
		// コンテンツIDを取得
		$contentId = 0;
		$name = '';
		$showTitle = 1;
		for ($i = 0; $i < count($paramObj); $i++){
			$targetObj = $paramObj[$i];
			$id = $targetObj->id;// 定義ID
			if ($id == $configId){
				$contentId = $targetObj->contentId;
				$name = $targetObj->name;// 定義名
				$showTitle = $targetObj->showTitle;// タイトルを表示するかどうか
				break;
			}
		}
		if ($i < count($paramObj)){		// 該当する定義IDのデータが取得できたとき
			// コンテンツを取得
			$ret = $this->db->getContentByContentId(self::CONTENT_TYPE, $contentId, $this->langId, $row);
			if ($ret){
				// Magic3マクロ変換
				$html = $this->convertM3ToHtml($row['cn_html']);
				
				// 	テーブルのパラメータ
				$this->tmpl->addVar("show_html", "title_param", $this->gDesign->getDefaultWidgetTableParam());
		
				// タイトルの設定
				if ($showTitle){		// タイトル表示のとき
					$this->tmpl->setAttribute('show_title', 'visibility', 'visible');
					$this->tmpl->addVar("show_title", "title", $this->convertToDispString($name));
				}

				// コンテンツを設定
				$this->tmpl->addVar("show_html", "content", $html);
			
				// ログインユーザに表示が制限されている場合は非表示
				if ($this->gEnv->isCurrentUserLogined() || !$row['cn_user_limited']) $this->tmpl->setAttribute('show_html', 'visibility', 'visible');
			}
		}
	}
}
?>
