<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: default_menuWidgetContainer.php 1958 2009-06-03 09:37:33Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/default_menuDb.php');

class default_menuWidgetContainer extends BaseWidgetContainer
{
	private $db;			// DB接続オブジェクト
	private $langId;		// 現在の言語
	private $paramObj;		// 定義取得用
	private $templateType;		// テンプレートのタイプ
	const DEFAULT_CONFIG_ID = 0;
	const MAX_MENU_TREE_LEVEL = 5;			// メニュー階層最大数
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new default_menuDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		// Joomlaテンプレートのバージョンに合わせて出力
		$this->templateType = $this->gEnv->getCurrentTemplateType();
		if ($this->templateType == 0){			// Joomla!v1.0のとき
			return 'index_old.tmpl.html';
		} else {
			return 'index.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$this->langId = $this->gEnv->getCurrentLanguage();
		
		// 定義ID取得
		$configId = $this->gEnv->getCurrentWidgetConfigId();
		if (empty($configId)) $configId = self::DEFAULT_CONFIG_ID;
		
		// パラメータオブジェクトを取得
		$targetObj = $this->getWidgetParamObjByConfigId($configId);
		if (!empty($targetObj)){		// 定義データが取得できたとき
			$menuId		= $targetObj->menuId;	// メニューID
			$name		= $targetObj->name;// 定義名
			$limitUser	= $targetObj->limitUser;// ユーザを制限するかどうか
			
			// ユーザ制限があるときはログイン時のみ表示
			if (!$limitUser || $this->gEnv->isCurrentUserLogined()){
				$this->tmpl->setAttribute('show_html', 'visibility', 'visible');
			
				// メニュー作成
				$this->createMenu($menuId, 0);
			}
		}
	}
	/**
	 * メニューツリー作成
	 *
	 * @param string	$menuId		メニューID
	 * @param int		$parantId	親メニュー項目ID
	 * @param int		$level		階層数
	 * @return 						なし
	 */
	function createMenu($menuId, $parantId, $level = 0)
	{
		static $index = 0;		// インデックス番号
		
		// メニューの階層を制限
		if ($level >= self::MAX_MENU_TREE_LEVEL) return '';
		
		if ($this->db->getChildMenuItems($menuId, $parantId, $rows)){
			$itemCount = count($rows);
			for ($i = 0; $i < $itemCount; $i++){
				$row = $rows[$i];
				$classArray = array();
				$attr = '';
				
				// 非表示のときは処理を飛ばす
				if (!$row['md_visible']) continue;
				
				// Joomla1.0対応
				if ($this->templateType == 0) $classArray[] = 'mainlevel';
				
				// リンク先の作成
				$linkUrl = $row['md_link_url'];
				$linkUrl = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $this->gEnv->getRootUrl(), $linkUrl);
				if (empty($linkUrl)) $linkUrl = '#';
				if ($linkUrl == $this->gEnv->getCurrentRequestUri()){		// メニュー項目が現在表示中のとき
					$attr = ' id="current"';
					//$attr = ' class="active"';
				}
				
				// リンクタイプに合わせてタグを生成
				$option = '';
				if (count($classArray) > 0) $option .= 'class="' . implode(' ', $classArray) . '"';
				switch ($row['md_link_type']){
					case 0:			// 同ウィンドウで開くリンク
						break;
					case 1:			// 別ウィンドウで開くリンク
						$option .= ' target="_blank"';
						break;
				}
				$name = '';
				if ($row['md_type'] == 0){	// リンク項目のとき
					$name = $row['md_name'];
				} else if ($row['md_type'] == 1){			// フォルダのとき
				} else if ($row['md_type'] == 2){			// テキストのとき
				} else if ($row['md_type'] == 3){			// セパレータのとき
				}
				// 項目が空のときは追加しない
				if (empty($name)) continue;
				
				$itemRow = array(
					'link_url' => $this->convertUrlToHtmlEntity($linkUrl),		// リンク
					'name' => $this->convertToDispString($name),			// タイトル
					'attr' => $attr,			// liタグ追加属性
					'option' => $option			// Aタグ追加属性
				);
				$this->tmpl->addVars('itemlist', $itemRow);
				$this->tmpl->parseTemplate('itemlist', 'a');
		
				$index++;		// インデックス番号更新
				$this->isExistsMenuItem = true;		// メニュー項目が存在するかどうか
			}
		}
	}
}
?>
