<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: ec_cart_boxWidgetContainer.php 1816 2009-04-29 10:03:27Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath()		. '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath()	. '/ec_cart_boxDb.php');

class ec_cart_boxWidgetContainer extends BaseWidgetContainer
{
	private $db;			// DB接続オブジェクト
	private $langId;		// 現在の言語
	private $ecObj;					// EC共通ライブラリオブジェクト
	const PRICE_OBJ_ID = "eclib";		// 価格計算オブジェクトID
	const TARGET_WIDGET = 'ec_main';		// 呼び出しウィジェットID
	const DEFAULT_TITLE = 'カート';			// デフォルトのウィジェットタイトル名
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new ec_cart_boxDb();
		
		// 価格計算用オブジェクト取得
		$this->ecObj = $this->gInstance->getObject(self::PRICE_OBJ_ID);
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'main.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$this->langId	= $this->gEnv->getCurrentLanguage();		// 表示言語を取得
		
		// クッキー読み込み、カートIDを取得
		$cartId = $request->getCookieValue(M3_COOKIE_CART_ID);
		if (!empty($cartId)){	// カートIDが設定されているとき
			// カートの商品を取得
			$this->db->getCartItem($cartId, $this->langId, array($this, 'cartLoop'));
		}
		
		// カートリンク先
		$url = $this->createCmdUrlToWidget(self::TARGET_WIDGET, 'task=cart');
		$this->tmpl->addVar("_widget", "cart_detail_url", $url);
	}
	/**
	 * ウィジェットのタイトルを設定
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						ウィジェットのタイトル名
	 */
	function _setTitle($request, &$param)
	{
		return self::DEFAULT_TITLE;
	}
	/**
	 * 取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function cartLoop($index, $fetchedRow, $param)
	{
		// 商品を取得
		$ret = $this->db->getProductByProductId($fetchedRow['si_product_id'], $this->langId, $row, $row2, $row3, $row4);
		if ($ret){
			$name = $this->convertToDispString($row['pt_name']);		// 名前
		}
		// 通貨情報を取得
		$ret = $this->db->getCurrency($fetchedRow['si_currency_id'], $this->langId, $row);
		if ($ret){
			$prePrice = $this->convertToDispString($row['cu_symbol']);
			$postPrice = $this->convertToDispString($row['cu_post_symbol']);
		}
		
		// 価格作成
		$this->ecObj->setCurrencyType($fetchedRow['si_currency_id'], $this->langId);		// 通貨設定
		$this->ecObj->getPriceWithoutTax($fetchedRow['si_subtotal'], $dispPrice);					// 税込み価格取得
					
		// 価格の有効判断
		$available = '';
		if (!$fetchedRow['si_available']) $available = '(無効)';
		
		// 商品詳細へのリンク
		$url = $this->createCmdUrlToWidget(self::TARGET_WIDGET, 'product=' . $fetchedRow['si_product_id']);
			
		$nameLink = '<a href="' . $url . '">' . $name . '</a>';
		$itemStr = '<div>' . $nameLink . '</div><div>数量' . $fetchedRow['si_quantity'] . '&nbsp;' . $prePrice . $dispPrice . $postPrice . $available . '</div>';
		$row = array(
			'cart_item' => $itemStr
		);
		$this->tmpl->addVars('itemlist', $row);
		$this->tmpl->parseTemplate('itemlist', 'a');
		return true;
	}
}
?>
