<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2008 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_ec_mainMembercsvWidgetContainer.php 948 2008-08-28 12:26:33Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() . '/admin_ec_mainBaseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/ec_mainMemberDb.php');

class admin_ec_mainMembercsvWidgetContainer extends admin_ec_mainBaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	private $csvData;			// CSVデータ
	const DEFAULT_COUNTRY_ID = 'JPN';	// デフォルト国ID
	const CSV_FILE_HEAD = 'member_';		// CSVファイル名
		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new ec_mainMemberDb();
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$act = $request->trimValueOf('act');
		if ($act == 'download'){		// CSVダウンロード
			return '';
		} else {
			return 'admin_member_csv.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		global $gSystemManager;

		// ユーザ情報、表示言語
		$now = date("Y/m/d H:i:s");	// 現在日時
		$userId		= $gEnvManager->getCurrentUserId();
		$langId	= $gEnvManager->getCurrentLanguage();		// 表示言語を取得
		$countryId = self::DEFAULT_COUNTRY_ID;			// デフォルト国ID
				
		$act = $request->trimValueOf('act');
				
		if ($act == 'upload'){		// CSVアップロード
			if (is_uploaded_file($_FILES['upfile']['tmp_name'])) {
				$uploadFilename = $_FILES['upfile']['name'];		// アップロードされたファイルのファイル名取得
				
				// ファイルを保存するサーバディレクトリを指定
				$tmpFile = tempnam($gEnvManager->getWorkDirPath(), M3_SYSTEM_WORK_UPLOAD_FILENAME_HEAD);
	
				// アップされたテンポラリファイルを保存ディレクトリにコピー
				$ret = move_uploaded_file($_FILES['upfile']['tmp_name'], $tmpFile);
				if ($ret){
					$addCount = 0;		// 追加会員数
					$updateCount = 0;	// 更新会員数
					$colCount = 0;		// カラム数
					
					// トランザクションスタート
					$this->db->startTransaction();
					
					// ファイルオープン
					$fp = fopen($tmpFile, "r");
					
					// データ読み込み
					$delimType = 0;
					if ($gEnvManager->getDefaultCsvDelimCode() == "\t") $delimType = 1;		// タブ区切り
					while (($data = fgetByCsv($fp, $delimType)) !== false){
						if ($colCount == 0) $colCount = count($data);		// カラム数

						// ヘッダ読み飛ばし
						if (trim($data[0]) == '会員No') continue;
						if ($colCount != count($data)) continue;		// カラム数が合わない行も読み飛ばす

						// データをDBに格納する
						$memberNo			= trim($data[0]);			// 会員No
						$email				= trim($data[1]);			// eメール(ログインアカウント)
						$mobile				= '';			// 携帯電話
						$gender				= 0;			// 性別
						$birthday			= '';
						if (!empty($birthday)) $birthday = $this->convertToProperDate($birthday);			// 生年月日
						$familyName			= trim($data[2]);		// 会員名(姓)
						$firstName			= trim($data[3]);		// 会員名(名)
						$familyNameKana		= trim($data[4]);		// 会員名カナ(姓)
						$firstNameKana		= trim($data[5]);		// 会員名カナ(名)
						$zipcode			= trim($data[6]);				// 郵便番号
						$state				= $this->db->getStateIdByName('JPN', $langId, trim($data[7]));					// 都道府県
						$address			= trim($data[8]);			// 住所
						$address2			= trim($data[9]);			// 住所2
						$phone				= trim($data[10]);			// 電話番号
						$fax				= '';						// FAX
						$password			= trim($data[11]);			// パスワード

						// 会員Noを見て、新規登録か更新かを判断
						$updateRecord = false;
						if ($this->db->isExistsMemberNo($memberNo)) $updateRecord = true;
						
						// メールアドレスをチェック
						if (!isMailAddress($email)){
							$msg = 'このEメールアドレスはメールアドレス形式ではありません(' . $email . ')';
							$this->setAppErrorMsg($msg);
						}
						
						// 新規登録のときのエラーチェック
						if (!$updateRecord){
							if ($this->sysDb->isExistsAccount($email)){// メールアドレスがログインIDとして既に登録されているかチェック
								$msg = 'このEメールアドレスは既に登録されています(' . $email . ')';
								$this->setAppErrorMsg($msg);
							}
						}

						// エラーなしの場合は、データを登録
						if ($this->getMsgCount() == 0){
							if ($updateRecord){			// 会員情報更新の場合
								$changeEmail = false;		// ログインアカウントが変更かどうか
								// 登録済み会員情報を取得
								$ret = $this->db->getMemberByMemberNo($memberNo, $row);
								if ($ret){
									$serialNo = $row['sm_serial'];
									$personId = $row['sm_person_info_id'];
									$loginUserId = $row['sm_login_user_id'];
									$ret = $this->db->getPersonInfo($personId, $row);
									if ($ret){
										$addressId = $row['pi_address_id'];
										
										if ($email != $row['pi_email']) $changeEmail = true;	// メールアドレス(ログインアカウント)の変更
									}
									// メールアドレス変更のときのエラーチェック
									if ($changeEmail){
										if ($this->sysDb->isExistsAccount($email)){// メールアドレスがログインIDとして既に登録されているかチェック
											$msg = 'このEメールアドレスは既に登録されています(' . $email . ')';
											$this->setAppErrorMsg($msg);
										}
									}
									// 会員情報更新処理
									if ($this->getMsgCount() == 0){
										// 住所登録
										if ($ret) $ret = $this->db->updateAddress($addressId, $langId, '', $zipcode, $state, $address, $address2, $phone, $fax, $countryId, $userId, $now, $addressId);

										// 個人情報登録
										if (empty($birthday)) $birthday = $gEnvManager->getInitValueOfTimestamp();
										if ($ret) $ret = $this->db->updatePersonInfo($personId, $langId, $firstName, $familyName, 
														$firstNameKana, $familyNameKana, $gender, $birthday, $email, $mobile, $addressId, $userId, $now, $personalInfoId);

										// 会員情報更新
										if ($ret){
											$this->db->updateMember($serialNo, $langId, 1/* 個人 */, 0/* 法人情報ID */, $personalInfoId, $memberNo, $loginUserId, $userId, $now, $newSerial);
											$updateCount++;	// 更新会員数
										}

										// パスワードが設定されているときは更新
										if (!empty($password)){
											// パスワード変更
											if ($ret) $ret = $this->sysDb->updateLoginUserPassword($loginUserId, $password);
										}
										// メールアドレスの変更
										if ($changeEmail){
											if ($ret) $this->sysDb->updateLoginUserAccount($loginUserId, $email);
										}
									}
								} else {		// 該当の会員が存在しないとき
									$msg = 'この会員Noの会員が見つかりません(' . $memberNo . ')';
									$this->setAppErrorMsg($msg);
								}
							} else {
								// パスワードが空のときは自動生成
								if (empty($password)) $password = $this->makePassword();
				
								// ログインユーザを作成
								$ret = $this->db->addUser(1/* 正会員 */, $familyName . $firstName, $email, $password,
														$gEnvManager->getCurrentWidgetId(), $userId, $now, $loginUserId);		// 新規ログインユーザIDを取得

								// 住所登録
								if ($ret) $ret = $this->db->updateAddress(0, $langId, '', $zipcode, $state, $address, $address2, $phone, $fax, $countryId, $userId, $now, $addressId);

								// 個人情報登録
								if (empty($birthday)) $birthday = $gEnvManager->getInitValueOfTimestamp();
								if ($ret) $ret = $this->db->updatePersonInfo(0, $langId, $firstName, $familyName, $firstNameKana, $familyNameKana, 
																				$gender, $birthday, $email, $mobile, $addressId, $userId, $now, $personalInfoId);

								// 会員情報を登録
								if ($ret){
									$ret = $this->db->updateMember(0, $langId, 1/* 個人 */, 0/* 法人情報ID */, $personalInfoId, $memberNo, $loginUserId, $userId, $now, $newSerial);
									$addCount++;
								}
							}
						}
					}
					// ファイルを閉じる
					fclose($fp);
					
					// トランザクション終了
					$ret = $this->db->endTransaction();
					if ($ret && $this->getMsgCount() == 0){
						$this->setGuidanceMsg('データを' . $addCount . '件追加しました');
						$this->setGuidanceMsg('データを' . $updateCount . '件更新しました');
					} else {
						$this->setAppErrorMsg('データ追加に失敗しました');
					}
				}
				// テンポラリファイル削除
				unlink($tmpFile);
			} else {
				$msg = 'アップロードファイルが見つかりません(要因：アップロード可能なファイルのMaxサイズを超えている可能性があります - ' . $gSystemManager->getMaxFileSizeForUpload() . 'バイト)';
				$this->setAppErrorMsg($msg);
			}
		} else if ($act == 'download'){		// CSVダウンロード
			// ダウンロード時のデフォルトファイル名
			$down_file = self::CSV_FILE_HEAD . date("YmdHi") . $gEnvManager->getDefaultCsvFileSuffix();
			
			// ヘッダ部を作成
			$buf = array();
			$buf[] = '会員No';
			$buf[] = 'Eメール';
			$buf[] = '顧客名(姓)';
			$buf[] = '顧客名(名)';
			$buf[] = '会員名カナ(姓)';
			$buf[] = '会員名カナ(名)';
			$buf[] = '郵便番号';
			$buf[] = '都道府県';
			$buf[] = '住所1';
			$buf[] = '住所2';
			$buf[] = '電話番号';
			$buf[] = 'パスワード';
			$delim = $gEnvManager->getDefaultCsvDelimCode();		// CSV区切りコードを取得
			$this->csvData[] = implode($delim, $buf) . $gEnvManager->getDefaultCsvNLCode();
		
			// 会員リストを取得
			$this->db->getMemberList(0, -1/*すべて取得*/, 0, array($this, 'memberCsvListLoop'));
			
			// CSVの出力
			ob_end_clean();
			header ("Content-Type: application/force-download");
			header ("Content-Disposition: attachment; filename=" . $down_file);
			header ("Content-Description: File Transfer");
			header ("Content-Length: " . strlen(join("", $this->csvData)));
			foreach ($this->csvData as $mval) {
			    echo mb_convert_encoding($mval, 'SJIS-win');
			    flush();
			    ob_flush();
			    usleep(10000);
			}
			ob_end_flush();
			exit();		// スクリプト終了
		} else {	// 初期表示

		}
	}
	/**
	 * 取得したデータをCSV形式で出力する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function memberCsvListLoop($index, $fetchedRow, $param)
	{
		global $gEnvManager;
		
		$buf = array();
		
		// 配列を文字列に変換
		$delim = $gEnvManager->getDefaultCsvDelimCode();		// CSV区切りコードを取得
		if ($delim == "\t"){// タブ区切りのCSVフォーマットのとき
			$buf[] = $fetchedRow['sm_member_no'];		// 会員No
			$buf[] = $fetchedRow['pi_email'];		// eメール(ログインアカウント)
			$buf[] = $fetchedRow['pi_family_name'];		// 顧客名(姓)
			$buf[] = $fetchedRow['pi_first_name'];		// 顧客名(名)
			$buf[] = $fetchedRow['pi_family_name_kana'];		// 会員名カナ(姓)
			$buf[] = $fetchedRow['pi_first_name_kana'];		// 会員名カナ(名)
			$buf[] = $fetchedRow['ad_zipcode'];		// 郵便番号
			$buf[] = $fetchedRow['gz_name'];		// 都道府県
			$buf[] = $fetchedRow['ad_address1'];		// 住所
			$buf[] = $fetchedRow['ad_address2'];		// 住所2
			$buf[] = $fetchedRow['ad_phone'];		// 電話番号
			$buf[] = '';		// パスワード(ダミー)
		} else if ($delim == ","){// カンマ区切りのCSVフォーマットのとき
			$buf[] = $this->convertToEscapedCsv($fetchedRow['sm_member_no']);		// 会員No
			$buf[] = $this->convertToEscapedCsv($fetchedRow['pi_email']);		// eメール(ログインアカウント)
			$buf[] = $this->convertToEscapedCsv($fetchedRow['pi_family_name']);		// 顧客名(姓)
			$buf[] = $this->convertToEscapedCsv($fetchedRow['pi_first_name']);		// 顧客名(名)
			$buf[] = $this->convertToEscapedCsv($fetchedRow['pi_family_name_kana']);		// 会員名カナ(姓)
			$buf[] = $this->convertToEscapedCsv($fetchedRow['pi_first_name_kana']);		// 会員名カナ(名)
			$buf[] = $this->convertToEscapedCsv($fetchedRow['ad_zipcode']);		// 郵便番号
			$buf[] = $this->convertToEscapedCsv($fetchedRow['gz_name']);		// 都道府県
			$buf[] = $this->convertToEscapedCsv($fetchedRow['ad_address1']);		// 住所
			$buf[] = $this->convertToEscapedCsv($fetchedRow['ad_address2']);		// 住所2
			$buf[] = $this->convertToEscapedCsv($fetchedRow['ad_phone']);		// 電話番号
			$buf[] = $this->convertToEscapedCsv('');		// パスワード(ダミー)
		}
		$this->csvData[] = implode($delim, $buf) . $gEnvManager->getDefaultCsvNLCode();
		return true;
	}
}
?>
