<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_mainTopWidgetContainer.php 2363 2009-09-26 14:45:44Z fishbone $
 * @link       http://www.magic3.org
 */
//require_once($gEnvManager->getContainerPath() . '/baseAdminWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetContainerPath() .	'/admin_mainBaseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');

class admin_mainTopWidgetContainer extends admin_mainBaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $outputHtml;			// HTML出力
	const DEFAULT_NAV_ID = 'admin_menu';		// メニューID
	const TOPPAGE_MENU_CLASS = 'toppage-menu';	// メニューCSSクラス名
	const TOPPAGE_IMAGE_PATH = 'toppage_image_path';				// トップページ画像
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new admin_mainDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'top.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		// トップレベル項目を取得
		$menuInner = '';
		$menuInner .= '<tr valign="top"><td>';
		if ($this->db->getNavItems(self::DEFAULT_NAV_ID, 0, $rows)){
			$topMenuCount = count($rows);
			for ($i = 0; $i < $topMenuCount; $i++){
				if ($rows[$i]['ni_view_control'] == 0){		// 改行以外のとき
					$topId = $rows[$i]['ni_id'];
				
					// サブレベル取得
					$this->db->getNavItems(self::DEFAULT_NAV_ID, $topId, $subRows);
					// 初期表示画面
					if (count($subRows) > 0) $firstTask = $this->gEnv->getDefaultAdminUrl() . '?task=' . $subRows[0]['ni_task_id'];
				
					// 「li」タグ
					$menuInner .= '<li class="' . self::TOPPAGE_MENU_CLASS . '">'. M3_NL;
				
					// 「a」タグ
					// リンク先を作成。「_」で始まるタスクはリンクを作成しない
					$topLink = '#';
					$linkTask = $rows[$i]['ni_task_id'];
					if (strncmp($linkTask, '_', strlen('_')) != 0) $topLink = $this->gEnv->getDefaultAdminUrl() . '?task=' . $linkTask;	// 起動タスクパラメータを設定
				
					// ヘルプの作成
					$helpText = '';
					$title = $rows[$i]['ni_help_title'];
					if (!empty($title)){
						$helpText = $this->gInstance->getHelpManager()->createHelpText($title, $rows[$i]['ni_help_body']);
					}
				
					$menuInner .= str_repeat(' ', 4);
					$menuInner .= '<a href="' . $topLink . '">' . '<span ' . $helpText . '>' . $this->convertToDispString($rows[$i]['ni_name']) . '</span></a>' . M3_NL;

					// 「ul」タグ
					$menuInner .= str_repeat(' ', 4);
					$menuInner .= '<ul>' . M3_NL;
				
					// 「li」タグ
					if (count($subRows) > 0){
						for ($l = 0; $l < count($subRows); $l++){
							// ヘルプの作成
							$helpText = '';
							$title = $subRows[$l]['ni_help_title'];
							if (!empty($title)){
								$helpText = $this->gInstance->getHelpManager()->createHelpText($title, $subRows[$l]['ni_help_body']);
							}
				
							$menuInner .= str_repeat(' ', 8);
							$menuInner .= '<li ';
							$menuInner .= '><a href="';
							$menuInner .= $this->gEnv->getDefaultAdminUrl() . '?task=' . $subRows[$l]['ni_task_id'];	// 起動タスクパラメータを設定
							if (!empty($subRows[$l]['ni_param'])){		// パラメータが存在するときはパラメータを追加
								$menuInner .= '&' . M3_REQUEST_PARAM_OPERATION_TODO . '=' . urlencode($subRows[$l]['ni_param']);
							}
							$menuInner .= '" ><span ' . $helpText . '>' . $this->convertToDispString($subRows[$l]['ni_name']) . '</span></a></li>' . M3_NL;
						}
					}
					$menuInner .= str_repeat(' ', 4);
					$menuInner .= '</ul>' . M3_NL;
					$menuInner .= '</li>' . M3_NL;
				} else {		// 改行のとき
					$menuInner .= '</td><td>';
				}
			}
		}
		$menuInner .= '</td></tr>';
		$this->tmpl->addVar("_widget", "items", $menuInner);
		
		// トップページ用画像
		$toppageImg = $this->db->getSystemConfig(self::TOPPAGE_IMAGE_PATH);
		if (!empty($toppageImg)){
			$toppageImg	= $this->gEnv->getRootUrl() . $toppageImg;
			$this->tmpl->addVar("showimage", "toppage_img", $this->getUrl($toppageImg));
			$this->tmpl->setAttribute('showimage', 'visibility', 'visible');
		}
		
		// 管理用URL設定
		$this->tmpl->addVar("_widget", "admin_url", $this->gEnv->getDefaultAdminUrl());
	}
}
?>
