-- *
-- * データ登録スクリプト「ブログサイト標準初期化」
-- *
-- * PHP versions 5
-- *
-- * LICENSE: This source file is licensed under the terms of the GNU General Public License.
-- *
-- * @package    Magic3 Framework
-- * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
-- * @copyright  Copyright 2006-2009 Magic3 Project.
-- * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
-- * @version    SVN: $Id: blog_init.sql 2710 2009-12-18 09:02:00Z fishbone $
-- * @link       http://www.magic3.org
-- *
-- [ブログサイト標準初期化]
-- 管理画面は、ブログ管理中心型。
-- 初期インストールデータは必要最小限のみ

-- システム設定
UPDATE _system_config SET sc_value = '/images/system/toppage4.jpg' WHERE sc_id = 'toppage_image_path';
UPDATE _system_config SET sc_value = 'pwc007_music' WHERE sc_id = 'default_template';

-- 変換文字列
DELETE FROM _key_value;
INSERT INTO _key_value
(kv_id,               kv_name,       kv_value, kv_group_id) VALUES
('CUSTOM_KEY_001',      '会社名',      '', 'user'),
('CUSTOM_KEY_002',      '所在地',      '', 'user'),
('CUSTOM_KEY_003',      '設立',      '', 'user'),
('CUSTOM_KEY_004',      '代表者',      '', 'user'),
('CUSTOM_KEY_005',      '事業内容',      '', 'user'),
('CUSTOM_KEY_006',      '主要取引銀行',      '', 'user'),
('CUSTOM_KEY_007',      '主要取引先',      '', 'user'),
('CUSTOM_KEY_008',      'ショップ名',      '', 'user'),
('CUSTOM_KEY_009',      'ショップオーナー名',      '', 'user'),
('CUSTOM_KEY_010',      'ショップ住所',      '', 'user'),
('CUSTOM_KEY_011',      'ショップ電話番号',      '', 'user'),
('CUSTOM_KEY_012',      'ショップメールアドレス',      '', 'user');

-- 管理画面ページデータ(デフォルトを変更)
UPDATE _page_id SET pg_default_sub_id = 'blog' WHERE pg_id = 'index' AND pg_type = 0;

-- 管理画面メニューデータ
DELETE FROM _nav_item;
INSERT INTO _nav_item
(ni_id, ni_parent_id, ni_index, ni_nav_id,    ni_task_id,                     ni_group_id, ni_view_control, ni_param, ni_name,    ni_help_title, ni_help_body, ni_visible) VALUES
(100,   0,            0,        'admin_menu', '_page',                        '',          0,               '',       '画面管理', '画面管理', 'Webサイトのデザインや機能を管理します。', true),
(101,   100,          0,        'admin_menu', 'pagedef',                      '',          0,               '',           'PC用画面編集', 'PC用画面編集', 'PC用Webサイトの画面を作成します。', true),
(102,   100,          1,        'admin_menu', 'pagedef_mobile',               '',          0,               '',           '携帯用画面編集', '携帯用画面編集', '携帯用Webサイトの画面を作成します。', true),
(103,   100,          2,        'admin_menu', 'widgetlist',                   '',          0,               '',       'ウィジェット管理', 'ウィジェット管理', 'ウィジェットの管理を行います。', true),
(104,   100,          3,        'admin_menu', 'templist',                     '',          0,               '',       'テンプレート管理', 'テンプレート管理', 'テンプレートの管理を行います。', true),
(105,   100,          4,        'admin_menu', 'smenudef',                      '',          0,               '',       'メニュー管理', 'メニュー管理', 'メニュー定義を管理します。', true),
(200,   0,            1,        'admin_menu', '_login',                       '',          0,               '',       'システム運用', '', '', true),
(201,   200,          0,        'admin_menu', 'userlist',                     '',          0,               '',       'ユーザ一覧',   'ユーザ一覧', 'ログイン可能なユーザを管理します。', true),
(202,   200,          1,        'admin_menu', 'loginstatus',                  '',          0,               '',       'ログイン状況', 'ログイン状況', 'ユーザのログイン状況を表示します。', true),
(203,   200,          2,        'admin_menu', 'opelog',                       '',          0,               '',       '運用ログ参照', '運用ログ参照', 'システムの運用状況を表示します。', true),
(204,   200,          3,        'admin_menu', 'accesslog',                    '',          0,               '',       'アクセスログ参照', 'アクセスログ参照', 'サイトへのアクセス状況を表示します。', true),
(300,   0,            2,        'admin_menu', '_config',                      '',          0,               '',       'システム管理', '', '', true),
(301,   300,          0,        'admin_menu', 'configsite',                   '',          0,               '',       '基本情報', '基本情報', 'サイト運営に必要な情報を設定します。', true),
(302,   300,          1,        'admin_menu', 'configsys',                    '',          0,               '',       'システム情報', 'システム情報', 'システム全体の設定、運用状況を管理します。', true),
(303,   300,          2,        'admin_menu', 'resbrowse',                    '',          0,               '',       'リソースブラウズ', 'リソースブラウズ', 'リソースファイルを管理します。', true),
(304,   300,          3,        'admin_menu', 'master',                       '',          0,               '',       'システムマスター管理', 'システムマスター管理', 'システムに関するマスターテーブルの管理を行います。', true),
(305,   300,          4,        'admin_menu', 'initsystem',                   '',          0,               '',       'DBメンテナンス', 'DBメンテナンス', 'データの初期化などDBのメンテナンスを行います。', true),
(306,   300,          5,        'admin_menu', 'editmenu',                     '',          0,               '',       '管理メニュー編集', '管理メニュー編集', '管理機能のメインメニューを編集します。', true),
(399,   0,            3,        'admin_menu', '_399',                         '',          1,               '',       '改行', '', '', true),
(500,   0,            4,        'admin_menu', '_widget',                      '',          0,               '',       'ウィジェット設定', 'ウィジェット設定', '個別のウィジェットの設定を行います。', true),
(501,   500,          0,        'admin_menu', 'configwidget_default_content', '',          0,               '',       'コンテンツビュー', 'デフォルトコンテンツビュー', 'Webサイトのコンテンツを管理する設定画面です。', true),
(502,   500,          1,        'admin_menu', 'configwidget_blog_main',       '',          0,               '',       'ブログメイン', 'ブログメイン', 'ブログ機能のメインの管理画面です。', true),
(503,   500,          2,        'admin_menu', 'configwidget_banner2',        '',          0,               '',       'バナー', 'バナー', 'バナー2のメインの管理画面です。', true),
(1100,  0,            11,       'admin_menu', '_others',                      '',          0,               '',       'その他', '', '', true),
(1101,  1100,         0,        'admin_menu', 'logout',                       '',          0,               '',       'ログアウト', 'ログアウト', '管理機能からログアウトします。', true);

-- 画面定義
DELETE FROM _page_def WHERE pd_id = 'index';
INSERT INTO _page_def
(pd_id,   pd_sub_id, pd_position_id, pd_index, pd_widget_id,         pd_config_id, pd_config_name,       pd_menu_id,  pd_title_visible, pd_update_dt) VALUES
('index', '',        'header',       1,        'custom_header',      0,            '',                   '',          false,            now()),
('index', '',        'footer',       1,        'default_footer',     0,            '',                   '',          false,            now()),
('index', '',        'left',         2,        'default_menu',       1,            'メインメニュー設定', 'main_menu', true,             now()),
('index', '',        'left',         4,        'templateChanger',    0,            '',                   '',          true,             now()),
('index', '',        'right',        5,        'blog_category_menu', 0,            '',                   '',          true,             now()),
('index', '',        'right',        7,        'blog_archive_menu',  0,            '',                   '',          true,             now()),
('index', '',        'right',        9,        'default_login_box',  0,            '',                   '',          true,             now()),
('index', '',        'main',         3,        'banner2',            3,            '',                   '',          false,            now()),
('index', 'content', 'main',         6,        'default_content',    0,            '',                   '',          false,            now()),
('index', 'blog',    'main',         5,        'blog_main',          0,            '',                   '',          false,            now()),
('index', 'blog',    'left',         7,        'blog_new_box',       0,            '',                   '',          true,             now()),
('index', 'blog',    'left',         9,        'blog_calendar_box',  0,            '',                   '',          true,             now()),
('index', 'blog',    'left',         11,       'blog_search_box',    0,            '',                   '',          true,             now()),
('index', 'contact', 'main',         5,        'contactus',          0,            '',                   '',          false,            now());

-- 新メニュー対応
TRUNCATE TABLE _menu_def;
INSERT INTO _menu_def
(md_id, md_index, md_menu_id,  md_name,        md_link_url,                                         md_update_dt) VALUES
(1,     1,        'main_menu', 'ホーム',       '[#M3_ROOT_URL#]/',                                   now()),
(2,     2,        'main_menu', '会社情報',     '[#M3_ROOT_URL#]/index.php?contentid=1', now()),
(3,     3,        'main_menu', 'お問い合わせ', '[#M3_ROOT_URL#]/index.php?sub=contact',             now());

-- ウィジェットパラメータ
DELETE FROM _widget_param WHERE wp_id = 'default_menu';
INSERT INTO _widget_param
(wp_id,          wp_config_id, wp_param,                                                                                                wp_create_dt) VALUES 
('default_menu', 1,            'O:\8:"stdClass":3:{s:6:"menuId";s:9:"main_menu";s:4:"name";s:27:"メインメニュー設定";s:9:"limitUser";i:0;}', now());

-- ブログ
TRUNCATE TABLE blog_entry;
TRUNCATE TABLE blog_category;
TRUNCATE TABLE blog_entry_with_category;

-- バナー定義
TRUNCATE TABLE bn_def;
TRUNCATE TABLE bn_item;

-- コンテンツ
TRUNCATE TABLE content;
INSERT INTO content (cn_type, cn_id, cn_language_id, cn_name,              cn_description,         cn_html,                        cn_default, cn_key, cn_create_user_id, cn_create_dt) VALUES 
('', 1,     'ja',           '会社情報',   '会社情報', '<div class="ec_common">\r\n<table>\r\n    <tbody>\r\n        <tr>\r\n            <th>社　名</th>\r\n            <td>\r\n            <p>&nbsp;</p>\r\n            <p>[#CUSTOM_KEY_001#]</p>\r\n            <p>&nbsp;</p>\r\n            </td>\r\n        </tr>\r\n        <tr>\r\n            <th>所在地</th>\r\n            <td>\r\n            <p>&nbsp;</p>\r\n            <p>[#CUSTOM_KEY_002#]</p>\r\n            <p>&nbsp;</p>\r\n            </td>\r\n        </tr>\r\n        <tr>\r\n            <th>設　立</th>\r\n            <td>\r\n            <p>&nbsp;</p>\r\n            <p>[#CUSTOM_KEY_003#]</p>\r\n            <p>&nbsp;</p>\r\n            </td>\r\n        </tr>\r\n        <tr>\r\n            <th>代表者</th>\r\n            <td>\r\n            <p>&nbsp;</p>\r\n            <p>[#CUSTOM_KEY_004#]</p>\r\n            <p>&nbsp;</p>\r\n            </td>\r\n        </tr>\r\n        <tr>\r\n            <th>事業内容</th>\r\n            <td>\r\n            <p>&nbsp;</p>\r\n            <p>[#CUSTOM_KEY_005#]●商品Ａの製造<br />\r\n            ●商品Ｂの卸売<br />\r\n            ●商品Ｃの販売</p>\r\n            <p>&nbsp;</p>\r\n            </td>\r\n        </tr>\r\n        <tr>\r\n            <th>主要取引銀行</th>\r\n            <td>\r\n            <p>&nbsp;</p>\r\n            <p>[#CUSTOM_KEY_006#]</p>\r\n            <p>&nbsp;</p>\r\n            </td>\r\n        </tr>\r\n        <tr>\r\n            <th>主要取引先</th>\r\n            <td>\r\n            <p>&nbsp;</p>\r\n            <p>[#CUSTOM_KEY_007#]■ＸＸＸ株式会社<br />\r\n            ■ＹＹＹ株式会社<br />\r\n            ■株式会社　ＺＺＺ</p>\r\n            <p>&nbsp;</p>\r\n            <p>&nbsp;</p>\r\n            </td>\r\n        </tr>\r\n    </tbody>\r\n</table>\r\n</div>\r\n',              false, '',                0, now());
