<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2010 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_mainFilebrowseWidgetContainer.php 2780 2010-01-15 05:36:30Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() . '/admin_mainBrowseBaseWidgetContainer.php');

class admin_mainFilebrowseWidgetContainer extends admin_mainBrowseBaseWidgetContainer
{
	private $canDeleteFile;		// ファイル削除可能かどうか
	private $serialArray = array();		// 表示されているファイルのインデックス番号
	const FILE_ICON_FILE = '/images/system/tree/file.png';			// ファイルアイコン
	const FOLDER_ICON_FILE = '/images/system/tree/folder.png';		// ディレクトリアイコン
	const PARENT_ICON_FILE = '/images/system/tree/parent.png';		// 親ディレクトリアイコン
	const ICON_SIZE = 16;		// アイコンのサイズ
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'filebrowse.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$path = trim($request->valueOf('path'));		// 現在のパス
		if (empty($path)) $path = $this->gEnv->getResourcePath();// デフォルトはリソースディレクトリ

		$act = $request->trimValueOf('act');
		if ($act == 'uploadfile'){		// ファイルアップロードのとき
			// 出力バッファを切り替え
			ob_end_clean();

			// ファイルのアップロード処理
			if (isset($_FILES["Filedata"]) && is_uploaded_file($_FILES['Filedata']['tmp_name'])){		// アップロードファイルがある場合
				$uploadFilename = $_FILES['Filedata']['name'];		// アップロードされたファイルのファイル名取得
				$filePath = $path . DIRECTORY_SEPARATOR . $uploadFilename;
	
				// アップされたファイルをコピー
				$ret = move_uploaded_file($_FILES['Filedata']['tmp_name'], $filePath);
				if (!$ret){
					header("HTTP/1.1 595 File Upload Error");		// エラーコードはブラウザ画面に表示される
				}
			} else {			// アップロードファイルがないとき
				header("HTTP/1.1 596 File Upload Error");			// エラーコードはブラウザ画面に表示される
				if (isset($_FILES["Filedata"])) echo $_FILES["Filedata"]["error"];
			}
			
			// バッファ内容を出力
			ob_end_flush();
			exit(0);		// スクリプト終了
		} else if ($act == 'delete'){			// ファイル削除のとき
			$listedItem = explode(',', $request->trimValueOf('seriallist'));
			$delItems = array();
			for ($i = 0; $i < count($listedItem); $i++){
				// 項目がチェックされているかを取得
				$itemName = 'item' . $i . '_selected';
				$itemValue = ($request->trimValueOf($itemName) == 'on') ? 1 : 0;
				
				if ($itemValue){		// チェック項目
					// 削除可能かチェック
					$filename = $request->trimValueOf('item' . $i . '_name');
					$filePath = $path . DIRECTORY_SEPARATOR . $filename;
					if (is_writable($filePath) &&
						strStartsWith($filePath, $this->gEnv->getSystemRootPath() . DIRECTORY_SEPARATOR . M3_DIR_NAME_RESOURCE . DIRECTORY_SEPARATOR)){
						$delItems[] = $filePath;		// 削除するファイルのパス
					} else {
						$this->setMsg(self::MSG_USER_ERR, '削除できないファイルが含まれています。ファイル名=' . $this->convertToDispString($filename));
						break;
					}
				}
			}
			if ($this->getMsgCount() == 0 && count($delItems) > 0){
				$ret = true;
				for ($i = 0; $i < count($delItems); $i++){
					if (!unlink($delItems[$i])) $ret = false;
				}
				if ($ret){		// ファイル削除成功のとき
					$this->setGuidanceMsg('ファイルを削除しました');
				} else {
					$this->setAppErrorMsg('ファイル削除に失敗しました');
				}
			}
		}
		
		// カレントディレクトリのパスを作成
		if ($path == $this->gEnv->getSystemRootPath()){
			$pathLink = $this->gEnv->getSystemRootPath();
		} else {
			$pathLink = '<a href="#" onclick="selDir(\'' . $this->adaptWindowsPath($this->convertToDispString($this->gEnv->getSystemRootPath())) . '\');return false;">' . $this->convertToDispString($this->gEnv->getSystemRootPath()) . '</a>';
		}

		$relativePath = str_replace($this->gEnv->getSystemRootPath(), '', $path);
		$relativePath = trim($relativePath, DIRECTORY_SEPARATOR);
		if (!empty($relativePath)){
			$absPath = $this->gEnv->getSystemRootPath();
			$pathArray = explode(DIRECTORY_SEPARATOR, $relativePath);
			for ($i = 0; $i < count($pathArray); $i++){
				if ($i == count($pathArray) -1){
					$pathLink .= '&nbsp;' . DIRECTORY_SEPARATOR . '&nbsp;' . $this->convertToDispString($pathArray[$i]);
				} else {
					$absPath .= DIRECTORY_SEPARATOR . $pathArray[$i];
					$pathLink .= '&nbsp;' . DIRECTORY_SEPARATOR . '&nbsp;';
					$pathLink .= '<a href="#" onclick="selDir(\'' . $this->adaptWindowsPath($this->convertToDispString($absPath)) . '\');return false;">' . $this->convertToDispString($pathArray[$i]) . '</a>';
				}
			}
		}
		// ファイル削除可能かどうか(resourceディレクトリ以下のみ削除可能)
		$this->canDeleteFile = false;
		if ($relativePath == M3_DIR_NAME_RESOURCE || strStartsWith($relativePath, M3_DIR_NAME_RESOURCE . DIRECTORY_SEPARATOR)){
			$this->canDeleteFile = true;
		} else {
			// 削除ボタンを使用可能にする
			$this->tmpl->addVar("_widget", "del_disabled", 'disabled ');
		}
		
		// ファイル一覧を作成
		$this->createFileList($path);
		
		$this->tmpl->addVar('_widget', 'path', $path);// 現在のディレクトリ
		$this->tmpl->addVar('_widget', 'path_link', $pathLink);// 現在のディレクトリ
		$this->tmpl->addVar("_widget", "serial_list", implode($this->serialArray, ','));// 表示項目のシリアル番号を設定
		
		// アップロード実行用URL
		$this->tmpl->addVar("_widget", "upload_url", $this->getUrl($this->gEnv->getDefaultAdminUrl()));
		$this->tmpl->addVar("_widget", "param_cmd", M3_REQUEST_CMD_DO_WIDGET);		// ウィジェットを単体実行
		$this->tmpl->addVar("_widget", "param_widget", $this->gEnv->getCurrentWidgetId());
		$this->tmpl->addVar("_widget", "param_task", 'filebrowse');
		$this->tmpl->addVar("_widget", "param_act", 'uploadfile');
		$this->tmpl->addVar("_widget", "param_path", $this->adaptWindowsPath($path));// アップロードディレクトリ
		$this->tmpl->addVar("_widget", "param_key", $this->gEnv->getAdminKey());// 管理者キー
	}
	/**
	 * ファイル一覧を作成
	 *
	 * @param string $path	ディレクトリパス
	 * @return なし
	 */
	function createFileList($path)
	{
		if (is_dir($path)){
			// 親ディレクトリを追加
			if ($path != $this->gEnv->getSystemRootPath()){
				$file = '..';
				$fileLink = '<a href="#" onclick="selDir(\'' . $this->adaptWindowsPath($this->convertToDispString(dirname($path))) . '\');return false;">' . $this->convertToDispString($file) . '</a>';
				
				// アイコン作成
				$iconTitle = $file;
				$iconUrl = $this->gEnv->getRootUrl() . self::PARENT_ICON_FILE;
				$iconTag = '<a href="#" onclick="selDir(\'' . $this->adaptWindowsPath($this->convertToDispString(dirname($path))) . '\');return false;">';
				$iconTag .= '<img src="' . $this->getUrl($iconUrl) . '" width="' . self::ICON_SIZE . '" height="' . self::ICON_SIZE . '" border="0" alt="' . $iconTitle . '" title="' . $iconTitle . '" />';
				$iconTag .= '</a>';
				
				$checkDisabled = 'disabled ';
				$row = array(
					'icon'		=> $iconTag,		// アイコン
					'name'		=> $this->convertToDispString($file),			// ファイル名
					'filename'    => $fileLink,			// ファイル名
					'size'     => $size,			// ファイルサイズ
					'check_disabled' => $checkDisabled,		// チェックボックス使用制御
					'selected' => $selected														// 選択中かどうか
				);
				$this->tmpl->addVars('file_list', $row);
				$this->tmpl->parseTemplate('file_list', 'a');
			}
			
			$index = 0;			// インデックス番号
			$dir = dir($path);
			while (($file = $dir->read()) !== false){
				$filePath = $path . DIRECTORY_SEPARATOR . $file;
				// カレントディレクトリかどうかチェック
				if ($file != '.' && $file != '..'){
					$size = '';
					$fileLink = '';
					$checkDisabled = '';		// チェックボックス使用制御
					if (is_dir($filePath)){			// ディレクトリのとき
						// アイコン作成
						$iconUrl = $this->gEnv->getRootUrl() . self::FOLDER_ICON_FILE;
						$iconTitle = $this->convertToDispString($file);
						$iconTag = '<a href="#" onclick="selDir(\'' . $this->adaptWindowsPath($this->convertToDispString($filePath)) . '\');return false;">';
						$iconTag .= '<img src="' . $this->getUrl($iconUrl) . '" width="' . self::ICON_SIZE . '" height="' . self::ICON_SIZE . '" border="0" alt="' . $iconTitle . '" title="' . $iconTitle . '" />';
						$iconTag .= '</a>';
					
						$fileLink = '<a href="#" onclick="selDir(\'' . $this->adaptWindowsPath($this->convertToDispString($filePath)) . '\');return false;">' . $this->convertToDispString($file) . '</a>';
						$checkDisabled = 'disabled ';		// チェックボックス使用制御
					} else {
						// アイコン作成
						$iconUrl = $this->gEnv->getRootUrl() . self::FILE_ICON_FILE;
						$iconTitle = $this->convertToDispString($file);
						$iconTag = '<img src="' . $this->getUrl($iconUrl) . '" width="' . self::ICON_SIZE . '" height="' . self::ICON_SIZE . '" border="0" alt="' . $iconTitle . '" title="' . $iconTitle . '" />';
						
						$fileLink = $this->convertToDispString($file);
						$size = filesize($filePath);
						
						// ファイル削除用チェックボックス
						if (!$this->canDeleteFile || !is_writable($filePath)) $checkDisabled = 'disabled ';		// チェックボックス使用制御
					}
		
					// ファイルパーミッションの取得
					$perms = fileperms($filePath);
					$permStr = '';
					
					// 所有者
					$permStr .= (($perms & 0x0100) ? 'r' : '-');
					$permStr .= (($perms & 0x0080) ? 'w' : '-');
					$permStr .= (($perms & 0x0040) ? (($perms & 0x0800) ? 's' : 'x' ) : (($perms & 0x0800) ? 'S' : '-'));

					// グループ
					$permStr .= (($perms & 0x0020) ? 'r' : '-');
					$permStr .= (($perms & 0x0010) ? 'w' : '-');
					$permStr .= (($perms & 0x0008) ? (($perms & 0x0400) ? 's' : 'x' ) : (($perms & 0x0400) ? 'S' : '-'));

					// 全体
					$permStr .= (($perms & 0x0004) ? 'r' : '-');
					$permStr .= (($perms & 0x0002) ? 'w' : '-');
					$permStr .= (($perms & 0x0001) ? (($perms & 0x0200) ? 't' : 'x' ) : (($perms & 0x0200) ? 'T' : '-'));
			
					// ファイル更新日時
					$updateDate = date('Y/m/d H:i:s', filemtime($filePath));
					
					// ファイル所有者
					$owner = '';
					if (function_exists('posix_getpwuid')){
						$ownerArray = posix_getpwuid(fileowner($filePath));
						$owner = $ownerArray['name'];
					}
					$group = '';
					if (function_exists('posix_getgrgid')){
						$groupArray = posix_getgrgid(filegroup($filePath));
						$group = $groupArray['name'];
					}
					
					$row = array(
						'index'		=> $index,			// インデックス番号
						'icon'		=> $iconTag,		// アイコン
						'name'		=> $this->convertToDispString($file),			// ファイル名
						'filename'    	=> $fileLink,			// ファイル名
						'size'     		=> $size,			// ファイルサイズ
						'permission'    => $permStr,			// ファイルパーミッション
						'date'    => $updateDate,			// 更新日時
						'owner'    => $this->convertToDispString($owner),			// ファイル所有者
						'group'    => $this->convertToDispString($group),			// ファイル所有グループ
						'check_disabled' => $checkDisabled,		// チェックボックス使用制御
					);
					$this->tmpl->addVars('file_list', $row);
					$this->tmpl->parseTemplate('file_list', 'a');
					
					// インデックス番号を保存
					$this->serialArray[] = $index;
					$index++;
				}
			}
			$dir->close();
		}
		//sort($fileList);		// ファイル名をソート
	}
	/**
	 * CSSファイルをHTMLヘッダ部に設定
	 *
	 * CSSファイルをHTMLのheadタグ内に追加出力する。
	 * _assign()よりも後に実行される。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。
	 * @return string 						CSS文字列。出力しない場合は空文字列を設定。
	 */
	function _addCssFileToHead($request, &$param)
	{
		return $this->getUrl($this->gEnv->getScriptsUrl() . '/swfupload2/css/default.css');
	}
	/**
	 * windowパスを使用する場合は、Javascriptに認識させる
	 *
	 * @param string         $src			パス文字列
	 * @return string 						作成文字列
	 */
	function adaptWindowsPath($src)
	{
		// 「\」を有効にする
		if (DIRECTORY_SEPARATOR == '\\'){		// windowsパスのとき
			return addslashes($src);
		} else {
			return $src;
		}
	}
}
?>
