<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_bbs_mainOtherWidgetContainer.php 2 2007-11-03 04:59:01Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() .			'/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/bbs_mainDb.php');

class admin_bbs_mainOtherWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	const USE_EMAIL			= 'use_email';		// EMAIL機能が使用可能かどうか
	const SEND_PASSWORD_ON_REGIST	= 'send_password_on_regist';		// 会員登録時にパスワードを自動送信するかどうか
	const CAN_EDIT_THREAD	= 'can_edit_thread';		// 投稿記事の編集を可能にするかどうか
	const ADMIN_NAME	= 'admin_name';			// 管理者名
	const AUTO_EMAIL_SENDER	= 'auto_email_sender';		// 自動送信メール用送信者アドレス
					
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->db = new bbs_mainDb();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'admin_other.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		
		$defaultLang	= $gEnvManager->getDefaultLanguage();
		
		$act = $request->trimValueOf('act');
		$useEmail = ($request->trimValueOf('use_email') == 'on') ? 1 : 0;		// EMAIL機能が使用可能かどうか
		$sendPassword = ($request->trimValueOf('send_password_on_regist') == 'on') ? 1 : 0;		// EMAIL機能が使用可能かどうか
		$autoEmailSender = $request->trimValueOf('auto_email_sender');		// 自動送信メールの送信元
		$canEditThread = ($request->trimValueOf('can_edit_thread') == 'on') ? 1 : 0;		// 投稿記事の編集を許可するかどうか
		$adminName = $request->trimValueOf('admin_name');		// 管理者の表示名
		
		if ($act == 'update'){		// 設定更新のとき
			// 入力値のエラーチェック
			if ($this->getMsgCount() == 0){			// エラーのないとき
				$isErr = false;												
				if (!$isErr){
					if (!$this->db->updateConfig(self::USE_EMAIL, $useEmail)) $isErr = true;
				}
				if (!$isErr){
					if (!$this->db->updateConfig(self::SEND_PASSWORD_ON_REGIST, $sendPassword)) $isErr = true;
				}
				if (!$isErr){
					if (!$this->db->updateConfig(self::AUTO_EMAIL_SENDER, $autoEmailSender)) $isErr = true;
				}
				if (!$isErr){
					if (!$this->db->updateConfig(self::CAN_EDIT_THREAD, $canEditThread)) $isErr = true;
				}
				if (!$isErr){
					if (!$this->db->updateConfig(self::ADMIN_NAME, $adminName)) $isErr = true;
				}
				if ($isErr){
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				} else {
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				}
			
				// 値を再取得
				$useEmail	= $this->db->getConfig(self::USE_EMAIL);
				$sendPassword = $this->db->getConfig(self::SEND_PASSWORD_ON_REGIST);
				$autoEmailSender = $this->db->getConfig(self::AUTO_EMAIL_SENDER);
				$canEditThread = $this->db->getConfig(self::CAN_EDIT_THREAD);
				$adminName = $this->db->getConfig(self::ADMIN_NAME);
			}
		} else {		// 初期表示の場合
			$useEmail	= $this->db->getConfig(self::USE_EMAIL);
			$sendPassword = $this->db->getConfig(self::SEND_PASSWORD_ON_REGIST);
			$autoEmailSender = $this->db->getConfig(self::AUTO_EMAIL_SENDER);
			$canEditThread	= $this->db->getConfig(self::CAN_EDIT_THREAD);
			$adminName = $this->db->getConfig(self::ADMIN_NAME);
		}
		// 画面に書き戻す
		$checked = '';
		if ($useEmail) $checked = 'checked';
		$this->tmpl->addVar("_widget", "use_email", $checked);
		$checked = '';
		if ($sendPassword) $checked = 'checked';
		$this->tmpl->addVar("_widget", "send_password_on_regist", $checked);
		$this->tmpl->addVar("_widget", "auto_email_sender", $autoEmailSender);		// 自動送信メールの送信者
		$checked = '';
		if ($canEditThread) $checked = 'checked';
		$this->tmpl->addVar("_widget", "can_edit_thread", $checked);
		$this->tmpl->addVar("_widget", "admin_name", $adminName);		// 管理者の表示名
	}
}
?>
