<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: bbs_mainThreadWidgetContainer.php 2363 2009-09-26 14:45:44Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/bbs_mainThreadDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/bbs_accessDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/bbs_mainDb.php');
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/bbs_mainMemberDb.php');

class bbs_mainThreadWidgetContainer extends BaseWidgetContainer
{
	private $db;			// DB接続オブジェクト
	private $mainDb;			// DB接続オブジェクト
	private $memberDb;			// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	private $accessDb;		// 
	private $currentDay;		// 現在日
	private $currentHour;		// 現在時間
	private $adminName;			// 管理者名
	private $currentPageUrl;			// 現在のページURL
	private $categoryAccessInfo;		// カテゴリーのアクセス情報
	private $categoryId;		// 現在のカテゴリー
	private $canWriteCategory;	// 現在のカテゴリーの書き込み権限があるかどうか
	const DEFAULT_LIST_COUNT = 10;			// 最大リスト表示数
	const DEFAULT_THREAD_LIST_COUNT = 20;	// スレッド一覧の表示項目数
	const DEFAULT_SEARCH_LIST_COUNT = 5;			// 最大リスト表示数
	const THIS_WIDGET_ID = 'bbs_main';			// ウィジェットID
	const ADMIN_NAME	= 'admin_name';			// 管理者名
	const ANONYMOUS_NAME = '匿名';		// 匿名ユーザ名
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DBオブジェクト作成
		$this->mainDb = new bbs_mainDb();
		$this->db = new bbs_mainThreadDb();
		$this->memberDb = new bbs_mainMemberDb();
		$this->accessDb = new bbs_accessDb();
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * ウィジェット単位のアクセス制御
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 */
	function _checkAccess($request)
	{
		return true;
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		$act = $request->trimValueOf('act');
		if ($act == 'list'){
			return 'list.tmpl.html';
		} else if ($act == 'view'){
			return 'thread.tmpl.html';
		} else if ($act == 'reply' || $act == 'replythread'){		// スレッド返信表示
			return 'reply.tmpl.html';
		} else if ($act == 'new' || $act == 'newthread'){		// スレッド新規表示
			return 'newthread.tmpl.html';
		} else if ($act == 'search'){
			return 'search.tmpl.html';
		} else {
			return 'category.tmpl.html';
		}
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;

		// 現在日時を取得
		$this->currentDay = date("Y/m/d");		// 日
		$this->currentHour = (int)date("H");		// 時間
		$now = date("Y/m/d H:i:s");	// 現在日時
		
		// 管理者名取得
		$this->adminName = $this->mainDb->getConfig(self::ADMIN_NAME);
		
		// ユーザ情報、表示言語
		$userId		= $gEnvManager->getCurrentUserId();
		$this->langId	= $gEnvManager->getCurrentLanguage();		// 表示言語を取得
		
		// 現在のページURL
		$this->currentPageUrl = $gEnvManager->createCurrentPageUrl();
		
		$entryId = $request->trimValueOf('entryid');
		$startDt = $request->trimValueOf('start');
		$endDt = $request->trimValueOf('end');
		$pageNo = $request->trimValueOf('page');				// ページ番号
		if (empty($pageNo)) $pageNo = 1;
		
		// DBの保存設定値を取得
		$maxListCount = self::DEFAULT_LIST_COUNT;				// 表示項目数
		$serializedParam = $this->sysDb->getWidgetParam(self::THIS_WIDGET_ID);
		if (!empty($serializedParam)){
			$dispInfo = unserialize($serializedParam);
			$maxListCount = $dispInfo->viewCount;		// 一覧表示数
		}
		$maxThreadListCount = self::DEFAULT_THREAD_LIST_COUNT;		// スレッド一覧項目数
		
		// カテゴリーのアクセス情報を取得
		if ($gEnvManager->isSystemAdmin()){			// 管理権限ありのユーザの場合
			$ret = $this->accessDb->getAllCategoryInfo($this->langId, $this->categoryAccessInfo);
		} else {
			$ret = $this->accessDb->getCategoryAccessInfo($userId, $this->langId, $this->categoryAccessInfo);		// カテゴリーのアクセス情報
		}
		$act = $request->trimValueOf('act');
		$keyword = $request->trimValueOf('keyword');
		if ($act == 'list'){		// スレッド一覧表示
			// カテゴリーを取得
			// 取得できないときは、先頭のカテゴリを取得
			$this->categoryId = $request->trimValueOf('category');
			if (empty($this->categoryId) && count($this->categoryAccessInfo) > 0) $this->categoryId = $this->categoryAccessInfo[0]['sr_id'];

			// アクセス権を取得
			$this->getCategoryAccess($this->categoryId, $readAccess, $writeAccess);
			if ($readAccess || $writeAccess){		// 表示可能なとき
				// カテゴリー名を取得
				if ($this->db->getCategoryByCategoryId($this->categoryId, $this->langId, $row)) $categoryName = $row['sr_name'];
			
				// 総数を取得
				$totalCount = $this->db->getThreadCount($this->categoryId, $this->langId);

				// 表示するページ番号の修正
				$pageCount = (int)(($totalCount -1) / $maxThreadListCount) + 1;		// 総ページ数
				if ($pageNo < 1) $pageNo = 1;
				if ($pageNo > $pageCount) $pageNo = $pageCount;
				$this->firstNo = ($pageNo -1) * $maxThreadListCount + 1;		// 先頭番号

				// スレッドリストを表示
				$this->db->getThreadList($maxThreadListCount, $pageNo, $this->categoryId, $this->langId, array($this, 'threadListLoop'));
		
				// ページング用リンク作成
				$pageLink = '';
				if ($pageCount > 1){	// ページが2ページ以上のときリンクを作成
					for ($i = 1; $i <= $pageCount; $i++){
						if ($i == $pageNo){
							$link = '&nbsp;' . $i;
						} else {
							$link = '&nbsp;<a href="#" onclick="selpage(\'' . $i . '\');return false;">' . $i . '</a>';
						}
						$pageLink .= $link;
					}
				}
				$this->tmpl->addVar("_widget", "page_link", $pageLink);
				$this->tmpl->addVar("_widget", "page", $pageNo);		// ページ番号
				$this->tmpl->addVar("_widget", "category_id", $this->categoryId);
				$this->tmpl->addVar("_widget", "category_name", $categoryName);
				if (!$writeAccess){			// 書き込み不可の場合は新規投稿できない
					$this->tmpl->addVar("_widget", "disabled_new", 'disabled');
				}
			} else {
				$this->setUserErrorMsg('カテゴリーにアクセスできません');
			}
		} else if ($act == 'view'){		// スレッド表示
			// パラメータを取得
			$threadId = $request->trimValueOf('threadid');
			$this->categoryId = $request->trimValueOf('category');
			
			// カテゴリーへのアクセス権をチェック
			$this->getCategoryAccess($this->categoryId, $readAccess, $writeAccess);			
			if ($readAccess || $writeAccess){		// 表示可能なとき
				// 現在のカテゴリーの書き込み権限			
				$this->canWriteCategory = $writeAccess;

				// 総数を取得
				$totalCount = $this->db->getThreadDetailCount($threadId, $this->langId);

				// 表示するページ番号の修正
				$pageCount = (int)(($totalCount -1) / $maxListCount) + 1;		// 総ページ数
				if ($pageNo < 1) $pageNo = 1;
				if ($pageNo > $pageCount) $pageNo = $pageCount;
				$this->firstNo = ($pageNo -1) * $maxListCount + 1;		// 先頭番号
			
				// スレッドリストを表示
				$this->db->getThreadDetailList($maxListCount, $pageNo, $threadId, $this->langId, array($this, 'threadDetailListLoop'));
		
				// ページング用リンク作成
				$pageLink = '';
				if ($pageCount > 1){	// ページが2ページ以上のときリンクを作成
					for ($i = 1; $i <= $pageCount; $i++){
						if ($i == $pageNo){
							$link = '&nbsp;' . $i;
						} else {
							$link = '&nbsp;<a href="#" onclick="selpage(\'' . $i . '\');return false;">' . $i . '</a>';
						}
						$pageLink .= $link;
					}
				}
				$this->tmpl->addVar("_widget", "page_link", $pageLink);
				$this->tmpl->addVar("_widget", "page", $pageNo);		// ページ番号
				
				// スレッド参照カウントを更新
				$this->db->updateViewCount($threadId, $this->langId, $this->currentDay, $this->currentHour);
				
				// カテゴリー名を取得
				$categoryName = '';
				if ($this->db->getCategoryByCategoryId($this->categoryId, $this->langId, $row)) $categoryName = $row['sr_name'];
				
				// スレッドタイトルを取得
				$threadName = '';
				if ($this->db->getThreadById($threadId, $this->langId, $row)) $threadName = $row['se_name'];

				// カテゴリーへのリンクを生成
				$categorylinkUrl = $this->currentPageUrl . '&task=thread&act=list&category=' . $this->categoryId;
				$categoryLink = '<a href="' . $categorylinkUrl . '" >' . $categoryName . '</a>';
			
				$this->tmpl->addVar("_widget", "category_name", $categoryName);
				$this->tmpl->addVar("_widget", "category_link", $categoryLink);
				$this->tmpl->addVar("_widget", "thread_name", $threadName);
				$this->tmpl->addVar("_widget", "category_id", $this->categoryId);
				$this->tmpl->addVar("_widget", "thread_id", $threadId);		// ルートスレッドID
			} else {
				$this->setUserErrorMsg('カテゴリーにアクセスできません');
			}
		} else if ($act == 'new' || $act == 'newthread'){		// スレッド新規投稿
			// カテゴリーを取得
			// 取得できないときは、先頭のカテゴリを取得
			$this->categoryId = $request->trimValueOf('category');
			if (empty($this->categoryId) && count($this->categoryAccessInfo) > 0) $this->categoryId = $this->categoryAccessInfo[0]['sr_id'];

			// アクセス権を取得
			$this->getCategoryAccess($this->categoryId, $readAccess, $writeAccess);
			if ($writeAccess){		// 投稿可能なとき
				// ##### 投稿部分 #####
				// パラメータ取得
				$logSerial = $gEnvManager->getCurrentAccessLogSerial();	// 現在のログ
		
				// 投稿者の情報
				$memberName = '';
				if ($this->memberDb->getMemberByUserId($userId, $memberRow)){
					$memberName = $memberRow['sv_name'];
				}
				if (empty($memberName) && $gEnvManager->isSystemAdmin()){			// 管理権限ありの場合
					$memberName = $this->adminName;		// BBS管理者名
				}
				
				if ($act == 'newthread'){		// 新規スレッド投稿のとき
					$name = $request->trimValueOf('item_name');		// タイトル
					$html = $request->trimValueOf('item_entry');		// 本文
					$this->checkInput($name, 'タイトル');
					$this->checkInput($html, '本文');
					
					if ($this->getMsgCount() == 0){		// 入力チェックOKのとき
						// 投稿処理
						$ret = $this->db->addNewThread(0, $this->langId, 0/*ルートスレッド*/, $name, $html, $this->categoryId, $logSerial, $userId, $now, $userId, $newSerial);
						if ($ret){
							$this->setGuidanceMsg('投稿完了しました');
							
							// 入力領域を使用不可にする
							$this->tmpl->addVar("_widget", "disabled_name", 'readonly');
							$this->tmpl->addVar("_widget", "disabled_entry", 'readonly');
							$this->tmpl->addVar("_widget", "disabled_post", 'disabled');		// 送信ボタン
						} else {
							$this->setAppErrorMsg('投稿に失敗しました');
						}
					}
					$this->tmpl->addVar("_widget", "new_title", $this->convertToDispString($name));		// 新規投稿タイトル
					$this->tmpl->addVar("_widget", "new_entry", $this->convertToDispString($html));		// 新規投稿本文
				}
				$this->tmpl->addVar("_widget", "member_name", $this->convertToDispString($memberName));// 投稿会員名
				
				// ##### 一覧部分 #####
				// カテゴリー名を取得
				if ($this->db->getCategoryByCategoryId($this->categoryId, $this->langId, $row)) $categoryName = $row['sr_name'];
			
				// 総数を取得
				$totalCount = $this->db->getThreadCount($this->categoryId, $this->langId);

				// 表示するページ番号の修正
				$pageCount = (int)(($totalCount -1) / $maxThreadListCount) + 1;		// 総ページ数
				if ($pageNo < 1) $pageNo = 1;
				if ($pageNo > $pageCount) $pageNo = $pageCount;
				$this->firstNo = ($pageNo -1) * $maxThreadListCount + 1;		// 先頭番号
		
				// スレッドリストを表示
				$this->db->getThreadList($maxThreadListCount, $pageNo, $this->categoryId, $this->langId, array($this, 'threadListLoop'));
		
				// ページング用リンク作成
				$pageLink = '';
				if ($pageCount > 1){	// ページが2ページ以上のときリンクを作成
					for ($i = 1; $i <= $pageCount; $i++){
						if ($i == $pageNo){
							$link = '&nbsp;' . $i;
						} else {
							$link = '&nbsp;<a href="#" onclick="selpage(\'' . $i . '\');return false;">' . $i . '</a>';
						}
						$pageLink .= $link;
					}
				}
				$this->tmpl->addVar("_widget", "page_link", $pageLink);
				$this->tmpl->addVar("_widget", "page", $pageNo);		// ページ番号
				$this->tmpl->addVar("_widget", "category_id", $this->categoryId);
				$this->tmpl->addVar("_widget", "category_name", $categoryName);
				
				// カテゴリーへのリンクを生成
				$categorylinkUrl = $this->currentPageUrl . '&task=thread&act=list&category=' . $this->categoryId;
				$categoryLink = '<a href="' . $categorylinkUrl . '" >' . $categoryName . '</a>';
				
				$this->tmpl->addVar("_widget", "category_name", $categoryName);
				$this->tmpl->addVar("_widget", "category_link", $categoryLink);
			} else {
				$this->setUserErrorMsg('カテゴリーにアクセスできません');
			}
		} else if ($act == 'reply' || $act == 'replythread'){		// スレッド返信表示
			// パラメータを取得
			$threadId = $request->trimValueOf('threadid');
			$this->categoryId = 0;
			if ($this->db->getThreadById($threadId, $this->langId, $row)){
				$this->categoryId = $row['se_category_id'];
			}
			
			// カテゴリーへのアクセス権をチェック
			$this->getCategoryAccess($this->categoryId, $readAccess, $writeAccess);			
			if ($writeAccess){		// 投稿可能なとき
				// パラメータ取得
				$logSerial = $gEnvManager->getCurrentAccessLogSerial();	// 現在のログ
		
				// 投稿者の情報
				$memberName = '';
				if ($this->memberDb->getMemberByUserId($userId, $memberRow)){
					$memberName = $memberRow['sv_name'];
				}
				if (empty($memberName) && $gEnvManager->isSystemAdmin()){			// 管理権限ありの場合
					$memberName = $this->adminName;		// BBS管理者名
				}
					
				// カテゴリー名を取得
				$categoryName = '';
				if ($this->db->getCategoryByCategoryId($this->categoryId, $this->langId, $row)) $categoryName = $row['sr_name'];

				// 投稿元のスレッドを取得
				$threadName = '';
				if ($this->db->getThreadById($threadId, $this->langId, $parentRow)){
					// ルートスレッドを取得
					if ($this->db->getThreadById($parentRow['se_root_id'], $this->langId, $rootRow)){
						// ルートスレッド名を取得
						$threadName = $rootRow['se_name'];
						$rootId = $rootRow['se_id'];
			
						// 投稿先スレッドの投稿者を取得
						$regName = '';
						if ($this->memberDb->getMemberByUserId($parentRow['se_regist_user_id'], $memberRow)){
							$regName = $memberRow['sv_name'];
						} else if ($parentRow['se_regist_user_id'] == 0){	// ユーザが設定されていないときは匿名ユーザ
							$regName = self::ANONYMOUS_NAME;
						}
						if (empty($regName) && $gEnvManager->isSystemAdminUser($parentRow['se_regist_user_id'])){			// 管理権限ありの場合
							$regName = $this->adminName;		// BBS管理者名
						}
						// 入力パラメータのエラーチェック
						if ($act == 'replythread'){
							$name = $request->trimValueOf('item_name');		// タイトル
							$html = $request->trimValueOf('item_entry');		// 本文
							$this->checkInput($name, 'タイトル');
							$this->checkInput($html, '本文');
							
							if ($this->getMsgCount() == 0){		// 入力チェックOKのとき
								// 投稿処理
								$category = $parentRow['se_category_id'];
								$ret = $this->db->addNewThread(0, $this->langId, $threadId, $name, $html, $category, $logSerial, $userId, $now, $userId, $newSerial);
								if ($ret){
									$this->setGuidanceMsg('投稿完了しました');
									
									// 入力領域を使用不可にする
									$this->tmpl->addVar("_widget", "disabled_name", 'readonly');
									$this->tmpl->addVar("_widget", "disabled_entry", 'readonly');
									$this->tmpl->addVar("_widget", "disabled_post", 'disabled');		// 送信ボタン
								} else {
									$this->setAppErrorMsg('投稿に失敗しました');
								}
							}
							$this->tmpl->addVar("_widget", "new_title", $this->convertToDispString($name));		// 新規投稿タイトル
							$this->tmpl->addVar("_widget", "new_entry", $this->convertToDispString($html));		// 新規投稿本文
						} else {
							// 新規のタイトルを作成
							$title = $parentRow['se_name'];
							if (strncmp($title, 'Re: ', 4) == 0){
								$newTitle = $title;
							} else {
								$newTitle = 'Re: ' . $title;
							}
							$this->tmpl->addVar("_widget", "new_title", $this->convertToDispString($newTitle));		// 新規投稿タイトルデフォルト値
						}
						$this->tmpl->addVar("_widget", "id", $this->convertToDispString($parentRow['se_id']));		// 投稿対象スレッド
						$this->tmpl->addVar("_widget", "title", $this->convertToDispString($parentRow['se_name']));
						$this->tmpl->addVar("_widget", "reg_name", $this->convertToDispString($regName));
						$this->tmpl->addVar("_widget", "date", $this->convertToDispDateTime($parentRow['se_regist_dt']));
						$this->tmpl->addVar("_widget", "entry", $this->convertToPreviewText($parentRow['se_html']));// 投稿記事
						$this->tmpl->addVar("_widget", "member_name", $this->convertToDispString($memberName));// 投稿会員名
					} else {
						$this->setAppErrorMsg('投稿先のルートスレッドが存在しません');
					}
				} else {
					$this->setUserErrorMsg('投稿先のスレッドが存在しません');
				}

				// カテゴリーへのリンクを生成
				$categorylinkUrl = $this->currentPageUrl . '&task=thread&act=list&category=' . $this->categoryId;
				$categoryLink = '<a href="' . $categorylinkUrl . '" >' . $categoryName . '</a>';
				// スレッドへのリンクを作成
				$threadLinkUrl = $this->currentPageUrl . '&task=thread&act=view&category=' . $this->categoryId . '&threadid=' . $rootId;
				//$threadLinkUrl = $this->currentPageUrl . '&task=thread&act=view&threadid=' . $threadId;
				$threadLink = '<a href="' . $threadLinkUrl . '" >' . $threadName . '</a>';
	
				$this->tmpl->addVar("_widget", "category_name", $categoryName);
				$this->tmpl->addVar("_widget", "category_link", $categoryLink);
				$this->tmpl->addVar("_widget", "thread_name", $threadName);
				$this->tmpl->addVar("_widget", "thread_link", $threadLink);
				$this->tmpl->addVar("_widget", "category_id", $this->categoryId);
			} else {
				$this->setUserErrorMsg('このカテゴリーに投稿できません');
			}
		} else if ($act == 'search'){
			$itemCount = self::DEFAULT_SEARCH_LIST_COUNT;		// 取得数
			
			// キーワード検索のとき
			if (empty($keyword)){
				$keyword = '検索キーワードが入力されていません';
			} else {
				$this->db->searchEntryItemsByKeyword($itemCount, 1, $keyword, $gEnvManager->getCurrentLanguage(), array($this, 'searchItemsLoop'));
			} 
		} else {		// 指定のない場合はアクセス可能カテゴリーを表示
			// すべてのカテゴリーを取得
			$ret = $this->accessDb->getAllCategoryInfo($this->langId, $rows);
			for ($i = 0; $i < count($rows); $i++){
				$categoryId = $rows[$i]['sr_id'];
				
				// アクセス権のチェック
				$this->getCategoryAccess($categoryId, $readAccess, $writeAccess);
				if ($readAccess || $writeAccess){	// 表示可能なとき
					$categoryName = $rows[$i]['sr_name'];
					$categorylinkUrl = $this->currentPageUrl . '&task=thread&act=list&category=' . $categoryId;
					$categoryLink = '<a href="' . $categorylinkUrl . '" >' . $categoryName . '</a>';
				
					$row = array(
						'title' => $categoryLink,		// カテゴリー名
						'date' => $date,			// 日付
						'entry' => $entryText	// 投稿記事
					);					
					$this->tmpl->addVars('entrylist', $row);
					$this->tmpl->parseTemplate('entrylist', 'a');
				}
			}
		}
		// リンク生成
		$topLinkUrl = $this->currentPageUrl . '&task=thread';
		$topLink = '<a href="' . $topLinkUrl . '" >カテゴリ一覧</a>';
		$this->tmpl->addVar("_widget", "top_link", $topLink);
		
		$this->tmpl->addVar("_widget", "keyword", $keyword);
	}
	/**
	 * 取得したコンテンツ項目をテンプレートに設定する
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function itemsLoop($index, $fetchedRow)
	{
		global $gEnvManager;
			
		// タイトルを設定
		$title = $fetchedRow['be_name'];
		
		// 日付
		$date = $fetchedRow['be_regist_dt'];

		// HTMLを出力
		// 出力内容は特にエラーチェックしない
		$entryText = $fetchedRow['be_html'];
		$entryText = str_replace(M3_TAG_START . M3_TAG_MACRO_ROOT_URL . M3_TAG_END, $gEnvManager->getRootUrl(), $entryText);// アプリケーションルートを変換
		$row = array(
			'title' => $title,
			'date' => $date,			// 日付
			'entry' => $entryText	// 投稿記事
		);
		$this->tmpl->addVars('entrylist', $row);
		$this->tmpl->parseTemplate('entrylist', 'a');
		return true;
	}
	/**
	 * 取得したスレッド一覧項目をテンプレートに設定する
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function threadListLoop($index, $fetchedRow)
	{
		global $gEnvManager;

		// パラメータ取得
		$id = $fetchedRow['se_id'];
		$title = $fetchedRow['se_name'];
		
		// 記事へのリンクを生成
		$linkUrl = $this->currentPageUrl . '&task=thread&act=view&category=' . $this->categoryId . '&threadid=' . $fetchedRow['se_id'];
		$link = '<a href="' . $linkUrl . '" >' . $title . '</a>';
		
		// 日付
		$date = $this->convertToDispDateTime($fetchedRow['se_regist_dt']);

		// 登録者名
		$regName = $this->convertToDispString($fetchedRow['sv_name']);
		if ($fetchedRow['se_regist_user_id'] == 0) $regName = self::ANONYMOUS_NAME;		// ユーザが設定されていないときは匿名ユーザ
		if (empty($regName)) $regName = $this->adminName;
		
		// 参照数を取得
		$viewCount = $this->db->getThreadViewCount($id, $this->langId);
		if (empty($viewCount)) $viewCount = 0;
		
		$row = array(
			'title' => $link,			// リンク付きタイトル
			'count' => $fetchedRow['se_max_sort_order'] + 1,		// 投稿数
			'view_count' => $viewCount,		// 参照数
			'reg_name' => $regName,		// 登録者名
			'date' => $date			// 日付
		);
		$this->tmpl->addVars('entrylist', $row);
		$this->tmpl->parseTemplate('entrylist', 'a');
		return true;
	}
	/**
	 * 取得したスレッド詳細項目をテンプレートに設定する
	 *
	 * @param int		$index			行番号
	 * @param array		$fetchedRow		取得行
	 * @param object	$param			任意使用パラメータ
	 * @return bool						trueを返すとループ続行。falseを返すとその時点で終了。
	 */
	function threadDetailListLoop($index, $fetchedRow)
	{
		global $gEnvManager;

		// タイトルを設定
		$title = $fetchedRow['se_name'];
		
		// 記事へのリンクを生成
		//$linkUrl = $this->currentPageUrl . '&task=thread&act=view&category=' . $this->categoryId . '&threadid=' . $fetchedRow['se_id'];
		$linkUrl = '#';
		$link = '<a href="' . $linkUrl . '" >' . $title . '</a>';
		
		// 日付
		$date = $this->convertToDispDateTime($fetchedRow['se_regist_dt']);

		// 登録者名
		$regName = $this->convertToDispString($fetchedRow['sv_name']);
		if ($fetchedRow['se_regist_user_id'] == 0) $regName = self::ANONYMOUS_NAME;		// ユーザが設定されていないときは匿名ユーザ
		if (empty($regName)) $regName = $this->adminName;
		
		// 投稿内容
		$content = $this->convertToPreviewText($fetchedRow['se_html']);		// 改行コードをbrタグに変換
		
		// 書き込み権限のチェック
		if (!$this->canWriteCategory) $disabled = 'disabled';
		
		$row = array(
			'id' => $fetchedRow['se_id'],		// スレッドID
			'title' => $link,			// リンク付きタイトル
			'count' => $fetchedRow['se_sort_order'],		// 投稿数
			'view_count' => $viewCount,		// 参照数
			'reg_name' => $regName,		// 登録者名
			'date' => $date,			// 日付
			'entry' => $content,	// 投稿記事
			'disabled' => $disabled					// 書き込み権限
		);
		$this->tmpl->addVars('entrylist', $row);
		$this->tmpl->parseTemplate('entrylist', 'a');
		return true;
	}
	/**
	 * カテゴリーへのアクセス権を取得チェック
	 *
	 * @param int		$categoryId			カテゴリーID
	 * @param bool		$readAccess			読み込みアクセス
	 * @param bool		$writeAccess		書き込みアクセス
	 * @return bool							true=正常、false=異常
	 */
	function getCategoryAccess($categoryId, &$readAccess, &$writeAccess)
	{
		global $gEnvManager;
		
		// アクセス権をチェック
		if ($gEnvManager->isSystemAdmin()){			// 管理権限ありのユーザの場合
			$readAccess = true;
			$writeAccess = true;
			return true;
		} else {
			$readAccess = false;
			$writeAccess = false;
			for ($i = 0; $i < count($this->categoryAccessInfo); $i++){
				if ($categoryId == $this->categoryAccessInfo[$i]['sr_id']){
					$readAccess = $this->categoryAccessInfo[$i]['so_read'];
					$writeAccess = $this->categoryAccessInfo[$i]['so_write'];
					return true;
				}
			}
		}
		return false;
	}
}
?>
