/**
 * jqPlot
 * Pure JavaScript plotting plugin using jQuery
 *
 * Version: 1.0.0b2_r947
 *
 * Copyright (c) 2009-2011 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot dot com or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * sprintf functions contained in jqplot.sprintf.js by Ash Searle:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 *
 * included jsDate library by Chris Leonello:
 *
 * Copyright (c) 2010-2011 Chris Leonello
 *
 * jsDate is currently available for use in all personal or commercial projects 
 * under both the MIT and GPL version 2.0 licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly.
 *
 * jsDate borrows many concepts and ideas from the Date Instance 
 * Methods by Ken Snyder along with some parts of Ken's actual code.
 * 
 * Ken's origianl Date Instance Methods and copyright notice:
 * 
 * Ken Snyder (ken d snyder at gmail dot com)
 * 2008-09-10
 * version 2.0.2 (http://kendsnyder.com/sandbox/date/)     
 * Creative Commons Attribution License 3.0 (http://creativecommons.org/licenses/by/3.0/)
 *
 * jqplotToImage function based on Larry Siden's export-jqplot-to-png.js.
 * Larry has generously given permission to adapt his code for inclusion
 * into jqPlot.
 *
 * Larry's original code can be found here:
 *
 * https://github.com/lsiden/export-jqplot-to-png
 * 
 * 
 */
(function(a){a.jqplot.DateAxisRenderer=function(){a.jqplot.LinearAxisRenderer.call(this);this.date=new a.jsDate()};a.jqplot.DateAxisRenderer.prototype=new a.jqplot.LinearAxisRenderer();a.jqplot.DateAxisRenderer.prototype.constructor=a.jqplot.DateAxisRenderer;a.jqplot.DateTickFormatter=function(b,c){if(!b){b="%Y/%m/%d"}return a.jsDate.strftime(c,b)};a.jqplot.DateAxisRenderer.prototype.init=function(w){this.tickOptions.formatter=a.jqplot.DateTickFormatter;this.tickInset=0;this.drawBaseline=true;this.baselineWidth=null;this.baselineColor=null;this.daTickInterval=null;this._daTickInterval=null;a.extend(true,this,w);var u=this._dataBounds,h,o,v,p,r,q,b;for(var g=0;g<this._series.length;g++){h={intervals:[],frequencies:{},sortedIntervals:[],min:null,max:null,mean:null};o=0;v=this._series[g];p=v.data;r=v._plotData;q=v._stackData;b=0;for(var f=0;f<p.length;f++){if(this.name=="xaxis"||this.name=="x2axis"){p[f][0]=new a.jsDate(p[f][0]).getTime();r[f][0]=new a.jsDate(p[f][0]).getTime();q[f][0]=new a.jsDate(p[f][0]).getTime();if((p[f][0]!=null&&p[f][0]<u.min)||u.min==null){u.min=p[f][0]}if((p[f][0]!=null&&p[f][0]>u.max)||u.max==null){u.max=p[f][0]}if(f>0){b=Math.abs(p[f][0]-p[f-1][0]);h.intervals.push(b);if(h.frequencies.hasOwnProperty(b)){h.frequencies[b]+=1}else{h.frequencies[b]=1}}o+=b}else{p[f][1]=new a.jsDate(p[f][1]).getTime();r[f][1]=new a.jsDate(p[f][1]).getTime();q[f][1]=new a.jsDate(p[f][1]).getTime();if((p[f][1]!=null&&p[f][1]<u.min)||u.min==null){u.min=p[f][1]}if((p[f][1]!=null&&p[f][1]>u.max)||u.max==null){u.max=p[f][1]}if(f>0){b=Math.abs(p[f][1]-p[f-1][1]);h.intervals.push(b);if(h.frequencies.hasOwnProperty(b)){h.frequencies[b]+=1}else{h.frequencies[b]=1}}}o+=b}if(v.renderer.bands){if(v.renderer.bands.hiData.length){var m=v.renderer.bands.hiData;for(var f=0,e=m.length;f<e;f++){if(this.name==="xaxis"||this.name==="x2axis"){m[f][0]=new a.jsDate(m[f][0]).getTime();if((m[f][0]!=null&&m[f][0]>u.max)||u.max==null){u.max=m[f][0]}}else{m[f][1]=new a.jsDate(m[f][1]).getTime();if((m[f][1]!=null&&m[f][1]>u.max)||u.max==null){u.max=m[f][1]}}}}if(v.renderer.bands.lowData.length){var m=v.renderer.bands.lowData;for(var f=0,e=m.length;f<e;f++){if(this.name==="xaxis"||this.name==="x2axis"){m[f][0]=new a.jsDate(m[f][0]).getTime();if((m[f][0]!=null&&m[f][0]<u.min)||u.min==null){u.min=m[f][0]}}else{m[f][1]=new a.jsDate(m[f][1]).getTime();if((m[f][1]!=null&&m[f][1]<u.min)||u.min==null){u.min=m[f][1]}}}}}var t=0,k=0;for(var c in h.frequencies){h.sortedIntervals.push({interval:c,frequency:h.frequencies[c]})}h.sortedIntervals.sort(function(i,d){return d.frequency-i.frequency});h.min=a.jqplot.arrayMin(h.intervals);h.max=a.jqplot.arrayMax(h.intervals);h.mean=o/p.length;this._intervalStats.push(h);h=o=v=p=r=q=null}u=null};a.jqplot.DateAxisRenderer.prototype.reset=function(){this.min=this._options.min;this.max=this._options.max;this.tickInterval=this._options.tickInterval;this.numberTicks=this._options.numberTicks;this._autoFormatString="";if(this._overrideFormatString&&this.tickOptions&&this.tickOptions.formatString){this.tickOptions.formatString=""}this.daTickInterval=this._daTickInterval};a.jqplot.DateAxisRenderer.prototype.createTicks=function(){var z=this._ticks;var w=this.ticks;var B=this.name;var y=this._dataBounds;var e=this._intervalStats;var q,x;var o,s;var d,c;var b,u;o=((this.min!=null)?new a.jsDate(this.min).getTime():y.min);s=((this.max!=null)?new a.jsDate(this.max).getTime():y.max);var k=s-o;if(w.length){for(u=0;u<w.length;u++){var g=w[u];var j=new this.tickRenderer(this.tickOptions);if(g.constructor==Array){j.value=new a.jsDate(g[0]).getTime();j.label=g[1];if(!this.showTicks){j.showLabel=false;j.showMark=false}else{if(!this.showTickMarks){j.showMark=false}}j.setTick(j.value,this.name);this._ticks.push(j)}else{j.value=new a.jsDate(g).getTime();if(!this.showTicks){j.showLabel=false;j.showMark=false}else{if(!this.showTickMarks){j.showMark=false}}j.setTick(j.value,this.name);this._ticks.push(j)}}this.numberTicks=w.length;this.min=this._ticks[0].value;this.max=this._ticks[this.numberTicks-1].value;this.daTickInterval=[(this.max-this.min)/(this.numberTicks-1)/1000,"seconds"]}else{if(this.tickInterval==null&&this.min==null&&this.max==null&&this.numberTicks==null){var A=a.jqplot.LinearTickGenerator(o,s);var n=o+k*(this.padMin-1);var r=s-k*(this.padMax-1);if(o<=n||s>=r){n=o-k*(this.padMin-1);r=s+k*(this.padMax-1);A=a.jqplot.LinearTickGenerator(n,r)}this.min=A[0];this.max=A[1];this.numberTicks=A[2];this.tickInterval=A[4];this.daTickInterval=[this.tickInterval/1000,"seconds"];for(var u=0;u<this.numberTicks;u++){var o=new a.jsDate(this.min);b=o.add(u*this.daTickInterval[0],this.daTickInterval[1]).getTime();var j=new this.tickRenderer(this.tickOptions);if(!this.showTicks){j.showLabel=false;j.showMark=false}else{if(!this.showTickMarks){j.showMark=false}}j.setTick(b,this.name);this._ticks.push(j)}}else{if(B=="xaxis"||B=="x2axis"){q=this._plotDimensions.width}else{q=this._plotDimensions.height}if(this.min!=null&&this.max!=null&&this.numberTicks!=null){this.tickInterval=null}if(this.tickInterval!=null){if(Number(this.tickInterval)){this.daTickInterval=[Number(this.tickInterval),"seconds"]}else{if(typeof this.tickInterval=="string"){var l=this.tickInterval.split(" ");if(l.length==1){this.daTickInterval=[1,l[0]]}else{if(l.length==2){this.daTickInterval=[l[0],l[1]]}}}}}if(o==s){var h=24*60*60*500;o-=h;s+=h}k=s-o;var v=2+parseInt(Math.max(0,q-100)/100,10);var m,p;m=(this.min!=null)?new a.jsDate(this.min).getTime():o-k/2*(this.padMin-1);p=(this.max!=null)?new a.jsDate(this.max).getTime():s+k/2*(this.padMax-1);this.min=m;this.max=p;k=this.max-this.min;if(this.numberTicks==null){if(this.daTickInterval!=null){var f=new a.jsDate(this.max).diff(this.min,this.daTickInterval[1],true);this.numberTicks=Math.ceil(f/this.daTickInterval[0])+1;this.max=new a.jsDate(this.min).add((this.numberTicks-1)*this.daTickInterval[0],this.daTickInterval[1]).getTime()}else{if(q>200){this.numberTicks=parseInt(3+(q-200)/100,10)}else{this.numberTicks=2}}}if(this.daTickInterval==null){this.daTickInterval=[k/(this.numberTicks-1)/1000,"seconds"]}for(var u=0;u<this.numberTicks;u++){var o=new a.jsDate(this.min);b=o.add(u*this.daTickInterval[0],this.daTickInterval[1]).getTime();var j=new this.tickRenderer(this.tickOptions);if(!this.showTicks){j.showLabel=false;j.showMark=false}else{if(!this.showTickMarks){j.showMark=false}}j.setTick(b,this.name);this._ticks.push(j)}}}if(this.tickInset){this.min=this.min-this.tickInset*this.tickInterval;this.max=this.max+this.tickInset*this.tickInterval}if(this._daTickInterval==null){this._daTickInterval=this.daTickInterval}z=null}})(jQuery);