<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2012 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_default_contentOtherWidgetContainer.php 4929 2012-05-29 10:47:25Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() . '/admin_default_contentBaseWidgetContainer.php');

class admin_default_contentOtherWidgetContainer extends admin_default_contentBaseWidgetContainer
{
	const DEFAULT_MESSAGE_DENY = 'コンテンツを表示できません';		// アクセス不可の場合のメッセージ
			
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'admin_other.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$defaultLang	= $this->gEnv->getDefaultLanguage();
		$act = $request->trimValueOf('act');
		
		$showTitle	= ($request->trimValueOf('item_show_title') == 'on') ? 1 : 0;			// コンテンツタイトルを表示するかどうか
		$showMessageDeny = $request->trimValueOf('item_show_message_deny');					// アクセス不可の場合にメッセージを表示するかどうか
		$messageDeny = $request->trimValueOf('item_message_deny');							// アクセス不可の場合のメッセージ
		$showEdit	= ($request->trimValueOf('item_show_edit') == 'on') ? 1 : 0;			// 編集ボタンを表示するかどうか
		$usePassword	= ($request->trimValueOf('item_use_password') == 'on') ? 1 : 0;		// パスワードを使用するかどうか
		$passwordContent = $request->valueOf('item_password_content');					// パスワード入力画面用コンテンツ
		
		if ($act == 'update'){		// 設定更新のとき
			// 入力値のエラーチェック
			
			if ($this->getMsgCount() == 0){			// エラーのないとき
				$paramObj->showTitle	= $showTitle;			// コンテンツタイトルを表示するかどうか
				$paramObj->showMessageDeny = $showMessageDeny;					// アクセス不可の場合にメッセージを表示するかどうか
				$paramObj->messageDeny = $messageDeny;							// アクセス不可の場合のメッセージ
				$paramObj->showEdit	= $showEdit;			// 編集ボタンを表示するかどうか
				$ret = $this->updateWidgetParamObj($paramObj);
				if ($ret) $ret = self::$_mainDb->updateConfig(default_contentCommonDef::CF_USE_PASSWORD, $usePassword);		// パスワードを使用するかどうか
				if ($ret) $ret = self::$_mainDb->updateConfig(default_contentCommonDef::CF_PASSWORD_CONTENT, $passwordContent);		// パスワード入力画面用コンテンツ
		
				if ($ret){
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}
				$this->gPage->updateParentWindow();// 親ウィンドウを更新
			}
		} else {		// 初期表示の場合
			// デフォルト値設定
			$showTitle = 0;			// コンテンツタイトルを表示するかどうか
			$showMessageDeny = 1;					// アクセス不可の場合にメッセージを表示するかどうか
			$messageDeny = self::DEFAULT_MESSAGE_DENY;							// アクセス不可の場合のメッセージ
			$showEdit = 1;			// 編集ボタンを表示するかどうか
			$usePassword = 0;		// パスワードを使用するかどうか
			$passwordContent = '';		// パスワード入力画面用コンテンツ
			
			$paramObj = $this->getWidgetParamObj();
			if (!empty($paramObj)){
				$showTitle = $paramObj->showTitle;			// コンテンツタイトルを表示するかどうか
				$showMessageDeny = $paramObj->showMessageDeny;					// アクセス不可の場合にメッセージを表示するかどうか
				$messageDeny = $paramObj->messageDeny;							// アクセス不可の場合のメッセージ
				$showEdit = $paramObj->showEdit;			// 編集ボタンを表示するかどうか
			}
			
			$usePassword = self::$_mainDb->getConfig(default_contentCommonDef::CF_USE_PASSWORD);		// パスワードを使用するかどうか
			$passwordContent = self::$_mainDb->getConfig(default_contentCommonDef::CF_PASSWORD_CONTENT);		// パスワード入力画面用コンテンツ
		}
		// 画面に書き戻す
		$checked = '';
		if (!empty($showTitle)) $checked = 'checked';
		$this->tmpl->addVar("_widget", "show_title", $checked);		// コンテンツタイトルを表示するかどうか
		$checked = '';
		if (!empty($showMessageDeny)) $checked = 'checked';
		$this->tmpl->addVar("_widget", "show_message_deny", $checked);		// アクセス不可の場合にメッセージを表示するかどうか
		$this->tmpl->addVar("_widget", "message_deny", $messageDeny);		// アクセス不可の場合のメッセージ
		$checked = '';
		if (!empty($showEdit)) $checked = 'checked';
		$this->tmpl->addVar("_widget", "show_edit", $checked);		// 編集ボタンを表示するかどうか
		$checked = '';
		if (!empty($usePassword)) $checked = 'checked';
		$this->tmpl->addVar("_widget", "use_password", $checked);		// パスワードを使用するかどうか
		$this->tmpl->addVar("_widget", "password_content", $passwordContent);		// パスワード入力画面用コンテンツ
	}
}
?>
