<?php

/**
 * ǡβ(clump)饹
 *
 * ºݤˤϡǡǤޤǰ
 * cgi󥿥եȤΤ
 * ƥݥơ֥ȤΤ
 * DBȤΤ
 * 礹롣
 *
 * @package magicweapon
 * @link http://www.grid-works-guild.net/MagicWeapon/ MagicWeapon
 * @access  public
 * @author  Michiaki Wuzawa <wuzawa@m-fr.net>
 * @create  $LastChangedDate$
 * @version $Revision$
 */

require_once('basis_clump.inc');
require_once('tokenizer.inc');
require_once('calendar_util.inc');
require_once('security.inc');
require_once('sql_util.inc');
require_once('session_data_db.inc');
require_once('conv_util.inc');

class data_clump extends basis_clump
{
//public:

//
public function __construct()
{
  parent::__construct();
  //$this->init();
}

// 
public function init()
{
  //
  parent::init();

  //
  $this->tblname_ = "";         // DBơ֥̾
  $this->dbh_ = null;           // DBϥɥ
  //
  $this->tmpname_ = "";         // ƥݥơ֥̾
  $this->tmp_key_ = "";         // ƥݥơ֥ѥ

  //
  $this->nokeyname_ = array();  // KeyǤϤʤ̾켰
  $this->keyname_ = array();    // KeyˤʤäƤ̾켰

  //
  $this->cgi_name_ = array();   // CGI̾
  $this->tmp_name_ = array();   // ƥݥơ֥̾
  $this->db_name_ = array();    // DB̾
}


/**
 * DBơ֥̾
 *
 * @access public
 * @param string $s ơ֥̾
 */
public function set_table_name($s) { $this->tblname_ = $s; }
/**
 * DBơ֥̾μ
 *
 * @access public
 * @return string ơ֥̾
 */
public function get_table_name() { return $this->tblname_; }


/**
 * ƥݥơ֥̾
 *
 * ǡŪ˳Ǽ뤿Τ
 *
 * @access public
 * @param string $s ơ֥̾
 */
public function set_session_table_name($s) { $this->tmpname_ = $s; }
/**
 * ƥݥơ֥̾μ
 *
 * @access public
 * @return string ơ֥̾
 */
public function get_session_table_name() { return $this->tmpname_; }



/**
 * DBϥɥ
 *
 * @access public
 * @param db_handle $o db_handle饹(饹)Υ󥹥
 */
public function set_db($o) { $this->dbh_ = $o; }
/**
 * DBϥɥ
 *
 * @access public
 * @return db_handle db_handle饹(饹)Υ󥹥
 */
public function get_db() { return $this->dbh_; }

// public̯ʤΤǤȥȤϽ񤫤ʤ
public function set_tmp_key($s) { $this->tmp_key_ = $s; }
public function get_tmp_key() { return $this->tmp_key_; }
// keyȡʥǺ
public function make_tmp_key() { $this->set_tmp_key(tokenizer::get()); }

// XXX ʲpublicprotectedäݤΤǥȤ񤫤ʤɤ

// dbǤ̾Υ
public function set_db_name($n, $v) { $this->db_name_[$n] = $v; }
public function get_db_name($n) { return $this->db_name_[$n]; }
// ƥݥơ֥Ǥ̾Υ
public function set_tmp_name($n, $v) { $this->tmp_name_[$n] = $v; }
public function get_tmp_name($n) { return $this->tmp_name_[$n]; }
// cgi form̾Υ
public function set_cgi_name($n, $v) { $this->cgi_name_[$n] = $v; }
public function get_cgi_name($n) { return $this->cgi_name_[$n]; }
// keynameϢ
public function push_keyname($n) { $this->keyname_[] = $n; }
public function get_all_key_names()   { return $this->keyname_; }

public function push_nokeyname($n) { $this->nokeyname_[] = $n; }
public function get_all_no_key_names() { return $this->nokeyname_; }


/**
 * ǡå
 *
 * ǡѹflgλؼˤäƤDBѹϢư
 * XXX 祭Фư̤
 *
 * @access public
 * @param string $name ̾
 * @param string $value ꤹ
 * @param boolean $flg ѹѥե饰trueDBιԤǥեȤtrue
 * @return boolean ꤬false
 */
public function set_value($name, $value, $flg = true)
{
//print "$name , $value ; \n";
  // ¸ߥå
  if( !($this->is_name($name)) ) {
    return false;
  }

  // ǡ
  $this->set_data($name, $value);

  // flg true ξDB⹹
  if ($flg) {
    $wk = $this->get_db_name($name) . "=" . security::sanitize_db_add_quote($value);
    //
    return $this->_mono_set_db($wk);
  }

  // flg  false ʤ顢DB򹹿˽λ
  return true;
}

/**
 * ǡå
 *
 * ǡ¸ߤʤʸ
 * ǡȤƤζʸʤΤ¸ߤʤΤפʾis_nameȤä
 *
 * @access public
 * @param string $name ̾
 * @return string ͡ǡʤжʸ
 */
public function get_value($name)
{
  // XXX ¸ߥåget_data᥽åɤ˰¸
  return $this->get_data($name);
}

/**
 * Ǥ
 *
 * data켰ꡣ
 * key_flgϡkey|pk|k|ok|true|on Τ줫keyǤȤߤʤ
 * XXX publicɡꤹΤ礤Ȥͤ
 *
 * @access public
 * @param string $inname ƾѤ̾
 * @param string $cginame CGI FormǤ̾
 * @param string $tmpname ƥݥơ֥Ǥ̾
 * @param string $dbname DBǤ̾
 * @param string $keyflg PKξ硢pkˤ
 * @return boolean ꤬false
 */
public function push_element
($inname, $cginame = "", $tmpname = "", $dbname = "", $keyflg = "")
{

  // ǤinnameϤ뤳ȡʤNG
  if( !isset($inname)) {
    return false;
  }
  if( "" === $inname) {
    return false;
  }

  // ŤcallƤʤå
  // XXX 񤭤ʤ̵뤹
  if (true === $this->is_name($inname)) {
    return true;
  }

  // ޤnameϿ
  parent::push_element($inname);

  // CGI̾Τ
  if ("" === $cginame) {
    $cginame = $inname;
  }
  $this->set_cgi_name($inname, $cginame);

  // ƥݥơ֥̾Τ
  if ("" === $tmpname) {
    $tmpname = $inname;
  }
  $this->set_tmp_name($inname, $tmpname);

  // DB̾Τ
  if ("" === $dbname) {
    $dbname = $inname;
  }
  $this->set_db_name($inname, $dbname);

  // keyȽ
  if(preg_match("/^(key|pk|k|ok|true|on)$/i", $keyflg)) {
    $this->push_keyname($inname);
  } else {
    $this->push_nokeyname($inname);
  }
  //
  return true;
}

/**
 * å᥽å
 *
 * ǡΤΥåԤޤvalidator
 * Υ饹ΤVirtual٥β塹˸ѤʤΤǡ
 *
 * @access public
 * @return boolean true
 */
public function check() { return true; }

/**
 * CGIξεۤ
 *
 * DBؤμưǼϹԤʤ!!
 *
 * @access public
 * @param cgi_request $req cgi_request饹Υ󥹥
 * @param boolean $empty_overwrite_flg ʸξ񤭥ե饰 trueˤȶʤʸ񤭤
 * @return boolean ꤬false
 */
public function set_from_cgi($req, $empty_overwrite_flg = false)
{
  // ǡ
  foreach($this->get_all_names() as $name) {
    // (Ȥꤢ)Ǽ
    $wk = $req->find($this->get_cgi_name($name));
    // 񤭥ե饰 false 
    if (false === $empty_overwrite_flg) {
      if ("" === $wk) {
        continue;
      }
    }
    //
    $this->set_value($name, $wk, false);
//print "$name <= $wk <br />\n";
  }

//print "set_from_cgi <BR>\n";
//print_r($this->data_);
//print "<BR>\n";

  return true;
}

//
protected function _make_session_instance()
{
  // ֥ܥǡ
  $se = new session_data_db;
  $se->init();
  $se->set_db($this->get_db());
  $se->set_id($this->get_tmp_key());
  if ("" !== $this->get_session_table_name()) {
    $se->set_tablename($this->get_session_table_name());
  }

  //
  return $se;
}

/**
 * ƥݥơ֥ؤΥǡγǼ
 *
 * @access public
 * @param session_data_obj $se ådata饹nullʤ鿷˺
 * @return boolean ꤬false
 */
public function set_to_tmp($se = null)
{
  if (true === is_null($se)) {
    // å
    if("" === $this->get_tmp_key()) {
      // ꤵƤʤк
      // XXX 顼Τۤ褤
      $this->make_tmp_key();
    }

    // ֥ܥǡ
    $se = $this->_make_session_instance();
  }

  // ߾ɤ߹
  $se->read();

  // ֥Ȥǡͤù
  foreach($this->get_all_names() as $name){
    // Ǽ
    $se->add_once($this->get_tmp_name($name), $this->get_value($name));
  }

  // 񤭹
  return $se->write();
}


/**
 * ƥݥơ֥뤫ĥ
 *
 * tmp_key꤬ʤNGˤʤΤ
 *
 * @access public
 * @param session_data_obj $se ådata饹nullʤ鿷˺
 * @return boolean ꤬false
 */
public function set_from_tmp($se = null)
{
  
  if (true === is_null($se)) {
    // å
    if("" === $this->get_tmp_key()) {
      return false;
    }

    // ֥ܥǡ
    $se = $this->_make_session_instance();
  }

  // ǡμ
  if(!($se->read())) {
    return false;
  }

  // ֥Ȥǡͤù
  foreach($this->get_all_names() as $name) {
    // Ǽ
    $wk = $se->find($this->get_tmp_name($name));
    $this->set_value($name, $wk, false);
  }

  //
  return true;
}

/**
 * DBؤϿؤΥåѡ
 *
 * ֤set_to_db
 *
 * @access public
 * @return boolean ꤬false
 */
public function set() { $this->set_to_db(); }

/**
 * DBؤϿ
 *
 * @access public
 * @return boolean ꤬false
 */
public function set_to_db()
{
//print "into set <br />\n";
  // ܤinsert
  if (!($this->insert())) {
//print "insert error <br />\n";
    // 顼ʤUpdate
    if (!($this->update())) {
//print "update error <br />\n";
      return false;
    }
  }
//print "fin set <br />\n";
  //
  return true;
}

// where
// wherehashǺäƤ
protected function _make_where()
{
  $where = array();
  foreach($this->get_all_key_names() as $name) {
    $where[ $this->get_db_name($name) ] = $this->get_data($name);
  }
  //
  return $where;
}

/**
 * ǡinsert
 *
 * Τinsert
 * DBϥɥ̤ξ֤ơPHP顼Ф褦ˤƤ
 *
 * @access public
 * @param boolean $del_flg üե饰ռʤ!!
 * @return boolean ꤬false
 */
public function insert($del_flg = false)
{
  // ǡγǼ
  $value = array();
  foreach($this->get_all_names() as $name) {
    $value[ $this->get_db_name($name) ] = $this->get_data($name);
  }
  // XXX
  if (true === $del_flg) {
    // ǡɲ
    $value['delete_date'] = calendar_util::get_now_string();
    // SQLȯ
    $sql = sql_util::make_insert($this->get_table_name() . '_delete', $value);
  } else {
    // SQLȯ
    $sql = sql_util::make_insert($this->get_table_name(), $value);
  }

  //
  return $this->_sql($sql);
}

/**
 * ǡupdate
 *
 * Τupdate
 * DBϥɥ̤ξ֤ơPHP顼Ф褦ˤƤ
 *
 * @access public
 * @return boolean ꤬false
 */
public function update()
{
  // whereʬ
  $where = $this->_make_where();

  // valueʬ
  $value = array();
  foreach($this->get_all_no_key_names() as $name) {
    $value[ $this->get_db_name($name) ] = $this->get_data($name);
  }

  // SQLȯ
  $sql = sql_util::make_update($this->get_table_name(), $value, $where);

  //
  return $this->_sql($sql);
}


/**
 * ǡdelete
 *
 * Τdelete
 * DBϥɥ̤ξ֤ơPHP顼Ф褦ˤƤ
 * ơ֥̾_deleteȤơ֥뤬硢򤽤äinsert
 *
 * @access public
 * @return boolean ꤬false
 */
public function del()
{
  // whereʬ
  $where = $this->_make_where();

  // ơ֥insert
  // XXX ե饰Ĥʤ insertäƤ̵롢٤ʤΤ
  $this->insert(true);

  // SQLȯ
  $sql = sql_util::make_delete($this->get_table_name(), $where);
  //
  return $this->_sql(sql_util::make_delete($this->get_table_name(), $where));
}

/**
 * ǡĤupdate
 *
 * ޤ껶ȯŪˤDB٤뤫դƤ
 *
 * @access public
 * @param string $sql_p sqlΥѡġŪˤsetϤSQLʸΤ
 * @return boolean ꤬false
 */
public function _mono_set_db($sql_p)
{
  //
  $where = $this->_make_where();

  // XXX 
  $sql = "UPDATE " . $this->get_table_name() . " SET " . $sql_p . " WHERE " . sql_util::make_where($where) . ";";
//print $sql . "\n";

  //
  return $this->_sql($sql);
}

/*
 * SQLȯ
 *
 * XXX SELECTǤϻȤʤȤ!!
 * publicˤϤȤɴprotectedͤ
 *
 */
public function _sql($sql)
{
//print $sql . "\n";

  //
  $ret = $this->get_db()->query($sql);
//var_dump($ret);
  if (is_null($ret)) {
    return false;
  }
  if (false === $ret) {
    return false;
  }

  return true;
}

/**
 * Τμ
 *
 * ʤkeyꤷʤNGˤʤޤ
 *
 * @access public
 * @return boolean ꤬false
 */
public function get()
{
  // whereʬκ
  $where = $this->_make_where();
  //
  return $this->_get($where);
}

/**
 * pkˤʤΤμ
 *
 * pkǤϤʤָꤵƤ͡פwhereĤमޤ
 *
 * @access public
 * @return boolean ꤬false
 */
public function get_nopk()
{
  //
  $cols = $this->get_all_names();

  // ͤΤandwhereȤ
  $where = array();
  foreach ($cols as $col) {
    //
    if ("" !== $this->get_value($col)) {
      $where[$col] = $this->get_value($col);
    }
  }
  //
  return $this->_get($where);
}

/**
 * Τμ
 *
 * ʤkeyꤷʤNGˤʤޤ
 * XXX keypkפͤꤵƤΡפѹˤʤޤ
 *
 * @access public
 * @param array &$where select˻ȤwhereѤhash
 * @return boolean ꤬false
 */
public function _get(array &$where)
{
  // SELECT κ
  $col = implode(",", $this->get_all_names());

  // SQLκ
  $sql = "SELECT " . $col . " FROM " . $this->get_table_name() . " WHERE " . sql_util::make_where($where) . ";";
//print $sql . "\n";

  // SQLȯ
//print "---------------------\n";
//var_dump($this->get_db());
//print "---------------------\n";
  $res = $this->get_db()->query($sql);
//print $sql . "\n";
//var_dump($res);
  if (is_null($res)) {
    return false;
  }
  if (false === $res) {
    return false;
  }
  // ǡʤNG
  if (false === $res->fetch()) {
    return false;
  }
//print "<br />Trap1 <br />\n";
  $count = 0;
  $all_names = $this->get_all_names();
//print_r($all_names);
//print "<br />\n";

  foreach($all_names as $name) {
//print "Trap2 <br />\n";
    // ǡ򥤥󥹥ݻ
    $this->set_value($name, $res->get_data($count), false);
//print "$name is " . $res->get_data($count) . "\n";

    //
    $count ++;
  }

  //
  return true;
}

/**
 * ϥåˤƼ
 *
 * @access public
 * @return map ϥå
 */
public function get_all_data_to_hash()
{
  $ret = array();
  // ޤϤ٤Ƥι̾򤲤
  $all_names = $this->get_all_names();

  // ǡ
  foreach($all_names as $name) {
    $ret[$name] = $this->get_value($name);
  }
  //
  return $ret;
}

/**
 * monoDicǥǡ켰ꤹ
 *
 * XXX ʿϥ᥽å
 * XXX get_all_data_to_hashΥǡˤƤߤ롧Ѿ˳
 *
 * @access public
 * @param conv󥹥 $conv ִ󥸥󥤥󥹥
 */
public function set_all_to_conv($conv)
{
  // 饹̾
  $cn = get_class($conv);
//var_dump($cn);

  foreach($this->get_all_data_to_hash() as $name => $value) {
    // ñִ
    if ('f_conv' === $cn) {
      $conv->monoDic($name, security::sanitize_html($value));
    } else
    if ('secure_conv' === $cn) {
      $conv->monoDic($name, $value);
    }
    // XXX else Ĥɤ롩
    // XXX smartyǤ뤫
  }

  //
  return true;
}


/**
 * ꤵ줿˸դ
 *
 * νˤƼưȿǥե饰ǥեtrueʤΤѤʤΤ
 * ǥեfalseˤƤ
 *
 * @access public
 * @param string $name դꤷ̾
 */
public function set_value_nowdate($name, $flg = false)
{
  return $this->set_value($name, calendar_util::get_now_string(), $flg);
}


/**
 * ꤵ줿˥ȡ
 *
 * νˤƼưȿǥե饰ǥեtrueʤΤѤʤΤ
 * ǥեfalseˤƤ
 * ȡ̾get_valueǤȤäơ
 *
 * @access public
 * @param string $name ȡꤷ̾
 */
public function set_value_token($name, $flg = false)
{
  return $this->set_value($name, tokenizer::get(), $flg);
}

/**
 * set_all_to_conv줿conv󥹥󥹤
 *
 * secure_conv󥹥󥹤֤
 * ǡsmartyϤΥ󥹥󥹤֤褦˺ľ
 *
 * @access public
 * @param string $name ȡꤷ̾
 * @return conv󥹥 ִ󥸥󥤥󥹥
 */
public function get_conv($class_name = 'secure_conv')
{
  //
  $o = new $class_name;

  //
  $this->set_all_to_conv($o);

  //
  return $o;
}

/**
 * radioܥꤹ
 *
 * @access public
 * @param array $names radioܥȤꤷ
 * @param conv󥹥 $conv ִ󥸥󥤥󥹥
 */
public function set_radio($names, $conv)
{
  foreach($names as $name) {
    conv_util::monoDicChecked($conv, $name, $this->get_value($name));
  }
}



//private:
private $dbh_;          // DBϥɥ

private $tmpname_;      // ƥݥơ֥̾
private $tmp_key_;      // ƥݥơ֥ѥ

private $tblname_;      // DBơ֥̾(Keykeyname_ǳǧ)

private $cgi_name_;     // CGI̾:hash̾
private $tmp_name_;     // ƥݥơ֥̾:hash̾
private $db_name_;      // DB̾:hash̾

private $nokeyname_;    // KeyǤϤʤ̾켰
private $keyname_;      // KeyˤʤäƤ̾켰

} // end of class

