# coding: UTF-8

#=添付画像を貼り付けるプラグインです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: img.rb 102 2011-06-27 11:08:50Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Img_plugin

	def plugin_contents(param, vars)
		src_url = get_url(param, vars)

		if src_url != nil then
			return %Q!<div><img src="#{src_url}" /></div>!
		else
			return ""
		end
	end

	def plugin_contents_inline(param, vars)
		src_url = get_url(param, vars)

		if src_url != nil then
			return %Q!<img src="#{src_url}" />!
		else
			return ""
		end
	end

	def get_url(param, vars)
		if param == nil then
			param = "1"
		end

		if param =~ /^([0-9]*)$/ then
			return "#{vars[:attachment_urls][param.to_i]}"
		else
			return nil
		end
	end

end
