# coding: UTF-8

require 'mailutils/mail_processor'

#=コマンドの標準実装
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: standard_command.rb 286 2011-09-23 07:36:02Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class StandardCommand

	attr_writer :weblog
	attr_writer :mail_parser
	attr_writer :mail_sender
	attr_writer :plugin_manager
	attr_writer :mail
	attr_writer :param

	attr_reader :report

	# public
	def run()
		M2W_LOGGER.debug("Start  #{self.class.name}.run")
		@report = {}

		if @weblog != nil then
			@weblog.mail_parser = @mail_parser if @weblog.respond_to?("mail_parser=")
			@weblog.mail_sender = @mail_sender if @weblog.respond_to?("mail_sender=")
			@weblog.plugin_manager = @plugin_manager if @weblog.respond_to?("plugin_manager=")
		end

		run_before_parsing()
		(header, content) = parse_mail_content()
		begin
			return run_after_parsing(header, content)
		ensure
			M2W_LOGGER.debug("Finish #{self.class.name}.run")
		end
	end

	# overridable
	def header_alias()
		return {}
	end

	# overridable
	def parse_mail_content
		return @mail_parser.parse_content(@mail.content, header_alias())
	end

	# overridable
	def run_before_parsing
	end

	# overridable
	def run_after_parsing(header, content)
		return true
	end

	def make_exception_contents(errors, warnings)
		result = ""

		if errors.length > 0 then
			result << "\n= エラー =\n\n"
			errors.each do |error|
				result << "*#{error.message}\n"
			end
		end

		if warnings.length > 0 then
			result << "\n= 警告 =\n\n"
			warnings.each do |warning|
				result << "*#{warning.message}\n"
			end
		end

		return result
	end

end
