# coding: UTF-8

require 'mailutils/mail_processor'
require 'plugin/command/lib/standard_command'

#=ブログ記事投稿コマンドプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: post.rb 303 2011-09-25 01:39:07Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Post_CommandPlugin < StandardCommand

	def run_before_parsing
		if @weblog != nil then
			@post_plugin = @weblog.get_post_plugin
		end
	end

	def header_alias()
		result = {}

		if @post_plugin != nil then
			result = result.merge(@post_plugin.header_alias)
		end

		return result
	end

	def run_after_parsing(header, content)
		@report = {}

		if @post_plugin != nil then
			result = @post_plugin.post(@mail.content, header, content, @mail.attachments, @param)
			@report = @post_plugin.report.clone

			if M2W_REPLY && @mail_sender != nil then
				if result then
send_content = <<"END_CONTENT"
ブログ記事の投稿に成功しました。

投稿記事のタイトル: #{@report[:title]}

投稿したブログ記事を編集したい場合は、本メールをそのまま返信すると編集用のメールが届きます。
#{make_exception_contents(@post_plugin.errors, @post_plugin.warnings)}
END_CONTENT
					@mail_sender.sendmail_as_command("get", @param, {"postid" => @report[:postid]}, send_content, @mail.from_address, [])
				else
send_content = <<"END_CONTENT"
ブログ記事の投稿に失敗しました。
#{make_exception_contents(@post_plugin.errors, @post_plugin.warnings)}
END_CONTENT
					@mail_sender.sendmail_as_command("error", @param, {}, send_content, @mail.from_address, [])
				end
			end

			return result
		end

		return false
	end

end
