#ifndef MNMODEL_H
#define MNMODEL_H

#include <wx/wx.h>
#include <wx/treebase.h>

#define MAX_WIKI_TEXT_SIZE 10000
#define MAX_BUF_SIZE       1024
#define EXT_TAG             ".txt"
#define DATE_TAG            ":''DATE'':"
#define NEW_DATA            DATE_TAG " %Y/%m/%d %H:%M:%S\n\n:''TYPE'': memo\n----\n"

#define CODE_SET_EUC_JP	    "eucJP"
#ifdef __WXMAC__
	#define CODE_SET_SYSTEM "SJIS"
#endif
#ifdef __WXMSW__
	#define CODE_SET_SYSTEM "SJIS"
#endif
#ifdef __WXMOTIF__
	#define CODE_SET_SYSTEM "eucJP"
#endif
#ifdef __WXGTK__
	#define CODE_SET_SYSTEM "eucJP"
#endif
#ifdef __WXX11__
	#define CODE_SET_SYSTEM "eucJP"
#endif




class WikiData : wxTreeItemData{

public:
	WikiData(wxString* dataDir, const char* fileName, FILE* fp);
	WikiData(wxString* dataDir); 
	~WikiData();
	const wxString* getFileName();
	const wxString* getSubject();
	const wxString* getDate();
    const wxString* getText();
    void  modText(wxString* text);
    void  modSubject(wxString* newName);
	void  save();
	void  removeDataFile();

private:
	wxString* subject;
	wxString* dataDirName;
	wxString* fileName;
	wxString* date;
	wxString* text;
};

WX_DECLARE_LIST(WikiData, WikiList);



class mnModel {

public:
    mnModel(const char* dataDir);
    ~mnModel();
    WikiList* search(const char* searchStr);
    void addWikiData(WikiData* wikiData);
	void addSearchStr(wxString* searchStr);
	void removeSearchStr(wxString searchStr);
	void modSearchStr(wxString* oldStr, wxString* newStr);
	const wxArrayString* getSearchStrList();
	WikiData* newWikiData();

private:
    wxString*      wikiDataDir;
	wxArrayString* searchStrList;
};


#endif //MNMODEL_H
