#include "mnID.h"
#include "mnDef.h"
#include "mnNotePanelController.h"
#include <wx/config.h>
#include <wx/tokenzr.h>
#include <wx/utils.h>
#include <wx/xrc/xmlres.h>

BEGIN_EVENT_TABLE(mnNotePanelController, wxEvtHandler)
	EVT_TEXT_ENTER(XRCID("searchTextCtrl"), mnNotePanelController::handleSearch)
	EVT_TREE_SEL_CHANGED(XRCID("searchTree"), mnNotePanelController::handleTreeItemSelect)
	EVT_TREE_SEL_CHANGING(XRCID("searchTree"), mnNotePanelController::handleTreeItemSelecting)
	EVT_TREE_BEGIN_LABEL_EDIT(XRCID("searchTree"), mnNotePanelController::handleBeginLabelEdit)
	EVT_TREE_END_LABEL_EDIT(XRCID("searchTree"), mnNotePanelController::handleEndLabelEdit)
	EVT_COMMAND(XRCID("wikiHtmlTextCtrl"), mnEVT_LINK_CLICK, mnNotePanelController::handleLinkClick)
END_EVENT_TABLE()

mnNotePanelController::mnNotePanelController(mnNotePanel* inPanel, wxString* inWikiDir)
{
	wiki = new mnModel(inWikiDir->mb_str());
	panel = inPanel;
}

mnNotePanelController::~mnNotePanelController()
{
}

const wxString* mnNotePanelController::getWikiDataDir()
{
	return  wiki->getWikiDataDir();
}

void mnNotePanelController::handleSearch(wxCommandEvent& event)
{
	wxString* str = new wxString(event.GetString());
	WikiList*       wikiList;
	WikiList::Node* node;

	wikiList = wiki->search(str->mb_str());

	node = wikiList->GetFirst();
	if(!node) {
		wxLogMessage(wxT("Not Found! [%s]"), (const char*)str->c_str());
		return;
	}

	if(wiki->addSearchStr(str)) {
		wiki->addSearchList(str, wikiList);
		panel->addSearchResult(wiki, str);
	}
	else { /* str is already in search list */
		delete wikiList;
	}
}

void mnNotePanelController::handleGroup(wxCommandEvent& event)
{
	WikiList*       wikiList;
	const wxArrayString*  searchStrList;
	int i;
	wxCursor normal;
	wxCursor watch(wxCURSOR_WATCH);

	panel->SetCursor(watch);
	wiki->group();
	panel->clearAllTree();
	searchStrList = wiki->getSearchStrList();
	for(i = 0; i < searchStrList->Count(); i++) {
		wxString& searchStr = searchStrList->Item(i);
		panel->addSearchResult(wiki, &searchStr);
	}
	panel->SetCursor(normal);
}

void mnNotePanelController::handleNew(wxCommandEvent& event)
{
	int             ans;
	WikiData* wikiData = wiki->newWikiData();
	wxString        plainTextStr;
	wxString        newSubjectStr;
	mnWikiDataEntryDialog* dlg = new mnWikiDataEntryDialog(panel);
	const wxString* wikiText = wikiData->getText();
	const wxString* subject  = wikiData->getSubject();

	dlg->setSubject(*subject);
	dlg->setPlainText(*wikiText);
	ans = dlg->ShowModal();

	if(ans != wxID_OK) return ;

	plainTextStr = dlg->getPlainText();
	newSubjectStr   = dlg->getSubject();
	wikiData->modText(&plainTextStr);
	wikiData->save();

	wikiData->modSubject(&newSubjectStr);

	notifyUpdate(wikiData);
	
	delete dlg;
}

void mnNotePanelController::handleRemove(wxCommandEvent& event)
{
	wxTreeItemData* item = panel->getSelectedItem();

	if(panel->isEditableTreeLabel(panel->getSelection())) { 
		if(wxMessageBox(wxT("Do you realy remove this memo?\n") + panel->getSelectedLabel(), wxT("Realy?"), wxYES_NO|wxICON_QUESTION) == wxYES){
			((WikiData*)(item))->removeDataFile();
			notifyUpdate((WikiData*)(item));
		}
		else {
			return;
		}
	}
	else {
		wiki->removeSearchStr(panel->getSelectedLabel());
		panel->removeSelectedItem();
	}

}

void mnNotePanelController::handleHighlight(wxCommandEvent& event)
{
	panel->highlightSelectedItem();
}


void mnNotePanelController::handleTreeItemSelect(wxTreeEvent& event)
{
	panel->showSelectedItemText(event);
}


void mnNotePanelController::handleTreeItemSelecting(wxTreeEvent& event)
{
}

void mnNotePanelController::handleBeginLabelEdit(wxTreeEvent& event)
{
	if(!panel->isEditableTreeLabel(event.GetItem())) event.Veto();
}

void mnNotePanelController::handleEndLabelEdit(wxTreeEvent& event)
{
	wxString newSubject   = event.GetLabel();
	wxTreeItemData* item  = panel->getSelectedItem();

	if(item == NULL) {
		return ;
	}
	
	if(newSubject.Len() == 0) {
		event.Veto();
		return;
	}

	((WikiData*)(item))->modSubject(&newSubject);

	event.Veto();

	notifyUpdate((WikiData*)item);
}

void mnNotePanelController::handleTreeExpand(wxCommandEvent& event)
{
	panel->expandAllTree();
}

void mnNotePanelController::handleTreeCollapse(wxCommandEvent& event)
{
	panel->collapseAllTree();
}

void mnNotePanelController::handleTreeClear(wxCommandEvent& event)
{
	wiki->clearSearchStrList();
	wiki->clearSearchResultList();
	panel->clearAllTree();
}

void mnNotePanelController::handleEdit(wxCommandEvent& event)
{
	wxString        plainTextStr;
	wxString        newSubjectStr;
	wxTreeItemData* itemData = panel->getSelectedItem();
	wxString        subject  = panel->getSelectedLabel();
	mnWikiDataEntryDialog* dlg = new mnWikiDataEntryDialog(panel);
	int             ans;

	if(!panel->isEditableTreeLabel(panel->getSelection())) return; /* selection is not memo data */

	const wxString* wikiText = ((WikiData*)(itemData))->getText();

	dlg->setSubject(subject);
	dlg->setPlainText(*wikiText);
	ans = dlg->ShowModal();

	if(ans != wxID_OK) return ;
	if(itemData == NULL) return ;

	plainTextStr = dlg->getPlainText();
	newSubjectStr   = dlg->getSubject();
	((WikiData*)(itemData))->modText(&plainTextStr);
	((WikiData*)(itemData))->save();

	((WikiData*)(itemData))->modSubject(&newSubjectStr);

	notifyUpdate((WikiData*)itemData);

	delete dlg;
}

void mnNotePanelController::notifyUpdate(WikiData* data)
{
	const wxArrayString*  searchStrList= wiki->getSearchStrList();
	char*  tokenList[32];

	memset(tokenList, 0, sizeof(char*)*32);
	for(int i = 0; i < searchStrList->Count(); i++) {
		wxString& searchStr = searchStrList->Item(i);
		if( wiki->makeSearchToken(searchStr.mb_str(), tokenList) ) { /* create token */
			if(wiki->matchWithToken((wxString*)(data->getFileName()), tokenList)) { /* match */
				wiki->addSearchResultList(&searchStr, data);
				panel->updateSearchResult(wiki, &searchStr);
			}
			else {                                                                  /* not match */
				if( wiki->delSearchResultList(&searchStr, data) ) { 
					panel->updateSearchResult(wiki, &searchStr); /* only when suceed to delete */
				}
			}
			for(int j = 0; tokenList[j] != NULL; j++) free(tokenList[j]);
			memset(tokenList, 0, sizeof(char*)*32);
		}
	}
	data->setOldSubjectFromCurrent(); // restore old subject
}

void mnNotePanelController::handleLinkClick(wxCommandEvent &event)
{
	const wxString* wikiDataDir;
	wxString href = event.GetString();
	wxString tag;
	wxString val;
	wxString doc;
	wxStringTokenizer tkz(href, wxT(":"));

	tag = tkz.GetNextToken();	
	val = tkz.GetNextToken();
	if(tag.CmpNoCase(wxT("mnlink")) == 0) {
		event.SetString(val);
		handleSearch(event);
	}
	else if(tag.CmpNoCase(wxT("mndoc")) == 0) {
		wikiDataDir = wiki->getWikiDataDir();
		doc = *wikiDataDir + wxT("/docs/") + val;
		openDoc(doc);
	}
	else {
		openUrl(href);
	}
}

void mnNotePanelController::handleOpenDocsDir(wxCommandEvent &event)
{
	const wxString* wikiDataDir;
	wxString cmd;
	wxString docDir;

	wikiDataDir = wiki->getWikiDataDir();
	docDir = *wikiDataDir + wxT("/docs/");

	/* create docs directory, anyway */
	cmd.sprintf(wxT("mkdir %s"), docDir.c_str());
	wxExecute(cmd);

	/* open docs directory */
	openDoc(docDir);
}

void mnNotePanelController::openUrl(wxString& url)
{
	wxString cmd;

#ifdef __WXMSW__
	cmd.sprintf(wxT("cmd /c \"start %s\""), url.c_str());
#endif

#ifdef __WXMAC__
	cmd.sprintf(wxT("open %s"), url.c_str());
#endif

#ifdef __WXCOCOA__
	cmd.sprintf(wxT("open %s"), url.c_str());
#endif

#ifdef __WXGTK__
	cmd.sprintf(wxT("gnome-open %s"), url.c_str());
#endif

	//wxExecute(argv);
	wxExecute(cmd);
}

void mnNotePanelController::openDoc(wxString& doc)
{
	wxString cmd;

#ifdef __WXMSW__
	cmd.sprintf(wxT("cmd /c \"start %s\""), doc.c_str());
#endif

#ifdef __WXMAC__
	cmd.sprintf(wxT("open %s"), doc.c_str());
#endif

#ifdef __WXCOCOA__
	cmd.sprintf(wxT("open %s"), doc.c_str());
#endif

#ifdef __WXGTK__
	cmd.sprintf(wxT("gnome-open %s"), doc.c_str());
#endif

	wxExecute(cmd);
}

