#ifndef __INC_DSCAPTURE_H__
#define __INC_DSCAPTURE_H__

#include <windows.h>
#include <tchar.h>
#include <strsafe.h>
#include <stdio.h>
#include <string.h>

// using
// http://vision.kuee.kyoto-u.ac.jp/~hiroaki/firewire/directshow.html
// http://d.hatena.ne.jp/xabre/20050714
// http://www.geekpage.jp/programming/directshow/list-capture-device.php

#include <dshow.h>
#include <qedit.h>
#include "streams.h"

#include <iostream>
#include <vector>

using namespace std;


class CGrabCB: public CUnknown, public ISampleGrabberCB
{
public:
  int *cnt;
  unsigned char *imgbuf;
  HANDLE *wevent,*cpflag;
  
  DECLARE_IUNKNOWN;

  STDMETHODIMP NonDelegatingQueryInterface(REFIID riid, void **ppv)
  {
    if( riid == IID_ISampleGrabberCB ){
      return GetInterface((ISampleGrabberCB*)this, ppv);
    }
    return CUnknown::NonDelegatingQueryInterface(riid, ppv);
  }

  // ISampleGrabberCB ̃\bh
  STDMETHODIMP SampleCB(double SampleTime, IMediaSample *pSample)
    {
      return E_NOTIMPL;
    }

  STDMETHODIMP BufferCB(double SampleTime, BYTE *pBuffer, long BufferLen);

  // RXgN^
  CGrabCB(HANDLE *wev,HANDLE *cpf,int *fcnt,unsigned char *buf);
};



class DSCapture{
 private:
  HANDLE wevent,cpflag;
  
  HRESULT hr;
  IGraphBuilder *pGraph;
  ICreateDevEnum *pDevEnum;
  IEnumMoniker *pClassEnum;
  ULONG cFetched;
  IMoniker *pMoniker;
  IBaseFilter *pSrc;
  ICaptureGraphBuilder2 *pBuilder;
  IBaseFilter *pF;
  ISampleGrabber *pSGrab;
  AM_MEDIA_TYPE mt;
  IPin *pSrcOut;
  IPin *pSGrabIN;
  IPin *pSGrabOut;
  CGrabCB *cb;
  IMediaControl *pMediaControl;
  IMediaEvent *pEvent;
  long evCode;

  int width,height;
  long sampletime;
  int framecount;
  unsigned char *image;
  
  vector <TCHAR *> devnames;

 public:
  DSCapture();
  ~DSCapture();

  int getDeviceNum(){return devnames.size();}
  void getDeviceName(int idx,char *str);

  void open(int dev);
  void start();
  void stop();
  void wait();

  void getBuffer(int *cnt,unsigned char *buf);

};

#endif
