#include "GtkCameraSelect.h"

static void on_camera_open_button_clicked(GtkButton *button,gpointer data){
  ((GtkCameraSelect *) data)->storeDeviceID();
  gtk_main_quit();
}

GtkCameraSelect::GtkCameraSelect(){
  window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window),"Camera Select");

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), hbox1);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox1, TRUE, TRUE, 0);

  label_select=gtk_label_new("Select Camera Device");
  gtk_box_pack_start (GTK_BOX (vbox1), label_select, TRUE, TRUE, 0);

  combo_devices =  gtk_combo_box_new_text ();
  gtk_box_pack_start (GTK_BOX (vbox1), combo_devices, TRUE, TRUE, 0);

  button_open=gtk_button_new_with_mnemonic("Open");
  gtk_box_pack_start (GTK_BOX (hbox1), button_open, TRUE, TRUE, 0);

  g_signal_connect ((gpointer) window, "delete_event",
                    G_CALLBACK (do_not_destroy_window),
                    NULL);

  g_signal_connect (G_OBJECT (button_open),"clicked",
		    G_CALLBACK (on_camera_open_button_clicked), this);
  
  devid=0;
}

GtkCameraSelect::~GtkCameraSelect(){
  gtk_widget_hide_all(window);
}

void GtkCameraSelect::show(){
  gtk_widget_show_all(window);
}

void GtkCameraSelect::addComboString(char *str){
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo_devices), str);
  gtk_combo_box_set_active(GTK_COMBO_BOX (combo_devices),0);
}

void GtkCameraSelect::storeDeviceID(){
  devid=gtk_combo_box_get_active (GTK_COMBO_BOX (combo_devices));
}
