#include "GtkTextView.h"

using namespace std;

GtkTextViewer::GtkTextViewer(){
  window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window),"Message Window");

  /* Create edit widget */
  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  /* Container add to main window */
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
				 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scrolledwindow),
				      GTK_SHADOW_IN);
  textview = gtk_text_view_new();
  gtk_container_add(GTK_CONTAINER(scrolledwindow), textview);
  gtk_container_add(GTK_CONTAINER(window), scrolledwindow);

  gtk_widget_set_size_request (textview,640,240);
  
  g_signal_connect ((gpointer) window, "delete_event",
                    G_CALLBACK (do_not_destroy_window),
                    NULL);
}

GtkTextViewer::~GtkTextViewer(){

}

void GtkTextViewer::show(){
  gtk_widget_show_all (window);
}

void GtkTextViewer::clearString(){
  GtkTextIter start, end ;

  /* Get Text Buffer */
  GtkTextBuffer *textbuf = gtk_text_view_get_buffer((GtkTextView *)textview) ;
  /* Clear buffer */
  gtk_text_buffer_get_start_iter ( textbuf, &start ) ;
  gtk_text_buffer_get_end_iter ( textbuf, &end ) ;
  gtk_text_buffer_delete ( textbuf, &start, &end ) ;
}

void GtkTextViewer::addString(string &str){
  addString(str.c_str(),str.size());
}

void GtkTextViewer::addString(const char *cbuf,int length){
  GtkTextIter p;
  gsize br, bw;
  gchar *text;
  GError *err = NULL;

  /* Gettextbuf */
  GtkTextBuffer *textbuf = gtk_text_view_get_buffer((GtkTextView *)textview) ;
  gtk_text_buffer_get_end_iter (textbuf, &p) ;

  if (!(text = g_locale_to_utf8(cbuf, (gssize)length, &br, &bw, &err))) {
    g_printerr ("Failed locale to UTF-8 conversion: %s\n", err->message) ;
    g_clear_error (&err) ;
    return;
  }
  /* Insert converted text */
  gtk_text_buffer_insert (textbuf, &p, text, bw) ;
  g_free(text);
}

void GtkTextViewer::addChar(const char *cbuf){
  GtkTextIter p;

  /* Gettextbuf */
  GtkTextBuffer *textbuf = gtk_text_view_get_buffer((GtkTextView *)textview) ;
  gtk_text_buffer_get_end_iter (textbuf, &p) ;

  /* Insert converted text */
  gtk_text_buffer_insert (textbuf, &p, cbuf, 1) ;
}
