#ifndef __IMAGEPROCS_H__
#define __IMAGEPROCS_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <cv.h>
#include <cvaux.h>
#include <cxcore.h>

#include <math.h>

#ifdef _MSC_VER
#include <windows.h>
#endif

#define PI (atan(1.0)*4.0)

#include "PFBundleAdjust.h"
#include "HomogeneousTransformation.h"

float FrobeniusNorm(float *emat,int length);

int FindFundamentalMatrixRANSAC(int npoint,float *plist1,float *plist2,float* result,float thresh,unsigned char *stat);
void CalcResultPair(float *emat,float *tvec0,float *rmat0,float *tvec1,float *rmat1);

void FindExtrinsicCameraParams(float *point3d,float *point2d,int num,float focal,float *result);
void FindExtrinsicCameraParamsRANSAC(float *point3d,float *point2d,int num,float focal,float *result);

int MotionStereo(int npoints,float *scp0,float *scp1,float *rmat,float *tvec,float *result);



class FeatureTracker{
 private:
  IplImage *cvogimage,*cvgimage;
  unsigned char *gbuf,*ogbuf;

  IplImage *eig_img, *temp_img;
  IplImage *prev_pyramid, *curr_pyramid;
  int corner_count,corner_count_max;
  char *status;
  CvPoint2D32f *corners1, *corners2;
  CvTermCriteria criteria;

 public:
  FeatureTracker(int nfeatures);
  ~FeatureTracker();

  void setImage(unsigned char *buf);
  void select();
  void track();
  void replace();

  void getCornersOld(float *buf);
  void getCornersCurrent(float *buf);
  void getStatus(char *buf);

  void setCorners(int newcount,float *newcorners);

  int getCornerCount(){return corner_count;}
  int getCornerCountMax(){return corner_count_max;}
};


class MonoMarkerFinder{
 private:
  IplImage *cvinimage,*cvoutimage;
  IplImage *cvrgbimage;
  unsigned char *gbuf,*inbuf,*rgbbuf;
  int marginx,marginy,wsize,wsizehalf;
  int corner_count_max,corner_count;
  int *corners;
  bool isfound;

  IplImage *cvogimage;
  unsigned char *ogbuf;
  CvPoint2D32f *corners1, *corners2;
  char *status;
  CvTermCriteria criteria;
  IplImage *eig_img, *temp_img;
  IplImage *prev_pyramid, *curr_pyramid;

  CvMemStorage *storage;

 public:
  MonoMarkerFinder();
  ~MonoMarkerFinder();

  void convertToMono(unsigned char *buf,unsigned char thresh);
  void findCorner();

  int getCornerCount(){return corner_count;}
  void getCorners(int *buf);
  void getMonoImage(unsigned char *img);

  void reset(){isfound=false;}
};




class SFMManager{
 private:
  float *features0,*features1,*features2;
  char *track_status0,*track_status1,*track_status_marged;
  unsigned char stat;
  int corner_count,corner_count_max,corner_count2;
  float *tfeatures0,*tfeatures1;
  float *fmat;
  unsigned char *fund_status;
  float *tvec0,*tvec1,*rmat0,*rmat1;
  float *tvec,*rmat,*transformation;

  float *points3d;
  float *newfeatures;

  float *param;
  float *tmppoints3d;
  float *tmppoints2d;

  float *markpose,*wmarkpose;

  BundleAdjustFilter *badj;

 public:
  SFMManager(FeatureTracker *trk);
  ~SFMManager();

  FeatureTracker *track;

  bool proc();
  void reset();

  unsigned char getStat(){return stat;}

  void getFeatures0(float *buf){
    memcpy(buf,features0,sizeof(float)*corner_count_max*2);
  }
  void getFeatures1(float *buf){
    memcpy(buf,features1,sizeof(float)*corner_count_max*2);
  }
  void getFeatures2(float *buf){
    memcpy(buf,features2,sizeof(float)*corner_count_max*2);
  }
  void getTrackStatus(char *buf){
    memcpy(buf,track_status_marged,corner_count_max);
  }
  
  void getTransformation(float *buf){
    memcpy(buf,transformation,sizeof(float)*16);
  }
  void getWorldMarkPose(float *buf){
    memcpy(buf,wmarkpose,sizeof(float)*16);
  }
  void get3DPoints(float *buf){
    memcpy(buf,points3d,sizeof(float)*corner_count*3);
  }
  int getPointsNum(){return corner_count;}

  void getTRParams(float *buf){
    memcpy(buf,param,sizeof(float)*6);
  }

  void setBundleAdjustFilter(BundleAdjustFilter *obj){badj=obj;}

};


#endif
