#include "MQOFileManager.h"

using namespace std;

bool loadTextureImage(string fname,image_struct &img){
  IplImage *cvimg;
  cvimg=cvLoadImage(fname.c_str(),CV_LOAD_IMAGE_COLOR);
  if(cvimg == NULL){
    cerr << "texture image file not found: " << fname << endl;
    return false;
  }else{
    int width=cvimg->width,height=cvimg->height;
    img.width=width;
    img.height=height;
    img.buf.resize(width*height*3);
    unsigned char *cvimgbuf=(unsigned char *)cvimg->imageData;
    int ws=cvimg->widthStep;

    int xidx0,xidx1,idx0,idx1;
    for(int k=0;k<height;k++){
      xidx0=k*ws;
      xidx1=k*width;
      for(int l=0;l<width;l++){
	idx0=xidx0+l*3;
	idx1=(xidx1+l)*3;
	for(int m=0;m<3;m++){
	  img.buf[idx1+m]=cvimgbuf[idx0+(2-m)];
	}
      }
    }
    cvReleaseImage(&cvimg);
  }
  return true;
}

bool mqoReadChank(string &str,string &chank,string &opt){
  stringstream sin(str);
  string str0,str1;

  if(!(sin>>str0)) return false;
  chank=str0;

  if(!(sin>>str0)) return false;
  if(str0=="{"){
    return true;
  }else{
    opt=str0;
    if(!(sin>>str0)) return false;
    //if(str0!="{") return false;
  }
  return true;
}
bool mqoReadMaterial(string &str,string &name,vector<float> &color,string &tex){
  stringstream sin(str);
  string str0,str1;
  string leftstr;

  if(!(sin>>str0)) return false;
  name=str0;
  //cerr << "        name: " << name << endl;
  int nameidx=str.find(name)+name.size();
  leftstr=str.substr(nameidx+1);
  //cerr << leftstr << endl;

  int rb,lb;
  /*
  while((lb=leftstr.find("("))!=string::npos &&
	(rb=leftstr.find(")"))!=string::npos &&
	lb < rb){
  */
  for(int i=0;i<10;i++){
    lb=leftstr.find("(");
    rb=leftstr.find(")");
    if(lb==string::npos ||
       rb==string::npos ||
       lb > rb) break;

    str0=leftstr.substr(0,lb);
    str1=leftstr.substr(lb+1,rb-lb-1);
    //cerr << "        " << str0  << " : " << str1 << ";" << endl;
    if(str0=="col"){
      stringstream colin(str1);
      for(int i=0;i<4;i++)
	if(!(colin>>color[i]))
	  return false;
    }else if(str0=="tex"){
      if(str1.find("\"")==0) tex=str1.substr(1,str1.size()-2);
      else tex=str1;
    }
    if(leftstr.size()>=rb+2)
      leftstr=leftstr.substr(rb+2);
    else
      break;
  }
  return true;
}
bool mqoReadVertex(string &str,vector<float> &vv){
  stringstream sin(str);
  for(int i=0;i<3;i++)
    if(!(sin >> vv[i])) return false;
  return true;
}
bool mqoReadFace(string &str,vector<int> &fv,int &mat,vector<float> &uv){
  stringstream sin(str);
  string str0,str1;
  string leftstr;

  int nv;

  if(!(sin>>nv)) return false;
  int vvidx=str.find("V");
  leftstr=str.substr(vvidx);
  //cerr << leftstr << endl;

  fv.resize(nv);
  uv.resize(nv*2);

  int rb,lb;
  /*
  while((lb=leftstr.find("("))!=string::npos &&
	(rb=leftstr.find(")"))!=string::npos &&
	lb < rb){
  */
  for(int i=0;i<10;i++){
    lb=leftstr.find("(");
    rb=leftstr.find(")");
    if(lb==string::npos ||
       rb==string::npos ||
       lb > rb) break;

    str0=leftstr.substr(0,lb);
    str1=leftstr.substr(lb+1,rb-lb-1);
    //cerr << "        " << str0  << " : " << str1 << ";" << endl;
    if(str0=="V"){
      stringstream vin(str1);
      for(int i=0;i<nv;i++)
	if(!(vin>>fv[i]))
	  return false;
    }else if(str0=="UV"){
      stringstream vin(str1);
      for(int i=0;i<nv;i++){
	if(!(vin>>uv[i*2]))
	  return false;
      	if(!(vin>>uv[i*2+1]))
	  return false;
      }
    }else if(str0=="M"){
      stringstream vin(str1);
      if(!(vin>>mat)) return false;
    }
    if(leftstr.size()>=rb+2)
      leftstr=leftstr.substr(rb+2);
    else
      break;
  }
  return true;
}


bool readMQOFile(string mqofname,GLMQOObject *glo,float scale, ostream &os){
  string buf,str0,str1;
  vector <float> vertices;
  vector <int> faces;
  vector <float> tvertices;

  vector <float> vv(3);
  vector <float> col(4);
  vector <int> fv;
  vector <float> uv; 
  int mat,omat;
  string name;
  string tex;

  image_struct img;

  {
    ifstream ifs(mqofname.c_str());
    if(!ifs){
      cerr << "mqo file not found: " << mqofname << endl;
      return false;
    }

    for(int i=0;i<2;i++){
      getline(ifs, buf);
      os << buf << endl;
    }

    char state=MQO_READ_CHANK_STATE;
    int length;
    while(state!=MQO_READ_END){
      switch(state){
      case MQO_READ_CHANK_STATE:
	if(!getline(ifs, buf)){
	  state=MQO_READ_END;
	  break;
	}
	if(mqoReadChank(buf,str0,str1)){
	  os << "  " << str0 << endl;
	  if(str0=="Material"){
	    stringstream ssin(str1);
	    if(ssin>>length)
	      state=MQO_READ_MATERIAL_STATE;
	  }else if(str0=="Object"){
	    os << "    name: " << str1 << endl;
	    state=MQO_READ_OBJECT_STATE;
	  }
	} 
	break;
      case MQO_READ_MATERIAL_STATE:
	os << "    materials: " << length << endl;

	// create GLMaterial
	glo->createMaterials(length);

	for(int i=0;i<length;i++){
	  tex="";
	  if(!getline(ifs, buf)){
	    state=MQO_READ_END;
	    break;
	  }
	  mqoReadMaterial(buf,name,col,tex);
	  os << "    " << tex << endl;
	  os << "    "
	     << col[0] << " "
	     << col[1] << " "
	     << col[2] << " "
	     << col[3] << endl;

	  GLMaterial *glmat=glo->getMaterial(i);
	  glmat->setMaterialColor(&col[0]);
	  if(tex!="" && tex!="\"\""){
	    // texturte mapping
	    loadTextureImage(tex,img);
	    glmat->setTexture(img.width,img.height,3,&(img.buf[0]));
	  }
	}

	state=MQO_READ_CHANK_STATE;
	break;
      case MQO_READ_OBJECT_STATE:
	if(!getline(ifs, buf)){
	  state=MQO_READ_END;
	  break;
	}
	{
	  stringstream ssin(buf);
	  if(!(ssin>>str0)){
	    state=MQO_READ_END;
	    break;
	  }
	  if(str0=="color"){
	    // read object color
	  }else if(str0=="vertex"){
	    if(!(ssin>>length)){
	      state=MQO_READ_END;
	      break;
	    }
	    os << "    nVertices: " << length << endl;
	    vertices.resize(length*3);
	    tvertices.resize(length*3);
	    for(int i=0;i<length;i++){
	      if(!getline(ifs, buf)){
		state=MQO_READ_END;
		break;
	      }
	      mqoReadVertex(buf,vv);
	      for(int j=0;j<3;j++)
		vertices[i*3+j]=vv[j];
	    }
	    getline(ifs, buf); // skip "}"
	  }else if(str0=="face"){
	    if(!(ssin>>length)){
	      state=MQO_READ_END;
	      break;
	    }
	    os << "    nFaces: " << length << endl;
	    faces.clear();
	    omat=-1;
	    
	    for(int i=0;i<length;i++){
	      if(!getline(ifs, buf)){
		state=MQO_READ_END;
		break;
	      }
	      mqoReadFace(buf,fv,mat,uv);

	      if(mat!=omat){
		faces.push_back(-1);
		faces.push_back(-1);
		faces.push_back(mat);
	      }
	      for(int j=0;j<fv.size();j++){
		tvertices[fv[j]*2]=uv[j*2];
		tvertices[fv[j]*2+1]=uv[j*2+1];
	      }
	      
	      // triangluration if nverts > 3
	      switch(fv.size()){
	      case 3:
		for(int j=0;j<3;j++)
		  faces.push_back(fv[j]);
		break;
	      case 4:
		faces.push_back(fv[0]);
		faces.push_back(fv[1]);
		faces.push_back(fv[2]);

		faces.push_back(fv[2]);
		faces.push_back(fv[3]);
		faces.push_back(fv[0]);

		break;
	      default:
		os << "there are too many vertices: " << fv.size() << endl;
	      }
	      omat=mat;
	    }
	    getline(ifs, buf); // skip "}"
	  }else if(str0=="}"){
	    // create glpolygon
	    glo->createPolygon();
	    GLPolygon *glpoly=glo->getPolygon(glo->nPolygons()-1);
	    glpoly->setVertices(vertices);
	    glpoly->setTexVertices(tvertices);
	    glpoly->setFaces(faces);
	    glpoly->setTexFaces(faces);

	    glo->setMaterialsToPolygon(glo->nPolygons()-1);

	    glpoly->calcNormals();
	    glpoly->calcVertexNormals();
	    glpoly->setNormalType(1);

	    glpoly->setGLList();
	    
	    state=MQO_READ_CHANK_STATE;
	  }
	}
	break;
      default:
	state=MQO_READ_END;
      }

    }

  }
  return true;
}
