#ifndef __MQOFILEMANAGER_H__
#define __MQOFILEMANAGER_H__

#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <vector>

#include <cv.h>
#include <cvaux.h>
#include <cxcore.h>
#include <highgui.h>

#include "GLObject.h"
#include "IKFilter.h"

#define MQO_READ_END -1
#define MQO_READ_CHANK_STATE 0
#define MQO_READ_MATERIAL_STATE 1
#define MQO_READ_OBJECT_STATE 2

using namespace std;

struct image_struct{
  int width;
  int height;
  vector <unsigned char> buf;
};

bool loadTextureImage(string fname,image_struct &img);

bool mqoReadChank(string &str,string &chank,string &opt);
bool mqoReadMaterial(string &str,string &name,vector<float> &color,string &tex);
bool mqoReadVertex(string &str,vector<float> &vv);
bool mqoReadFace(string &str,vector<int> &fv,int &mat,vector<float> &uv);


bool readMQOFile(string mqofname,GLMQOObject *glo,float scale, ostream &os=cout);


#endif
