#include "ObjectFileManager.h"

using namespace std;

bool readObjFile(string objfname,string mtlfname,GLObjObject *glo,float scale){
  vector <float> vertices;
  vector <int> faces;
  vector <float> mtlcolors;
  vector <string> mtlnames;
  vector <int> tmp;
  string buf,str0,str1;
  int i;

  GLPolygon *glpoly=glo->getGLPolygon();

  {
    ifstream ifs(mtlfname.c_str());
    if(!ifs){
      cerr << "material file not found: " << mtlfname << endl;
      return false;
    }
    while(getline(ifs, buf)){
      stringstream sin(buf);
      while(sin >> str0){
	if(str0=="newmtl"){
	  sin>>str1;
	  mtlnames.push_back(str1);
	}else if(str0=="Kd"){
	  for(i=0;i<3;i++){
	    sin>>str1;
	    mtlcolors.push_back(atof(str1.c_str()));
	  }
	}
      }
    }
  }

  cout << mtlnames.size() << " material types." << endl;

  // check
  if((mtlnames.size()*3)!=mtlcolors.size()){
    cerr << "invalid material format." << endl;
    return false;
  }


  {
    ifstream ifs(objfname.c_str());
    if(!ifs){
      cerr << "object file not found: " << objfname << endl;
      return false;
    }

    while(getline(ifs, buf)){
      stringstream sin(buf);
      while(sin >> str0){
	if(str0=="v"){
	  for(i=0;i<3;i++){
	    sin>>str1;
	    vertices.push_back(scale*atof(str1.c_str()));
	  }
	}else if(str0=="f"){
	  tmp.clear();
	  while(sin>>str1){
	    /*
	    int sls;
	    if((sls=str1.find("/"))==string::npos){
	      tmp.push_back(atoi(str1.c_str()));
	    }else{
	      tmp.push_back(atoi(str1.substr(0,sls).c_str()));
	    }
	    */
	    tmp.push_back(atoi(str1.c_str()));
	  }
	  for(i=2;i<(int)(tmp.size());i++){
	    faces.push_back(tmp[0]-1);
	    faces.push_back(tmp[i-1]-1);
	    faces.push_back(tmp[i]-1);
	  }
	
	}else if(str0=="usemtl"){
	  sin>>str1;

	  int mtlindex=0;

	  for(i=0;i<mtlnames.size();i++){
	    if(str1==mtlnames[i]){
	      mtlindex=i;
	      break;
	    }
	  }

	  faces.push_back(-1);
	  faces.push_back(-1);
	  faces.push_back(mtlindex);
	}
      }
    }
  }

  cout << " convert..." << endl;

  // convert to GLObjObject
  int vlength=vertices.size()/3;

  //glo->setVertices(&vertices[0],vlength);
  glpoly->setVertices(vertices);

  int flength=faces.size()/3;
  //glo->setFaces(&faces[0],flength);
  glpoly->setFaces(faces);

  cout << " calc normals..." << endl;

  //glo->calcNormals();
  //glo->calcVertexNormals();
  glpoly->calcNormals();
  glpoly->calcVertexNormals();
  
  cout << " set materials..." << endl;

  int mclength=mtlcolors.size()/3;
  //glo->setMaterialColors(&mtlcolors[0],mclength);
  glo->setMaterialColors(mtlcolors);

  glpoly->setGLList();
  cout << " done." << endl;

  return true;
}
