#include "PMDFileManager.h"

using namespace std;

bool readPMDFile(string pmdfname,GLPMDObject *glo,float scale, ostream &os){
  ifstream fin(pmdfname.c_str(),ios::in | ios::binary);

  if(!fin){
    cerr << "pmd file not found: " << pmdfname << endl;
    return false;
  }

  vector<float> vertices;
  vector<float> normals;
  vector<float> uvs;
  vector<int> faces;
  vector<float> mcolors;

  vertices.clear();
  normals.clear();
  uvs.clear();
  faces.clear();
  mcolors.clear();


  // for file path
  string pmdpath;
  string::size_type lastslashindex=pmdfname.find_last_of("/");
  if(lastslashindex != string::npos){
    pmdpath=pmdfname.substr(0,lastslashindex+1);
  }else{
    pmdpath="";
  }
  os << "file path: " << pmdpath << endl;

  // for texture
  IplImage *img;
  vector<unsigned char> imgbuf;

  GLMaterial *glm;

  unsigned int count;
  float vv;
  unsigned short ww;
  unsigned int dw;
  unsigned char bb;

  vector<int> nfaces;
  vector<int> faces2;

  // for bones
  vector<int> vertex_bones;
  vector<float> vertex_bones_weight;
  vector<int> bones_parent;
  vector<float> bones_headpos;
  vector<string> bones_names;

  vertex_bones.clear();
  vertex_bones_weight.clear();
  bones_parent.clear();
  bones_headpos.clear();
  bones_names.clear();

  // for IK
  vector<int> ik_bones;
  vector<int> ik_target_bones;
  vector < vector < int > > ik_children;
  vector<float> ik_weights;


  char cbuf[512];


  // check header
  fin.read(cbuf,3);
  cbuf[3]='\0';
  if(string(cbuf)!="Pmd"){
    os << "file is not pmd file." << endl;
    return false;
  }

  fin.read((char *)(&vv),4);
  os << "version " << vv << endl;

  fin.read(cbuf,20);
  cbuf[20]='\0';
  os << "modelname: " << cbuf <<endl;

  fin.read(cbuf,256);
  cbuf[256]='\0';
  os << "comment: " << cbuf <<endl;

  // ^ header

  // data blocks


  // vertices
  count=0;
  fin.read((char *)(&count),4);
  os << "vertices: " << count << endl;

  //fin.seekg(38*count,ios::cur);// skip
  for(int i=0;i<count;i++){
    for(int j=0;j<3;j++){
      fin.read((char *)(&vv),4);
      vertices.push_back(vv*scale);
    }
    for(int j=0;j<3;j++){
      fin.read((char *)(&vv),4);
      normals.push_back(vv);
    }
    for(int j=0;j<2;j++){
      fin.read((char *)(&vv),4);
      uvs.push_back(vv);
    }
    for(int j=0;j<2;j++){
      fin.read((char *)(&ww),2);
      vertex_bones.push_back((int)ww);
    }

    fin.read((char *)(&bb),1);
    vertex_bones_weight.push_back((float)bb/100.0);
    vertex_bones_weight.push_back((float)(100-bb)/100.0);
    
    fin.seekg(1,ios::cur);
  }


  // faces
  count=0;
  fin.read((char *)(&count),4);
  os << "faces: " << count << endl;

  //fin.seekg(2*count,ios::cur);// skip
  for(int i=0;i<count;i++){
    fin.read((char *)(&ww),2);
    faces.push_back((int)ww);
  }

  // materials
  count=0;
  fin.read((char *)(&count),4);
  os << "materials: " << count << endl;
  glo->createMaterials((int)count);
  nfaces.resize(count);

  //fin.seekg(70*count,ios::cur);// skip
  for(int i=0;i<count;i++){
    glm=glo->getMaterial(i);

    mcolors.clear();
    for(int j=0;j<4;j++){
      fin.read((char *)(&vv),4);
      mcolors.push_back(vv);
    }
    glm->setMaterialColor(&mcolors[0]);
    fin.seekg(30,ios::cur);

    fin.read((char *)(&dw),4);
    nfaces[i]=(int)dw;

    fin.read(cbuf,20);
    cbuf[20]='\0';
    //os << "  " << i << ": texture file: " << cbuf <<endl;
    string pmdimgname=string(cbuf);
    string pmdfullimgpath=pmdpath+pmdimgname;
    if(pmdimgname!=""){
      img=cvLoadImage(pmdfullimgpath.c_str(),CV_LOAD_IMAGE_COLOR);
      if(img == NULL){
	os << "texture image file not found: " << string(cbuf) << endl;
      }else{
	int width=img->width,height=img->height;
	imgbuf.resize(width*height*3);
	unsigned char *cvimgbuf=(unsigned char *)img->imageData;
	int ws=img->widthStep;

	int xidx0,xidx1,idx0,idx1;
	for(int k=0;k<height;k++){
	  xidx0=k*ws;
	  xidx1=k*width;
	  for(int l=0;l<width;l++){
	    idx0=xidx0+l*3;
	    idx1=(xidx1+l)*3;
	    for(int m=0;m<3;m++){
	      imgbuf[idx1+m]=cvimgbuf[idx0+(2-m)];
	    }
	  }
	}
	glm->setTexture(width,height,3,&imgbuf[0]);
	cvReleaseImage(&img);
      }
    }
  }

  // bones
  count=0;
  fin.read((char *)(&count),2);
  os << "bones: " << count << endl;

  //fin.seekg(39*count,ios::cur);// skip
  for(int i=0;i<count;i++){
    //fin.seekg(20,ios::cur);

    fin.read(cbuf,20);
    cbuf[20]='\0';
    bones_names.push_back(string(cbuf));
    os << "  " << i << ": bone name: " << cbuf  <<endl;

    fin.read((char *)(&ww),2);
    if(ww==0xffff) bones_parent.push_back(-1);
    else bones_parent.push_back((int)ww);

    fin.seekg(5,ios::cur);

    for(int j=0;j<3;j++){
      fin.read((char *)(&vv),4);
      bones_headpos.push_back(vv*scale);
    }

  }


  // IK
  count=0;
  fin.read((char *)(&count),2);
  os << "IK lists: " << count << endl;

  ik_children.resize(count);

  for(int i=0;i<count;i++){
    fin.read((char *)(&ww),2);
    ik_bones.push_back((int)ww);
    os << "  bone  : " << bones_names[ww].c_str() << endl;

    fin.read((char *)(&ww),2);
    ik_target_bones.push_back((int)ww);
    os << "  target: " << bones_names[ww].c_str() << endl;

    fin.read((char *)(&bb),1);
    fin.read((char *)(&ww),2); // iterations
    fin.read((char *)(&vv),4);
    ik_weights.push_back(vv);
    os << "  weight: " << vv << endl;


    for(int j=0;j<(int)bb;j++){
      fin.read((char *)(&ww),2);
      ik_children[i].push_back(ww);
    }

  }


  // ignore after all features

  os << "readed file successfully." << endl;

  // recreate to GLPolygon
  faces2.clear();
  int sum=0;
  for(int i=0;i<nfaces.size();i++){
    faces2.push_back(-1);
    faces2.push_back(-1);
    faces2.push_back(i);

    for(int j=sum;j<sum+nfaces[i];j++){
      faces2.push_back(faces[j]);
    }
    sum+=nfaces[i];
  }
  //os << "000" << endl;

  // send to GLPolygon
  GLPolygon *glpoly=glo->getGLPolygon();

  //glpoly->setVertices(vertices);
  glo->setInitVertices(vertices);
  glo->setInitNormals(normals);
  glo->setVertexWeights(vertex_bones,vertex_bones_weight);
  glpoly->setFaces(faces2);
  glpoly->setTexVertices(uvs);
  glpoly->setTexFaces(faces2);

  //os << "001" << endl;

  glo->sendMaterials();
  glo->setScale(scale);
  glo->setBones(bones_parent,bones_headpos,bones_names);

  glo->setIKBones(ik_bones);
  glo->setIKTargetBones(ik_target_bones);
  glo->setIKChildrens(ik_children);
  glo->setIKWeights(ik_weights);
  
  glo->setGLList();

  return true;
}


bool readVPDFile(string vpdfname,GLPMDObject *glo, ostream &os){
  ifstream fin(vpdfname.c_str(),ios::in);

  if(!fin){
    cerr << "vpd file not found: " << vpdfname << endl;
    return false;
  }
  os << "vpd file: " << vpdfname << endl;

  string buf,bname,str0,str1;
  float tvec[3],quat[4];

  while(getline(fin, buf)){
    if(buf.find("Bone")!=string::npos){
      // name
      bname=buf.substr(buf.find("{")+1);
      
      // trans
      getline(fin, buf);
      str0=buf.substr(2,buf.find(";"));

      str1=str0.substr(0,str0.find(","));
      str0=str0.substr(str0.find(",")+1);
      tvec[0]=atof(str1.c_str());

      str1=str0.substr(0,str0.find(","));
      str0=str0.substr(str0.find(",")+1);
      tvec[1]=atof(str1.c_str());

      tvec[2]=atof(str0.c_str());

      os << "trans: "
	   << tvec[0] << ", "
	   << tvec[1] << ", "
	   << tvec[2] << endl;

      // rot
      getline(fin, buf);
      str0=buf.substr(2,buf.find(";"));

      str1=str0.substr(0,str0.find(","));
      str0=str0.substr(str0.find(",")+1);
      quat[1]=atof(str1.c_str());

      str1=str0.substr(0,str0.find(","));
      str0=str0.substr(str0.find(",")+1);
      quat[2]=atof(str1.c_str());

      str1=str0.substr(0,str0.find(","));
      str0=str0.substr(str0.find(",")+1);
      quat[3]=atof(str1.c_str());

      quat[0]=atof(str0.c_str());
      os << "quat: "
	   << quat[0] << ", "
	   << quat[1] << ", "
	   << quat[2] << ", "
	   << quat[3] << endl;

      os << "name:" << bname.c_str() << endl;
      // set
      glo->setBonePose(bname,tvec,quat);

    }
  }
  os << "vpd file read complete." << endl;

  //glo->setBonesTransformType(BONE_LOCAL);
  glo->calcCurrentVertices();
  //glo->setGLList();

  glo->deanimate();

  return true;
}

bool writeIKVPDFile(string vpdfname,GLPMDObject *glo){
  int nbones=0;
  float *quat;

  for(int i=0;i<glo->getIKBones().size();i++){
    nbones+=glo->getIKChildrens()[i].size();
  }


  ofstream ofs(vpdfname.c_str());

  ofs << "Vocaloid Pose Data File" << endl << endl;

  ofs << "created by NiseNiseDance by h-yaguchi" << endl;

  ofs << nbones << ";" << endl << endl;

  int idx=0,bidx;

  for(int i=0;i<glo->getIKBones().size();i++){
    for(int j=0;j<glo->getIKChildrens()[i].size();j++){
      bidx=glo->getIKChildrens()[i][j];
      ofs << "Bone" << idx << "{" << glo->getBoneName(bidx) << endl;
      ofs << "  0.0,0.0,0.0;  // trans x,y,z" << endl;
      quat=glo->getBone(bidx)->getCurrentQuaternion();
      ofs << "  " << quat[1] << "," << quat[2] << "," << quat[3] << "," << quat[0] << ";  // Quaternion x,y,z,w" << endl;
      ofs << "}" << endl << endl;
    }
  }

  return true;
}


bool readVMDFile(string vmdfname,GLPMDObject *glo,bool ik,unsigned int returnframe, ostream &os){
  ifstream fin(vmdfname.c_str(),ios::in | ios::binary);

  float tvec[3];
  float rotx,roty,rotz;
  float quat[4];

  float d2r=PI/180.0;

  if(!fin){
    cerr << "vmd file not found: " << vmdfname << endl;
    return false;
  }
  os << "vmd file: " << vmdfname << endl;

  
  size_t filesize = (size_t)fin.seekg(0, ios::end).tellg();
  fin.seekg(0, ios::beg);
  os << "file size: " << filesize << endl;

  char cbuf[256];
  unsigned int dw;
  float vv;

  // file header (30 bytes?)
  fin.read(cbuf,30);
  //cbuf[25]='\0';
  if(string(cbuf)!="Vocaloid Motion Data 0002"){
    os << "file is not vmd file." << endl;
    return false;
  }

  // model name (20 bytes?)
  fin.read(cbuf,20);
  cbuf[20]='\0';
  //os << "model name: " << string(cbuf) << endl;
  os << "model name: " << cbuf << endl;

  // num of keys (4 bytes, DWORD?)
  fin.read((char *)(&dw),4);
  os << "key frames: " << dw <<endl;

  os << "estimated file size: " << 54+dw*111 << endl;

  vector<unsigned int> kflist;
  kflist.clear();
  kflist.push_back(0);

  glo->clearBoneSequence();

  int numofkeys=(int)dw;
  for(int i=0;i<numofkeys;i++){
  //for(int i=0;i<3;i++){

    // bone name (15 bytes?)
    fin.read(cbuf,15);
    cbuf[15]='\0';
    //os << " bone name: " << string(cbuf) << endl;
    os << " bone name: " << cbuf << endl;
    
    // frame (4 bytes?)
    fin.read((char *)(&dw),4);
    os << " frame: " << dw << endl;
    unsigned int frame=dw;
    if(kflist[kflist.size()-1]!=frame) kflist.push_back(frame);

    // pos (4 * 3 = 12 bytes?)
    fin.read((char *)(&vv),4);
    os << "  pos: " << vv;
    tvec[0]=vv;
    fin.read((char *)(&vv),4);
    os << ", " << vv;
    tvec[1]=vv;
    fin.read((char *)(&vv),4);
    os << ", " << vv << endl;
    tvec[2]=vv;

    // rot (4 * 4 = 16 bytes?)
    fin.read((char *)(&vv),4);
    os << "  rot: " << vv;
    quat[1]=vv;
    fin.read((char *)(&vv),4);
    os << ", " << vv;
    quat[2]=vv;
    fin.read((char *)(&vv),4);
    os << ", " << vv;
    quat[3]=vv;
    fin.read((char *)(&vv),4);
    os << ", " << vv << endl;
    quat[0]=vv;

    glo->addBoneSequence(string(cbuf),frame,tvec,quat);
    

    //// skip 68 bytes?
    // skip 64 bytes?
    fin.seekg(64,ios::cur);
  }

  // IK
  if(ik){
    IKManager *ikm=new IKManager(glo);
    int bidx;
    float tv[3];
    tv[0]=tv[1]=tv[2]=0.0;
    //float *quat;
    
    for(int k=0;k<kflist.size();k++){
      //glo->selectSequence(0);
      glo->resetPose();
      glo->selectSequence(kflist[k],false);
      ikm->reset();
      ikm->calcIK(glo);
      //glo->calcCurrentVertices();
      for(int i=0;i<glo->getIKBones().size();i++){
	for(int j=0;j<glo->getIKChildrens()[i].size();j++){
	  bidx=glo->getIKChildrens()[i][j];
	  //quat=glo->getBone(bidx)->getCurrentQuaternion();
	  glo->getBone(bidx)->addIKSequence(kflist[k]);
	}
	bidx=glo->getIKBones()[i];
	glo->getBone(bidx)->addIKSequence(kflist[k]);
      }
      
    }
    delete ikm;
  }

  // for repeat
  if(returnframe>0){
    unsigned int rfidx=returnframe+kflist[kflist.size()-1];
    glo->setReturnBoneSequence(rfidx);
  }


  //glo->setBonesTransformType(BONE_WORLD);
  //glo->calcCurrentVertices();

  glo->animate();
  return true;
}
