#ifndef __SURFMANAGER_H__
#define __SURFMANAGER_H__

#include "SURFConverter.h"

class SURFManager{
 private:
  unsigned char state;
  SURFConverter *surf;
  FeatureTracker *track;

  int nfeatures,nfeatures_max,nfeatures2,nfeatures_current;
  float *reffeatures,*serfeatures;
  float *points3d;
  float *param;

  int refwidth,refheight;
  float *src_corners,*dst_corners,*dst_corners_mm;

  char *track_status0,*track_status1,*track_status_marged;
  float *reffeatures2,*serfeatures2;

  float *reffeatures_current,*serfeatures_current;

  bool use_pca;
  bool use_lsh;
  bool use_ann;

  vector<float> reffeatvec,serfeatvec;

  int matchedi;
  int surf_result;

  // for camera parametor
  float focal;
  float cx,cy;
  float dp;

  int matched_num_thres;

 public:
  SURFManager(SURFConverter *ss,FeatureTracker *trk);
  ~SURFManager();

  void setMatchedNumThres(int num){matched_num_thres=num;}
  int getMatchedNumThres(){return matched_num_thres;}

  void setIntrinsicParams(float f,float x,float y,float d);

  SURFConverter *getSURFConverter(){return surf;}
  void setSURFConverter(SURFConverter *obj){surf=obj;}

  void setRefImage(IplImage *img);

  int proc(unsigned char *imgbuf);
  int proc(int width,int height,unsigned char *imgbuf);
  int proc(IplImage *img);
  int procRoutine(int width,int height,unsigned char *imgbuf);
  float *getMarkParam(){return param;}
  void reset(){state=0;}

  int getFeatureNum(){return nfeatures_current;}
  float *getRefFeatures(){return reffeatures_current;}
  float *getSerFeatures(){return serfeatures_current;}
  int getState(){return state;}

  float *getCorners(){return dst_corners;}

  void usePCA(boolean isuse){use_pca=isuse;}
  void useLSH(boolean isuse){use_lsh=isuse;}
  void useANN(bool isuse){use_ann=isuse;}

  int procList(unsigned char *imgbuf);
  int procList(int width,int height,unsigned char *imgbuf);
  int procList(IplImage *img);
  int procListRoutine(int width,int height,unsigned char *imgbuf);
  int getMatchedImageNO(){return matchedi;}

  int procListEX(string &fname,int num,unsigned char *imgbuf);
};




#endif
