#include "TextureBoardManager.h"

using namespace std;

bool convertImageToGLPolygon(string imgfname,GLPolygon *glpoly,float hscale,float vscale){
  IplImage *img=cvLoadImage(imgfname.c_str(),CV_LOAD_IMAGE_COLOR);

  GLMaterial *glm=new GLMaterial();

  if(img==NULL){
    cout << imgfname << ": file not found." << endl;
    return false;
  }

  // resize to 256x256
  IplImage *nimg=cvCreateImage(cvSize(256,256),IPL_DEPTH_8U,3);
  cvResize(img,nimg);

  // convert to rgb
  
  vector<unsigned char> imgbuf;
  int width=img->width,height=img->height;
  //imgbuf.resize(width*height*3);
  imgbuf.resize(256*256*3);
  //unsigned char *cvimgbuf=(unsigned char *)img->imageData;
  unsigned char *cvimgbuf=(unsigned char *)nimg->imageData;
  //int ws=img->widthStep;
  int ws=nimg->widthStep;

  int xidx0,xidx1,idx0,idx1;
  //for(int k=0;k<height;k++){
  for(int k=0;k<256;k++){
    xidx0=k*ws;
    //xidx1=k*width;
    xidx1=k*256;
    //for(int l=0;l<width;l++){
    for(int l=0;l<256;l++){
      idx0=xidx0+l*3;
      idx1=(xidx1+l)*3;
      for(int m=0;m<3;m++){
	imgbuf[idx1+m]=cvimgbuf[idx0+(2-m)];
      }
    }
  }
  //

  vector<float> verts;
  vector<int> faces;
  vector<float> norms;
  vector<float> texco;

  verts.resize(12);
  faces.resize(6);
  norms.resize(6);
  texco.resize(8);

  float hwidth=width*hscale*0.5;
  float hheight=height*vscale*0.5;

  verts[0]=-hwidth;verts[1]=-hheight;verts[2]=0.0;
  verts[3]=-hwidth;verts[4]=hheight;verts[5]=0.0;
  verts[6]=hwidth;verts[7]=-hheight;verts[8]=0.0;
  verts[9]=hwidth;verts[10]=hheight;verts[11]=0.0;

  faces[0]=0;  faces[1]=1;  faces[2]=2;
  faces[3]=1;  faces[4]=2;  faces[5]=3;

  norms[0]=0.0;  norms[1]=0.0;  norms[2]=-1.0;
  norms[3]=0.0;  norms[4]=0.0;  norms[5]=-1.0;

  texco[0]=0.0;texco[1]=0.0;
  texco[2]=0.0;texco[3]=1.0;
  texco[4]=1.0;texco[5]=0.0;
  texco[6]=1.0;texco[7]=1.0;

  glpoly->setVertices(verts);
  glpoly->setFaces(faces);
  glpoly->setNormals(norms);
  glpoly->setTexVertices(texco);
  glpoly->setTexFaces(faces);
  glpoly->setNormalType(0);

  glm->setTexture(256,256,3,&imgbuf[0]);
  cvReleaseImage(&img);
  cvReleaseImage(&nimg);

  glpoly->setMaterial(glm);
  glpoly->setGLList();

  return true;
}
