#include "VVDObject.h"

using namespace std;

float CalcTriangleArea(float *v0,float *v1,float *v2){
  float area;

  return area;
}


VVDImage::VVDImage(){
  width=640; height=480;
  buf.resize(width*height*3);
}
VVDImage::VVDImage(int w,int h){
  width=w;
  height=h;
  buf.resize(width*height*3);
}

void VVDImage::setImage(int nw,int nh,unsigned char *nbuf){
  if(width!=nw || height!=nh){
    width=nw;
    height=nh;
    buf.resize(width*height*3);
  }
  memcpy(&buf[0],nbuf,width*height*3);
}

////////////////////////////////

void VVDObject::setVertices(vector<float> &vv){
  vertices.assign(vv.begin(),vv.end());
}
void VVDObject::setFaces(vector<int> &ff){
  faces.assign(ff.begin(),ff.end());
}
void VVDObject::setTexCoords(vector<float> &tc){
  texcoords.assign(tc.begin(),tc.end());
}
void VVDObject::setTexIndexes(vector<int> &ti){
  texindexes.assign(ti.begin(),ti.end());
}

void VVDObject::setVertices(int length,float *vv){
  vertices.resize(length*3);
  memcpy(&vertices[0],vv,sizeof(float)*length*3);
}
void VVDObject::setFaces(int length,int *ff){
  faces.resize(length*3);
  memcpy(&faces[0],ff,sizeof(int)*length*3);
}
void VVDObject::setTexCoords(int length,float *tc){
  texcoords.resize(length*6);
  memcpy(&texcoords[0],tc,sizeof(float)*length*6);
}
void VVDObject::setTexIndexes(int length,int *ti){
  texindexes.resize(length);
  memcpy(&texindexes[0],ti,sizeof(int)*length);
}


void VVDObject::createVVDImageList(int num){
  images.resize(num);
  for(int i=0;i<num;i++){
    images[i]=new VVDImage(640,480);
  }
}

void VVDObject::setImage(int idx,int width,int height,unsigned char *buf){
  images[idx]->setImage(width,height,buf);
}


void VVDObject::convertImageToMaterial(){
  GLMaterial *mtl;
  VVDImage *img;
  materials.clear();
  for(int i=0;i<images.size();i++){
    mtl=new GLMaterial();
    img=images[i];
    mtl->setTexture(img->getWidth(),img->getHeight(),3,img->getBuffer());
    materials.push_back(mtl);
  }

  float col[3];
  col[0]=col[1]=col[2]=0.8;
  mtl=new GLMaterial();
  mtl->setMaterialColor(col);
  materials.push_back(mtl);
}

void VVDObject::calcFaceNormal(){
  float v0[3],v1[3],v2[3],v0v1[3],v0v2[3],norm[3];
  int vi0,vi1,vi2;

  facenormals.resize(faces.size()*2);

  for(int i=0;i<faces.size();i+=3){
    vi0=faces[i];
    vi1=faces[i+1];
    vi2=faces[i+2];

    memcpy(v0,&vertices[vi0*3],sizeof(float)*3);
    memcpy(v1,&vertices[vi1*3],sizeof(float)*3);
    memcpy(v2,&vertices[vi2*3],sizeof(float)*3);

    for(int j=0;j<3;j++){
      v0v1[j]=v1[j]-v0[j];
      v0v2[j]=v2[j]-v0[j];
    }
    OuterProduct(v0v1,v0v2,norm);
    memcpy(&facenormals[i*2+3],norm,sizeof(float)*3);
  }
}

void VVDObject::recreateFaces(){
  nfaces.clear();
  tfaces.clear();
  int idx,texidx;
  for(int i=0;i<faces.size()/3;i++){
    idx=i*3;
    texidx=texindexes[i];
    if(texidx==-1){
      nfaces.push_back(-1);
      nfaces.push_back(-1);
      nfaces.push_back(images.size());
      tfaces.push_back(-1);
      tfaces.push_back(-1);
      tfaces.push_back(images.size());
    }else{
      nfaces.push_back(-1);
      nfaces.push_back(-1);
      nfaces.push_back(texidx);
      tfaces.push_back(-1);
      tfaces.push_back(-1);
      tfaces.push_back(texidx);
    }
    for(int j=0;j<3;j++){
      nfaces.push_back(faces[idx+j]);
      tfaces.push_back(idx+j);
    }
  }
}


GLPolygon *VVDObject::createGLPolygon(){
  GLPolygon *glpoly=new GLPolygon();

  calcFaceNormal();
  convertImageToMaterial();
  recreateFaces();

  glpoly->setVertices(vertices);
  glpoly->setTexVertices(texcoords);
  glpoly->setNormals(facenormals);
  glpoly->setFaces(nfaces);
  glpoly->setTexFaces(tfaces);
  glpoly->setMaterialList(materials);
  glpoly->setNormalType(0);

  return glpoly;
}


void VVDObject::calcFaceArea(){

}

