/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.marimite.viewer.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.io.IOException;
import java.util.UUID;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.kaoriha.marimite.viewer.dnd.DnDableTabDialog;
import org.kaoriha.marimite.viewer.dnd.TabTransfer;

public class DnDableTabbedPane
extends JTabbedPane {
    private static UpdaterGenerator UPDATER_GENERATOR;
    private final DragSource dragSource = new DragSource();
    private final Window rootWindow;
    private final Updater updater = UPDATER_GENERATOR.getUpdater(this);

    public static void init(UpdaterGenerator ug) {
        UPDATER_GENERATOR = ug;
    }

    public DnDableTabbedPane(Window rootWindow) {
        this.rootWindow = rootWindow;
        this.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component c = e.getComponent();
                c.setDropTarget(new DropTarget(c, 2, new CDropTargetListener(), true));
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
            }
        });
        final DragSourceListener dsl = new DragSourceListener(){

            @Override
            public void dragEnter(DragSourceDragEvent e) {
                if (!(e.getDragSourceContext().getTransferable() instanceof TabTransfer)) {
                    return;
                }
            }

            @Override
            public void dragExit(DragSourceEvent e) {
                TabTransfer tr = (TabTransfer)e.getDragSourceContext().getTransferable();
                tr.setDropable(true);
                e.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
            }

            @Override
            public void dragOver(DragSourceDragEvent e) {
                TabTransfer tr = (TabTransfer)e.getDragSourceContext().getTransferable();
                if (tr.isDropable()) {
                    e.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
                } else {
                    e.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                }
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent e) {
                int tgtIdx;
                TabTransfer tr = (TabTransfer)e.getDragSourceContext().getTransferable();
                DnDableTabbedPane target = tr.getTargetPane();
                if (target == null) {
                    if (!tr.isDropable()) {
                        return;
                    }
                    DnDableTabDialog f = new DnDableTabDialog(tr.getSourcePane().rootWindow.getOwner(), UUID.randomUUID().toString());
                    f.setSize(tr.getSourcePane().getParent().getSize());
                    target = f.getTabbedPane();
                    Point cursor = e.getLocation();
                    Point offset = tr.getCursorOffset();
                    f.setLocation(cursor.x - offset.x, cursor.y - offset.y);
                    f.setVisible(true);
                    tgtIdx = 0;
                } else {
                    Point tgtP = e.getLocation();
                    SwingUtilities.convertPointFromScreen(tgtP, target);
                    tgtIdx = target.indexAtLocation(tgtP.x, tgtP.y);
                    if (tgtIdx == -1) {
                        tgtIdx = target.getTabCount();
                    }
                }
                int srcIdx = tr.getSourceTabIndex();
                DnDableTabbedPane source = tr.getSourcePane();
                if (source.equals(target) && tgtIdx == target.getTabCount()) {
                    --tgtIdx;
                }
                Component mc = source.getComponentAt(srcIdx);
                String mt = source.getTitleAt(srcIdx);
                Icon mi = source.getIconAt(srcIdx);
                String mtt = source.getToolTipTextAt(srcIdx);
                source.remove(srcIdx);
                target.insertTab(mt, mi, mc, mtt, tgtIdx);
                target.setSelectedIndex(tgtIdx);
                if (source.getTabCount() == 0) {
                    source.rootWindow.dispose();
                }
            }

            @Override
            public void dropActionChanged(DragSourceDragEvent e) {
            }
        };
        DragGestureListener dgl = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent e) {
                Point tabPt = e.getDragOrigin();
                int dragTabIndex = DnDableTabbedPane.this.indexAtLocation(tabPt.x, tabPt.y);
                if (dragTabIndex < 0) {
                    return;
                }
                tabPt = SwingUtilities.convertPoint(DnDableTabbedPane.this, tabPt, DnDableTabbedPane.this.rootWindow);
                try {
                    e.startDrag(DragSource.DefaultMoveDrop, new TabTransfer(DnDableTabbedPane.this, dragTabIndex, tabPt), dsl);
                }
                catch (InvalidDnDOperationException idoe) {
                    // empty catch block
                }
            }
        };
        new DropTarget(this, 2, new CDropTargetListener(), true);
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, dgl);
    }

    public void dispose() {
        this.updater.dispose();
    }

    public Window getRootWindow() {
        return this.rootWindow;
    }

    static class CDropTargetListener
    implements DropTargetListener {
        CDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            Transferable t = e.getTransferable();
            if (t == null || !e.isDataFlavorSupported(TabTransfer.FLAVOR)) {
                e.rejectDrag();
                return;
            }
            this.detectDropable(e);
            e.acceptDrag(2);
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            try {
                if (this.isDropAcceptable(e)) {
                    DnDableTabbedPane dropee = (DnDableTabbedPane)e.getDropTargetContext().getComponent();
                    TabTransfer tr = (TabTransfer)e.getTransferable().getTransferData(TabTransfer.FLAVOR);
                    tr.setTargetPane(dropee);
                    e.dropComplete(true);
                    dropee.repaint();
                } else {
                    e.dropComplete(false);
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }

        private void detectDropable(DropTargetDragEvent e) {
            Transferable t = e.getTransferable();
            try {
                TabTransfer tr = (TabTransfer)t.getTransferData(TabTransfer.FLAVOR);
                tr.setDropable(this.isAcceptable(t, e.getLocation(), e.getDropTargetContext().getComponent()) && e.getDropAction() == 2);
                return;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }

        private boolean isDropAcceptable(DropTargetDropEvent e) throws UnsupportedFlavorException, IOException {
            Transferable t = e.getTransferable();
            if (t == null || !e.isDataFlavorSupported(TabTransfer.FLAVOR)) {
                return false;
            }
            return this.isAcceptable(t, e.getLocation(), e.getDropTargetContext().getComponent());
        }

        private boolean isAcceptable(Transferable t, Point cursor, Component c) throws UnsupportedFlavorException, IOException {
            TabTransfer tr = (TabTransfer)t.getTransferData(TabTransfer.FLAVOR);
            if (tr.getSourcePane().equals(c)) {
                DnDableTabbedPane dropee = (DnDableTabbedPane)c;
                if (dropee.getBoundsAt(tr.getSourceTabIndex()).contains(cursor)) {
                    return false;
                }
                if (dropee.getSelectedIndex() == tr.getSourceTabIndex() && dropee.getSelectedComponent().getBounds().contains(cursor)) {
                    return false;
                }
            }
            return true;
        }
    }

    public static interface UpdaterGenerator {
        public Updater getUpdater(DnDableTabbedPane var1);
    }

    public static interface Updater {
        public void dispose();
    }
}

