/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.marimite.viewer.pref;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.kaoriha.marimite.viewer.pref.ClientPreference;

class LocalImpl
extends ClientPreference {
    private static final int pieceLength = 6144;
    private static final String LENGTH_KEY = "length";
    private final Preferences prefs;

    LocalImpl(String address, String path) {
        this.prefs = Preferences.userNodeForPackage(LocalImpl.class).node(address).node(path);
    }

    private byte[] object2Bytes(Object o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        return baos.toByteArray();
    }

    private Object bytes2Object(byte[] raw) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(raw);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object o = ois.readObject();
        return o;
    }

    private byte[][] breakIntoPieces(byte[] raw) {
        int numPieces = (raw.length + 6144 - 1) / 6144;
        byte[][] pieces = new byte[numPieces][];
        for (int i = 0; i < numPieces; ++i) {
            int startByte = i * 6144;
            int endByte = startByte + 6144;
            if (endByte > raw.length) {
                endByte = raw.length;
            }
            int length = endByte - startByte;
            pieces[i] = new byte[length];
            System.arraycopy(raw, startByte, pieces[i], 0, length);
        }
        return pieces;
    }

    private byte[] combinePieces(byte[][] pieces) {
        int length = 0;
        for (int i = 0; i < pieces.length; ++i) {
            length += pieces[i].length;
        }
        byte[] raw = new byte[length];
        int cursor = 0;
        for (int i = 0; i < pieces.length; ++i) {
            System.arraycopy(pieces[i], 0, raw, cursor, pieces[i].length);
            cursor += pieces[i].length;
        }
        return raw;
    }

    private void writePieces(String key, byte[][] pieces) {
        Preferences child = this.prefs.node(key);
        for (int i = 0; i < pieces.length; ++i) {
            child.putByteArray(Integer.toString(i), pieces[i]);
        }
        child.putInt(LENGTH_KEY, pieces.length);
    }

    private void putObject(String key, Object o) throws IOException, BackingStoreException, ClassNotFoundException {
        byte[] raw = this.object2Bytes(o);
        byte[][] pieces = this.breakIntoPieces(raw);
        this.writePieces(key, pieces);
    }

    private byte[][] readPieces(String key) {
        Preferences child = this.prefs.node(key);
        int numPieces = child.getInt(LENGTH_KEY, 0);
        if (numPieces == 0) {
            return null;
        }
        byte[][] pieces = new byte[numPieces][0];
        for (int i = 0; i < numPieces; ++i) {
            pieces[i] = child.getByteArray(Integer.toString(i), null);
        }
        return pieces;
    }

    private Object getObject(String key) throws IOException, BackingStoreException, ClassNotFoundException {
        byte[][] pieces = this.readPieces(key);
        if (pieces == null) {
            return null;
        }
        byte[] raw = this.combinePieces(pieces);
        Object o = this.bytes2Object(raw);
        return o;
    }

    @Override
    public Object deserialize(String key) {
        try {
            return this.getObject(key);
        }
        catch (BackingStoreException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            try {
                this.removeAll();
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            return null;
        }
        catch (IOException e) {
            try {
                this.removeAll();
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            return null;
        }
    }

    @Override
    public void serialize(String key, Serializable obj) throws IOException {
        try {
            if (obj == null) {
                this.prefs.node(key).removeNode();
            } else {
                this.putObject(key, obj);
            }
            this.prefs.flush();
        }
        catch (BackingStoreException e) {
            throw new IOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object deserialize(String key, Object alt) {
        Object o = this.deserialize(key);
        if (o == null) {
            return alt;
        }
        return o;
    }

    @Override
    public void removeAll() throws IOException {
        try {
            this.prefs.removeNode();
        }
        catch (BackingStoreException e) {
            throw new IOException(e);
        }
    }
}

