/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.kaoriha.marimite.viewer.chart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.Tick;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

/**
 *
 * @author NAKAZATO Hajime
 */
public class DateLogAxis extends LogarithmicAxis {

    private enum DateTick {

        SECOND("s", 1000L),
        MINUTE("m", 1000L * 60L),
        HOUR("h", 1000L * 60L * 60L),
        DAY("d", 1000L * 60L * 60L * 24L),
        WEEK("w", 1000L * 60L * 60L * 24L * 7L),
        YEAR("y", 1000L * 60L * 60L * 24L * 365L);
        public final String label;
        public final long val;

        DateTick(String label, long val) {
            this.label = label;
            this.val = val;
        }
    }

    public DateLogAxis() {
        super(null);
    }

    public DateLogAxis(String label) {
        super(label);
    }

    private int nextTV(int prev) {
        String ps = Integer.toString(prev);
        String start;
        switch (ps.charAt(0)) {
            case '1':
                start = "2";
                break;
            case '2':
                start = "5";
                break;
            case '5':
                start = "10";
                break;
            default:
                throw new IllegalStateException();
        }
        return Integer.parseInt(start + ps.substring(1));
    }

    @Override
    protected List refreshTicksHorizontal(Graphics2D g2,
            Rectangle2D dataArea,
            RectangleEdge edge) {
        List ticks = new java.util.ArrayList();
        Range range = getRange();

        //get lower bound value:
        double lowerBoundVal = range.getLowerBound();

        //get upper bound value
        double upperBoundVal = range.getUpperBound();

        TextAnchor anchor = null;
        TextAnchor rotationAnchor = null;
        double angle = 0.0;
        if (isVerticalTickLabels()) {
            anchor = TextAnchor.CENTER_RIGHT;
            rotationAnchor = TextAnchor.CENTER_RIGHT;
            if (edge == RectangleEdge.TOP) {
                angle = Math.PI / 2.0;
            } else {
                angle = -Math.PI / 2.0;
            }
        } else {
            if (edge == RectangleEdge.TOP) {
                anchor = TextAnchor.BOTTOM_CENTER;
                rotationAnchor = TextAnchor.BOTTOM_CENTER;
            } else {
                anchor = TextAnchor.TOP_CENTER;
                rotationAnchor = TextAnchor.TOP_CENTER;
            }
        }

        for (int i = 0; i < DateTick.values().length; i++) {
            DateTick dt = DateTick.values()[i];
            if (dt.val > upperBoundVal) {
                break;
            }
            long limit = Long.MAX_VALUE;
            if (i + 1 < DateTick.values().length) {
                if (DateTick.values()[i + 1].val < lowerBoundVal) {
                    continue;
                }
                limit = DateTick.values()[i + 1].val / 2;
            }
            for (int r = 1; dt.val * r < limit; r = nextTV(r)) {
                long currentVal = dt.val * r;
                if (currentVal > upperBoundVal) {
                    break;
                }
                Tick tick = new NumberTick(new Double(currentVal),
                        Long.toString(currentVal / dt.val) + dt.label, anchor, rotationAnchor, angle);
                ticks.add(tick);
            }
        }

        return ticks;
    }
}
