/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.kaoriha.marimite.viewer.dnd;

import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import org.kaoriha.marimite.viewer.pref.ClientPreference;

/**
 *
 * @author NAKAZATO Hajime
 */
public class PanePacker {

    private static final Set<PanePacker> INSTANCE_SET = new CopyOnWriteArraySet<PanePacker>();
    private static final String PANE_PACKER_KEY = "panePacker";
    private static ClientPreference PREF;
    private static ComponentPacker COMPONENT_PACKER;
    private final String key;
    private JTabbedPane tabbedPane;

    public static interface ComponentPacker {
        Component getComponent();
    }

    public static void init(String address, String path, ComponentPacker componentPacker) {
        PREF = ClientPreference.getInstance(address, path);
        COMPONENT_PACKER = componentPacker;
    }

    public PanePacker(String key, JTabbedPane tabbedPane) {
        this.key = key;
        this.tabbedPane = tabbedPane;

        INSTANCE_SET.add(this);
    }

    private static class PaneContainer implements Serializable {

        String title;
        String tip;
        Icon icon;

        public PaneContainer() {
        }

        public PaneContainer(String title, String tip, Icon icon) {
            this.title = title;
            this.tip = tip;
            this.icon = icon;
        }
    }

    private static class DialogContainer implements Serializable {

        ArrayList<PaneContainer> pcl;
        String key;

        public DialogContainer() {
        }

        public DialogContainer(ArrayList<PaneContainer> pcl, String key) {
            this.pcl = pcl;
            this.key = key;
        }
    }

    public static void resume(Window owner) {
        Object o = PREF.deserialize(PANE_PACKER_KEY);
        if (o == null) {
            return;
        }
        HashSet<DialogContainer> r = (HashSet<DialogContainer>) o;
        for (DialogContainer dc : r) {
            DnDableTabDialog dialog = new DnDableTabDialog(owner, dc.key);
            for (PaneContainer pc : dc.pcl) {
                dialog.getTabbedPane().addTab(pc.title, pc.icon, COMPONENT_PACKER.getComponent(), pc.tip);
            }
            dialog.setVisible(true);
        }
    }

    public static void suspend() {
        HashSet<DialogContainer> r = new HashSet<DialogContainer>();
        for (PanePacker pp : INSTANCE_SET) {
            ArrayList<PaneContainer> pcl = new ArrayList<PaneContainer>();
            DialogContainer dc = new DialogContainer(pcl, pp.key);
            for (int i = 0; i < pp.tabbedPane.getTabCount(); i++) {
                pcl.add(new PaneContainer(pp.tabbedPane.getTitleAt(i),
                        pp.tabbedPane.getToolTipTextAt(i), pp.tabbedPane.getIconAt(i)));
            }
            r.add(dc);
        }
        INSTANCE_SET.clear();

        try {
            PREF.serialize(PANE_PACKER_KEY, r);
        } catch (IOException e) {
            // ignore
        }
    }

    public void dispose() {
        INSTANCE_SET.remove(this);
    }
}
