/*
 * Decompiled with CFR 0.152.
 */
package org.maru.m4hv.extensions.validator;

import java.text.BreakIterator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;

abstract class AbstractValidityCharacter {
    private static final String COMMA_SEPARATOR = ",";
    protected ResourceBundle bundle;
    protected Set<String> keySets;

    AbstractValidityCharacter() {
    }

    protected void createKeySets(String[] keys) {
        this.keySets = new HashSet<String>();
        if (keys.length > 0) {
            for (String key : keys) {
                if (key == null || key.equals("")) continue;
                this.keySets.add(key);
            }
        } else {
            Enumeration<String> allKeys = this.bundle.getKeys();
            while (allKeys.hasMoreElements()) {
                String key = allKeys.nextElement();
                this.keySets.add(key);
            }
        }
    }

    protected boolean validateCharacter(String object) {
        BreakIterator breakIterator = BreakIterator.getCharacterInstance();
        breakIterator.setText(object);
        int start = breakIterator.first();
        int end = breakIterator.next();
        while (end != -1) {
            StringBuilder sb = new StringBuilder();
            for (int i = start; i < end; ++i) {
                sb.append(object.charAt(i));
            }
            String letter = sb.toString();
            boolean isInValid = this.checkCharacter(letter);
            if (isInValid) {
                return false;
            }
            start = end;
            end = breakIterator.next();
        }
        return true;
    }

    protected abstract boolean checkCharacter(String var1);

    protected static String[] getComparingCharacters(String value) {
        if (!value.equals(COMMA_SEPARATOR)) {
            return value.split(COMMA_SEPARATOR);
        }
        return new String[]{value};
    }
}

