/*
 * Decompiled with CFR 0.152.
 */
package org.maru.m4hv.extensions.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.maru.m4hv.extensions.constraints.Minute;
import org.maru.m4hv.extensions.util.Condition;
import org.maru.m4hv.extensions.validator.AbstractHmsValidatorForString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinuteValidatorForString
extends AbstractHmsValidatorForString
implements ConstraintValidator<Minute, String> {
    private int startMinute;
    private int endMinute;
    private static final int MIN_MINUTE = 0;
    private static final int MAX_MINUTE = 59;

    public void initialize(Minute minute) {
        this.startMinute = Condition.checkIncludedCorrectRange(minute.from(), 0, 59);
        this.endMinute = Condition.checkIncludedCorrectRange(minute.until(), 0, 59);
        this.checkProperTimeRange("minute", this.startMinute, this.endMinute);
    }

    public boolean isValid(String object, ConstraintValidatorContext constraintContext) {
        if (object == null) {
            return true;
        }
        Integer value = this.getValueAsActualType(object);
        return Condition.isIncludedInRange(value, this.startMinute, this.endMinute);
    }
}

