/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.m4hv.extensions.validator;

public final class Characters {

    private Characters(){}

    public static final int HALFWIDTH_SPACE = 0x0020;

    public static final int FULLWIDTH_SPACE = 0x3000;

    // --------------- The letter codes of Unicode Hiragana --------------- //

    // --------------- unicode hiragana letter code --------------- //
    /** The first character code of hiragana */
    public static final int START_HIRAGANA_LETTER = 0x3041;

    /** The last character code of hiragana */
    public static final int END_HIRAGANA_LETTER = 0x3096;

    // --------------- unicode hiragana voicing marks codes --------------- //
    public static final int START_VOICING_MARK = 0x3099;

    public static final int END_VOICING_MARK = 0x309C;

    // --------------- unicode hiragana iteration marks --------------- //
    public static final int HIRAGANA_ITERATION_MARK= 0x309D;

    public static final int HIRAGANA_VOICED_ITERATION_MARK = 0x309E;

    // --------------- unicode hiragana digraph --------------- //
    public static final int HIRAGANA_DIGRAPH_YORI = 0x309F;


    // --------------- The letter codes of Unicode Katakana --------------- //
    public static final int KATAKANA_HIRAGANA_DOUBLE_HYPHEN = 0x30A0;

    /** The first character code of katakana */
    public static final int START_KATAKANA_LETTER = 0x30A1;

    /** The last character code of katakana */
    public static final int END_KATAKANA_LETTER = 0x30FC;

    // --------------- unicode katakana iteration marks --------------- //
    public static final int KATAKANA_ITERATION_MARK = 0x30FD;

    public static final int KATAKANA_VOICED_ITERATION_MARK = 0x30FE;

    // --------------- unicode katakana digraph --------------- //

    public static final int KATAKANA_DIGRAPH_KOTO = 0x30FF;

    public static final int NUMBER_ZERO_LETTER = 0x0030;

    public static final int NUMBER_NINE_LETTER = 0x0039;

    // --------------- unicode halfwidth katakana code --------------- //
    public static final int HALFWIDTH_KATAKANA_START = 0xFF65;

    public static final int HALFWIDTH_KATAKANA_END = 0xFF9F;

    public static final int HALFWIDTH_CJK_PUNCTUATION_START = 0xFF61;

    public static final int HALFWIDTH_CJK_PUNCTUATION_END = 0xFF64;

}
