/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.m4hv.extensions.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import org.maru.m4hv.extensions.constraints.HalfwidthKatakana;

public class HalfwidthKatakanaValidator implements ConstraintValidator<HalfwidthKatakana, String> {

    private boolean enableHalfwidthCjkPunctuation;
    private boolean enableSpace;

    public void initialize(HalfwidthKatakana halfwidthKatakana) {
        this.enableHalfwidthCjkPunctuation = halfwidthKatakana.enableHalfwidthCjkPunctuation();
        this.enableSpace = halfwidthKatakana.enableSpace();
    }

    public boolean isValid(String object, ConstraintValidatorContext constraintContext) {
        if (object == null) {
            return true;
        }

        for (int i = 0; i < object.codePointCount(0, object.length()); i++) {
            if (object.codePointAt(i) >= Characters.HALFWIDTH_KATAKANA_START
                    && object.codePointAt(i) <= Characters.HALFWIDTH_KATAKANA_END) {
                continue;
            }
            if (enableHalfwidthCjkPunctuation == true) {
                if (object.codePointAt(i) >= Characters.HALFWIDTH_CJK_PUNCTUATION_START &&
                        object.codePointAt(i) <= Characters.HALFWIDTH_CJK_PUNCTUATION_END) {
                    continue;
                }
            }
            if (enableSpace == true) {
                if (object.codePointAt(i) == Characters.HALFWIDTH_SPACE) {
                    continue;
                }
            }
            return false;
        }
        return true;
    }

}
