/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.m4hv.extensions.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import org.maru.m4hv.extensions.constraints.ZipCode;

public class ZipCodeValidator implements ConstraintValidator<ZipCode, String> {

    private String zipCodePattern;

    public void initialize(ZipCode zipCode) {
        this.zipCodePattern = zipCode.value();
    }

    /**
     * Validates the zip code passed by the first parameter following the zip code pattern.
     */
    public boolean isValid(String object, ConstraintValidatorContext constraintContext) {
        if (object == null) {
            return true;
        }
        Pattern pattern = Pattern.compile(zipCodePattern);
        Matcher matcher = pattern.matcher(object);
        return matcher.matches();
    }

}
