/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t xfs_log_item();
const commandtable_t command_xfs_log_item =
	{"xfs_log_item", xfs_log_item, "[-a] [-f] address", "[XFS] print xfs_log_item_t table\n  -a  follow list"};
extern void prhead_xfs_log_item();
extern addr_t print_xfs_log_item();

PRIVATE addr_t xfs_trans();
const commandtable_t command_xfs_trans =
	{"xfs_trans", xfs_trans, "address", "[XFS] print xfs_trans_t table"};
extern void prhead_xfs_trans();
extern addr_t print_xfs_trans();

PRIVATE addr_t
xfs_log_item()
{
	int i, c;
	addr_t addr = 0, saddr;
	int aflag = 0;
	int full = 0;

	while ((c = getopt(argcnt, args, "af")) != EOF) {
		switch (c) {
		case 'a':
			aflag = 1;
			break;
		case 'f':
			full = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		prhead_xfs_log_item();
		for (i = optind; i < argcnt; i++) {
			addr = saddr = getvalue(args[i]);
			do {
				addr = print_xfs_log_item(addr, full);
			} while (aflag && addr && addr != saddr);
		}
	} else {
		THROW(usage);
	}
	return addr;
}

PRIVATE addr_t
xfs_trans()
{
	int i, c;
	addr_t addr;
	int aflag = 0;

	while ((c = getopt(argcnt, args, "a")) != EOF) {
		switch (c) {
		case 'a':
			aflag = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		if (aflag) {
			prhead_xfs_trans();
		}
		for (i = optind; i < argcnt; i++) {
			addr = getvalue(args[i]);
			do {
				addr = print_xfs_trans(addr, aflag);
			} while (aflag && addr);
		}
	} else {
		THROW(usage);
	}
	return addr;
}
